/*
 * Decompiled with CFR 0.152.
 */
package ch.laoe.operation;

import ch.laoe.clip.AChannelSelection;
import ch.laoe.clip.MMArray;
import ch.laoe.operation.AOperation;
import ch.laoe.ui.GProgressViewer;

public class AOPan
extends AOperation {
    public static final int HALF_MODE = 1;
    public static final int MIX_ENDS_MODE = 2;
    public static final int FULL_MODE = 3;
    private int mode;
    public static final int SQUARE_ROOT_SHAPE = -1;
    public static final int LINEAR_SHAPE = 1;
    public static final int SQUARE_SHAPE = 2;
    private int shape;
    private float pan;
    private float f11;
    private float f22;
    private float f12;
    private float f21;

    public AOPan(int n, int n2) {
        this.mode = n;
        this.shape = n2;
    }

    public AOPan(int n, int n2, float f) {
        this(n, n2);
        this.pan = f;
    }

    private void calculateMatrix(float f) {
        switch (this.mode) {
            case 2: {
                this.f11 = Math.min(1.0f, f * 2.0f - 2.0f);
                this.f22 = Math.min(1.0f, -f * 2.0f + 4.0f);
                this.f12 = 1.0f - this.f11;
                this.f21 = 1.0f - this.f22;
                break;
            }
            case 3: {
                this.f11 = f - 1.0f;
                this.f22 = -f + 2.0f;
                this.f12 = 0.0f;
                this.f21 = 0.0f;
                break;
            }
            default: {
                this.f11 = Math.min(1.0f, f * 2.0f - 2.0f);
                this.f22 = Math.min(1.0f, -f * 2.0f + 4.0f);
                this.f12 = 0.0f;
                this.f21 = 0.0f;
            }
        }
        switch (this.shape) {
            case -1: {
                this.f11 = (float)Math.sqrt(this.f11);
                this.f22 = (float)Math.sqrt(this.f22);
                this.f12 = (float)Math.sqrt(this.f12);
                this.f21 = (float)Math.sqrt(this.f21);
                break;
            }
            case 2: {
                this.f11 *= this.f11;
                this.f22 *= this.f22;
                this.f12 *= this.f12;
                this.f21 *= this.f21;
                break;
            }
        }
    }

    @Override
    public void operate(AChannelSelection aChannelSelection, AChannelSelection aChannelSelection2) {
        MMArray mMArray = aChannelSelection.getChannel().getSamples();
        MMArray mMArray2 = aChannelSelection2.getChannel().getSamples();
        int n = aChannelSelection.getOffset();
        int n2 = aChannelSelection.getLength();
        aChannelSelection.getChannel().markChange();
        aChannelSelection2.getChannel().markChange();
        try {
            this.calculateMatrix(this.pan);
            GProgressViewer.entrySubProgress();
            for (int i = 0; i < n2; ++i) {
                GProgressViewer.setProgress((i + 1) * 100 / n2);
                float f = this.f11 * mMArray.get(n + i) + this.f21 * mMArray2.get(n + i);
                float f2 = this.f22 * mMArray2.get(n + i) + this.f12 * mMArray.get(n + i);
                mMArray.set(i + n, aChannelSelection.mixIntensity(i + n, mMArray.get(i + n), f));
                mMArray2.set(i + n, aChannelSelection.mixIntensity(i + n, mMArray2.get(i + n), f2));
            }
            GProgressViewer.exitSubProgress();
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
    }

    @Override
    public void operate(AChannelSelection aChannelSelection, AChannelSelection aChannelSelection2, AChannelSelection aChannelSelection3) {
        MMArray mMArray = aChannelSelection.getChannel().getSamples();
        MMArray mMArray2 = aChannelSelection2.getChannel().getSamples();
        MMArray mMArray3 = aChannelSelection3.getChannel().getSamples();
        int n = aChannelSelection.getOffset();
        int n2 = aChannelSelection.getLength();
        aChannelSelection.getChannel().markChange();
        aChannelSelection2.getChannel().markChange();
        try {
            GProgressViewer.entrySubProgress();
            for (int i = 0; i < n2; ++i) {
                GProgressViewer.setProgress((i + 1) * 100 / n2);
                this.calculateMatrix(mMArray3.get(n + i));
                float f = this.f11 * mMArray.get(n + i) + this.f21 * mMArray2.get(n + i);
                float f2 = this.f22 * mMArray2.get(n + i) + this.f12 * mMArray.get(n + i);
                mMArray.set(i + n, aChannelSelection.mixIntensity(i + n, mMArray.get(i + n), f));
                mMArray2.set(i + n, aChannelSelection.mixIntensity(i + n, mMArray2.get(i + n), f2));
            }
            GProgressViewer.exitSubProgress();
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
    }
}

