/*
 * Decompiled with CFR 0.152.
 */
package ch.laoe.operation;

import ch.laoe.clip.AChannelSelection;
import ch.laoe.clip.MMArray;
import ch.laoe.operation.AOToolkit;
import ch.laoe.operation.AOperation;
import ch.laoe.ui.GProgressViewer;

public class AONormalize
extends AOperation {
    private float maxValue;
    private int mode;
    public static final int PEAK = 1;
    public static final int RMS = 2;

    public AONormalize(int n, float f) {
        this.mode = n;
        this.maxValue = f;
    }

    @Override
    public void operate(AChannelSelection aChannelSelection) {
        MMArray mMArray = aChannelSelection.getChannel().getSamples();
        int n = aChannelSelection.getOffset();
        int n2 = aChannelSelection.getLength();
        float f = 0.0f;
        aChannelSelection.getChannel().markChange();
        switch (this.mode) {
            case 1: {
                f = AOToolkit.max(mMArray, n, n2);
                break;
            }
            case 2: {
                f = AOToolkit.rmsAverage(mMArray, n, n2);
            }
        }
        float f2 = this.maxValue / f;
        GProgressViewer.entrySubProgress();
        for (int i = n; i < n + n2; ++i) {
            GProgressViewer.setProgress((i + 1 - n) * 100 / n2);
            mMArray.set(i, aChannelSelection.mixIntensity(i, mMArray.get(i), mMArray.get(i) * f2));
        }
        GProgressViewer.exitSubProgress();
    }
}

