/*
 * Decompiled with CFR 0.152.
 */
package ch.laoe.operation;

import ch.laoe.clip.AChannelSelection;
import ch.laoe.clip.MMArray;
import ch.laoe.operation.AOToolkit;
import ch.laoe.operation.AOperation;
import ch.laoe.ui.Debug;
import ch.laoe.ui.GProgressViewer;

public class AOMultiReverb
extends AOperation {
    private int delay;
    private float gain;
    private float dry;
    private float wet;
    private boolean negFeedback;
    private boolean backward;
    MMArray delayShape;
    MMArray gainShape;

    public AOMultiReverb(int n, float f, MMArray mMArray, MMArray mMArray2, float f2, float f3, boolean bl, boolean bl2) {
        this.delay = n;
        this.gain = f;
        this.delayShape = mMArray;
        this.gainShape = mMArray2;
        this.dry = f2;
        this.wet = f3;
        this.negFeedback = bl;
        this.backward = bl2;
    }

    public AOMultiReverb(float f, float f2, boolean bl) {
        this.delay = 1;
        this.gain = 1.0f;
        this.dry = f;
        this.wet = f2;
        this.negFeedback = false;
        this.backward = bl;
    }

    @Override
    public void operate(AChannelSelection aChannelSelection) {
        MMArray mMArray = aChannelSelection.getChannel().getSamples();
        int n = aChannelSelection.getOffset();
        int n2 = aChannelSelection.getLength();
        MMArray mMArray2 = new MMArray(n2, 0.0f);
        MMArray mMArray3 = new MMArray(n2, 0.0f);
        float f = AOToolkit.rmsAverage(mMArray, n, n2);
        aChannelSelection.getChannel().markChange();
        try {
            float f2;
            int n3;
            GProgressViewer.entrySubProgress();
            for (int i = 0; i < this.delayShape.getLength(); ++i) {
                int n4;
                GProgressViewer.setProgress((i + 1) * 100 / this.delayShape.getLength());
                if (this.backward) {
                    for (n3 = 0; n3 < mMArray2.getLength(); ++n3) {
                        mMArray2.set(n2 - 1 - n3, mMArray.get(n3 + n));
                    }
                } else {
                    mMArray2.copy(mMArray, n, 0, mMArray2.getLength());
                }
                n3 = (int)((float)this.delay * this.delayShape.get(i));
                f2 = this.gain * this.gainShape.get(i);
                for (n4 = 0; n4 < n2; ++n4) {
                    if (n4 + n3 >= n2 || n4 + n3 < 0) continue;
                    if (this.negFeedback) {
                        mMArray2.set(n4 + n3, mMArray2.get(n4 + n3) - mMArray2.get(n4) * f2);
                        continue;
                    }
                    mMArray2.set(n4 + n3, mMArray2.get(n4 + n3) + mMArray2.get(n4) * f2);
                }
                if (this.backward) {
                    for (n4 = 0; n4 < mMArray2.getLength(); ++n4) {
                        mMArray2.set(n2 - 1 - n4, mMArray2.get(n2 - 1 - n4) - mMArray.get(n4 + n));
                    }
                } else {
                    for (n4 = 0; n4 < mMArray2.getLength(); ++n4) {
                        mMArray2.set(n4, mMArray2.get(n4) - mMArray.get(n4 + n));
                    }
                }
                for (n4 = 0; n4 < n2; ++n4) {
                    mMArray3.set(n4, mMArray3.get(n4) + mMArray2.get(n4));
                }
            }
            GProgressViewer.exitSubProgress();
            float f3 = AOToolkit.rmsAverage(mMArray3, 0, n2);
            AOToolkit.multiply(mMArray3, 0, n2, f / f3);
            if (this.backward) {
                for (n3 = 0; n3 < n2; ++n3) {
                    f2 = this.dry * mMArray.get(n3 + n) + this.wet * mMArray3.get(n2 - 1 - n3);
                    mMArray.set(n3 + n, aChannelSelection.mixIntensity(n3 + n, mMArray.get(n3 + n), f2));
                }
            } else {
                for (n3 = 0; n3 < n2; ++n3) {
                    f2 = this.dry * mMArray.get(n3 + n) + this.wet * mMArray3.get(n3);
                    mMArray.set(n3 + n, aChannelSelection.mixIntensity(n3 + n, mMArray.get(n3 + n), f2));
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            Debug.printStackTrace(5, arrayIndexOutOfBoundsException);
        }
    }

    @Override
    public void operate(AChannelSelection aChannelSelection, AChannelSelection aChannelSelection2) {
        int n;
        MMArray mMArray = aChannelSelection2.getChannel().getSamples();
        int n2 = 0;
        for (n = 0; n < mMArray.getLength(); ++n) {
            if (mMArray.get(n) == 0.0f) continue;
            ++n2;
        }
        this.delayShape = new MMArray(n2, 0.0f);
        this.gainShape = new MMArray(n2, 0.0f);
        n = 0;
        for (int i = 0; i < mMArray.getLength(); ++i) {
            if (mMArray.get(i) == 0.0f) continue;
            this.delayShape.set(n, i);
            this.gainShape.set(n, mMArray.get(i));
            ++n;
        }
        this.operate(aChannelSelection);
    }
}

