/*
 * Decompiled with CFR 0.152.
 */
package ch.laoe.operation;

import ch.laoe.clip.AChannelSelection;
import ch.laoe.clip.MMArray;
import ch.laoe.operation.AOToolkit;
import ch.laoe.operation.AOperation;
import ch.laoe.ui.Debug;
import ch.laoe.ui.GProgressViewer;

public class AOMultiPitch
extends AOperation {
    private int convertBufferLength;
    private MMArray re;
    private MMArray im;
    private MMArray shRe;
    private MMArray shIm;
    private float[] pitch;
    private float[] amplitude;

    public AOMultiPitch(float[] fArray, float[] fArray2, float f, float f2, int n) {
        this.convertBufferLength = n;
        this.pitch = fArray;
        this.amplitude = fArray2;
        this.re = new MMArray(this.convertBufferLength, 0.0f);
        this.im = new MMArray(this.convertBufferLength, 0.0f);
        this.shRe = new MMArray(this.convertBufferLength / 2, 0.0f);
        this.shIm = new MMArray(this.convertBufferLength / 2, 0.0f);
    }

    @Override
    public final void operate(AChannelSelection aChannelSelection) {
        MMArray mMArray = aChannelSelection.getChannel().getSamples();
        int n = aChannelSelection.getOffset();
        int n2 = aChannelSelection.getLength();
        aChannelSelection.getChannel().markChange();
        try {
            int n3 = n2 / this.convertBufferLength + 1;
            GProgressViewer.entrySubProgress();
            for (int i = 0; i < n3; ++i) {
                int n4;
                int n5;
                GProgressViewer.setProgress((i + 1) * 100 / n3);
                for (n5 = 0; n5 < this.convertBufferLength; ++n5) {
                    n4 = n + i * this.convertBufferLength + n5;
                    if (n4 < n + n2) {
                        this.re.set(n5, mMArray.get(n4));
                    } else {
                        this.re.set(n5, 0.0f);
                    }
                    this.im.set(n5, 0.0f);
                }
                AOToolkit.complexFft(this.re, this.im);
                for (n5 = 0; n5 < this.shRe.getLength(); ++n5) {
                    this.shRe.set(n5, 0.0f);
                    this.shIm.set(n5, 0.0f);
                }
                for (n5 = 0; n5 < this.pitch.length; ++n5) {
                    if (!(this.pitch[n5] > 0.0f)) continue;
                    for (n4 = 0; n4 < this.shRe.getLength(); ++n4) {
                        float f = (float)n4 / this.pitch[n5];
                        if (f < (float)this.shRe.getLength()) {
                            this.shRe.set(n4, this.shRe.get(n4) + AOToolkit.interpolate3(this.re, f) * this.amplitude[n5]);
                        }
                        if (!(f < (float)this.shIm.getLength())) continue;
                        this.shIm.set(n4, this.shIm.get(n4) + AOToolkit.interpolate3(this.im, f) * this.amplitude[n5]);
                    }
                }
                this.re.copy(this.shRe, 0, 0, this.shRe.getLength());
                this.im.copy(this.shIm, 0, 0, this.shIm.getLength());
                AOToolkit.complexIfft(this.re, this.im);
                for (n5 = 0; n5 < this.convertBufferLength; ++n5) {
                    n4 = n + i * this.convertBufferLength + n5;
                    if (n4 >= n + n2) continue;
                    mMArray.set(n4, aChannelSelection.mixIntensity(n4, mMArray.get(n4), this.re.get(n5)));
                }
                AOToolkit.applyZeroCross(mMArray, n + i * this.convertBufferLength);
            }
            GProgressViewer.exitSubProgress();
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            Debug.printStackTrace(5, arrayIndexOutOfBoundsException);
        }
    }
}

