/*
 * Decompiled with CFR 0.152.
 */
package ch.laoe.operation;

import ch.laoe.clip.MMArray;
import ch.laoe.operation.AOToolkit;

public class AOFifo {
    private MMArray body;
    private int head;
    private int tail;
    private int maxSize;

    public AOFifo(int n) {
        this.maxSize = n + 1;
        this.body = new MMArray(this.maxSize, 0.0f);
        this.head = 0;
        this.tail = 0;
    }

    public void clear() {
        this.head = 0;
        this.tail = 0;
    }

    public void put(float f) {
        if (!this.isNotFull()) {
            this.tail = (this.tail + 1) % this.maxSize;
        }
        this.body.set(this.head, f);
        this.head = (this.head + 1) % this.maxSize;
    }

    public float get() {
        float f = this.body.get(this.tail);
        this.tail = (this.tail + 1) % this.maxSize;
        return f;
    }

    public void replace(float f, int n) {
        this.body.set((this.tail + n) % this.maxSize, f);
    }

    public float pick(float f) {
        float f2 = (float)this.tail + f;
        if (f2 < (float)this.getActualSize()) {
            return AOToolkit.interpolate2(this.body, f2);
        }
        return AOToolkit.interpolate2(this.body, f2 - (float)this.maxSize);
    }

    public float pickFromHead(float f) {
        float f2 = (float)this.head - f;
        if (f2 < 0.0f) {
            return AOToolkit.interpolate2(this.body, f2 + (float)this.maxSize);
        }
        return AOToolkit.interpolate2(this.body, f2);
    }

    public boolean isNotEmpty() {
        return this.head != this.tail;
    }

    public boolean isNotFull() {
        return (this.head + 1) % this.maxSize != this.tail;
    }

    public int getActualSize() {
        return (this.head + this.maxSize - this.tail) % this.maxSize;
    }
}

