/*
 * Decompiled with CFR 0.152.
 */
package ch.laoe.operation;

import ch.laoe.clip.AChannelSelection;
import ch.laoe.clip.MMArray;
import ch.laoe.operation.AOToolkit;
import ch.laoe.operation.AOperation;
import ch.laoe.ui.Debug;
import ch.laoe.ui.GProgressViewer;

public class AOFftFilter
extends AOperation {
    private static final int convertBufferLength = 16384;
    private static final int overlapFactor = 3;
    private MMArray re = new MMArray(16384, 0.0f);
    private MMArray im = new MMArray(16384, 0.0f);
    private MMArray kernelRe = new MMArray(16384, 0.0f);
    private MMArray kernelIm = new MMArray(16384, 0.0f);

    public AOFftFilter(MMArray mMArray) {
        this.kernelRe.copy(mMArray, 0, 0, 8192);
    }

    public static int getFilterLength() {
        return 8192;
    }

    private void operateFilter() {
        for (int i = 0; i < this.re.getLength() / 2; ++i) {
            this.re.set(i, this.re.get(i) * this.kernelRe.get(i));
            this.im.set(i, this.im.get(i) * this.kernelRe.get(i));
        }
    }

    @Override
    public final void operate(AChannelSelection aChannelSelection) {
        MMArray mMArray = aChannelSelection.getChannel().getSamples();
        int n = aChannelSelection.getOffset();
        int n2 = aChannelSelection.getLength();
        float f = AOToolkit.rmsAverage(mMArray, n, n2);
        MMArray mMArray2 = new MMArray(n2, 0.0f);
        aChannelSelection.getChannel().markChange();
        try {
            int n3;
            int n4 = 3 * n2 / 16384;
            GProgressViewer.entrySubProgress();
            for (n3 = -1; n3 < n4 + 1; ++n3) {
                int n5;
                int n6 = n + n3 * 16384 / 3;
                GProgressViewer.setProgress((n3 + 1) * 100 / n4);
                for (n5 = 0; n5 < 16384; ++n5) {
                    if (n6 + n5 >= 0 && n6 + n5 < n + n2) {
                        this.re.set(n5, mMArray.get(n6 + n5));
                    } else {
                        this.re.set(n5, 0.0f);
                    }
                    this.im.set(n5, 0.0f);
                }
                AOToolkit.applyBlackmanWindow(this.re, 16384);
                AOToolkit.complexFft(this.re, this.im);
                this.operateFilter();
                AOToolkit.complexIfft(this.re, this.im);
                for (n5 = 0; n5 < 16384; ++n5) {
                    if (n6 - n + n5 < 0 || n6 - n + n5 >= n2) continue;
                    mMArray2.set(n6 - n + n5, mMArray2.get(n6 - n + n5) + this.re.get(n5));
                }
            }
            for (n3 = 0; n3 < n2; ++n3) {
                mMArray.set(n + n3, aChannelSelection.mixIntensity(n + n3, mMArray.get(n + n3), mMArray2.get(n3)));
            }
            GProgressViewer.exitSubProgress();
            float f2 = AOToolkit.rmsAverage(mMArray, n, n2);
            AOToolkit.multiply(mMArray, n, n2, f / f2);
            AOToolkit.applyZeroCross(mMArray, n);
            AOToolkit.applyZeroCross(mMArray, n + n2);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            Debug.printStackTrace(5, arrayIndexOutOfBoundsException);
        }
    }
}

