/*
 * Decompiled with CFR 0.152.
 */
package ch.laoe.operation;

import ch.laoe.clip.AChannelSelection;
import ch.laoe.clip.MMArray;
import ch.laoe.operation.AOperation;
import ch.laoe.ui.GProgressViewer;

public class AOFade
extends AOperation {
    private int mode;
    public static final int IN = 1;
    public static final int OUT = 2;
    public static final int CROSS = 3;
    private int order;
    public static final int SQUARE_ROOT = -2;
    public static final int LINEAR = 1;
    public static final int SQUARE = 2;
    public static final int CUBIC = 3;
    private boolean continueLow;
    private float lowFactor;
    private float variableFactor;

    public AOFade(int n, int n2, float f, boolean bl) {
        this.mode = n;
        this.order = n2;
        this.lowFactor = f;
        this.variableFactor = 1.0f - f;
        this.continueLow = bl;
    }

    private float performOrder(float f) {
        switch (this.order) {
            case 1: {
                return f;
            }
            case 2: {
                return f * f;
            }
            case 3: {
                return f * f * f;
            }
            case -2: {
                return (float)Math.pow(f, 0.5);
            }
        }
        return f;
    }

    @Override
    public void operate(AChannelSelection aChannelSelection) {
        MMArray mMArray = aChannelSelection.getChannel().getSamples();
        int n = aChannelSelection.getOffset();
        int n2 = aChannelSelection.getLength();
        aChannelSelection.getChannel().markChange();
        switch (this.mode) {
            case 1: {
                try {
                    int n3;
                    GProgressViewer.entrySubProgress();
                    for (n3 = 0; n3 < n2; ++n3) {
                        GProgressViewer.setProgress((n3 + 1) * 100 / n2);
                        float f = (float)n3 / (float)n2;
                        f = this.performOrder(f);
                        mMArray.set(n + n3, mMArray.get(n + n3) * f * this.variableFactor + this.lowFactor);
                    }
                    GProgressViewer.exitSubProgress();
                    if (!this.continueLow) break;
                    for (n3 = 0; n3 < n; ++n3) {
                        mMArray.set(n3, mMArray.get(n3) * this.lowFactor);
                    }
                    break;
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    break;
                }
            }
            case 2: {
                try {
                    int n4;
                    GProgressViewer.entrySubProgress();
                    for (n4 = 0; n4 < n2; ++n4) {
                        GProgressViewer.setProgress((n4 + 1) * 100 / n2);
                        float f = (float)(n2 - n4) / (float)n2;
                        f = this.performOrder(f);
                        mMArray.set(n + n4, mMArray.get(n + n4) * f * this.variableFactor + this.lowFactor);
                    }
                    GProgressViewer.exitSubProgress();
                    if (!this.continueLow) break;
                    for (n4 = n + n2; n4 < mMArray.getLength(); ++n4) {
                        mMArray.set(n4, mMArray.get(n4) * this.lowFactor);
                    }
                    break;
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    break;
                }
            }
            case 3: {
                int n5 = n2 / 2;
                MMArray mMArray2 = new MMArray(mMArray.getLength() - n5, 0.0f);
                try {
                    GProgressViewer.entrySubProgress();
                    for (int i = 0; i < n5; ++i) {
                        GProgressViewer.setProgress((i + 1) * 100 / n5);
                        float f = (float)i / (float)n5;
                        f = this.performOrder(f);
                        float f2 = (float)(n5 - i) / (float)n5;
                        f2 = this.performOrder(f2);
                        mMArray.set(n + i, f2 * mMArray.get(n + i) + f * mMArray.get(n + n5 + i));
                    }
                    GProgressViewer.exitSubProgress();
                    mMArray2.copy(mMArray, 0, 0, n + n5);
                    mMArray2.copy(mMArray, n + n2, n + n2 - n5, mMArray.getLength() - n - n2);
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    // empty catch block
                }
                aChannelSelection.getChannel().setSamples(mMArray2);
            }
        }
    }
}

