/*
 * Decompiled with CFR 0.152.
 */
package ch.laoe.operation;

import ch.laoe.clip.AChannelSelection;
import ch.laoe.clip.MMArray;
import ch.laoe.operation.AOToolkit;
import ch.laoe.operation.AOperation;
import ch.laoe.ui.GProgressViewer;

public class AOEqualizer
extends AOperation {
    private float[] freq;
    private float[] gain;
    private float q;

    public AOEqualizer(float[] fArray, float[] fArray2, float f) {
        this.freq = fArray;
        this.gain = fArray2;
        this.q = f;
    }

    @Override
    public void operate(AChannelSelection aChannelSelection) {
        MMArray mMArray = aChannelSelection.getChannel().getSamples();
        int n = aChannelSelection.getOffset();
        int n2 = aChannelSelection.getLength();
        float f = AOToolkit.rmsAverage(mMArray, n, n2);
        MMArray mMArray2 = new MMArray(n2, 0.0f);
        aChannelSelection.getChannel().markChange();
        GProgressViewer.entrySubProgress();
        for (int i = 0; i < this.freq.length; ++i) {
            if (!((double)this.freq[i] < 0.5)) continue;
            GProgressViewer.setProgress((i + 1) * 100 / this.freq.length);
            AOToolkit.addIirBandPass(mMArray, mMArray2, n, n2, this.freq[i], this.q, this.gain[i]);
        }
        GProgressViewer.exitSubProgress();
        float f2 = AOToolkit.rmsAverage(mMArray2, 0, n2);
        AOToolkit.multiply(mMArray2, 0, n2, f / f2);
        for (int i = 0; i < n2; ++i) {
            mMArray.set(i + n, aChannelSelection.mixIntensity(i + n, mMArray.get(i + n), mMArray2.get(i)));
        }
        AOToolkit.applyZeroCross(mMArray, n);
        AOToolkit.applyZeroCross(mMArray, n + n2);
    }
}

