/*
 * Decompiled with CFR 0.152.
 */
package ch.laoe.operation;

import ch.laoe.clip.AChannelSelection;
import ch.laoe.clip.MMArray;
import ch.laoe.operation.AOToolkit;
import ch.laoe.operation.AOperation;
import ch.laoe.ui.GProgressViewer;

public class AODistort
extends AOperation {
    private float threshold;
    private float clamping;
    private int type;
    public static final int CLAMPING_TYPE = 1;
    public static final int NOISE_GATING_TYPE = 2;

    public AODistort() {
    }

    public AODistort(float f, float f2, int n) {
        this.threshold = f;
        this.clamping = f2;
        this.type = n;
    }

    @Override
    public void operate(AChannelSelection aChannelSelection) {
        MMArray mMArray = aChannelSelection.getChannel().getSamples();
        int n = aChannelSelection.getOffset();
        int n2 = aChannelSelection.getLength();
        aChannelSelection.getChannel().markChange();
        GProgressViewer.entrySubProgress();
        switch (this.type) {
            case 1: {
                for (int i = n; i < n + n2; ++i) {
                    float f = mMArray.get(i);
                    GProgressViewer.setProgress((i + 1 - n) * 100 / n2);
                    if (mMArray.get(i) > this.threshold) {
                        f = this.clamping;
                    } else if (mMArray.get(i) < -this.threshold) {
                        f = -this.clamping;
                    }
                    mMArray.set(i, aChannelSelection.mixIntensity(i, mMArray.get(i), f));
                }
                break;
            }
            case 2: {
                for (int i = n; i < n + n2; ++i) {
                    float f = mMArray.get(i);
                    GProgressViewer.setProgress((i + 1 - n) * 100 / n2);
                    if (mMArray.get(i) < this.threshold && mMArray.get(i) > 0.0f) {
                        f = this.clamping;
                    } else if (mMArray.get(i) > -this.threshold && mMArray.get(i) < 0.0f) {
                        f = -this.clamping;
                    }
                    mMArray.set(i, aChannelSelection.mixIntensity(i, mMArray.get(i), f));
                }
                break;
            }
        }
        GProgressViewer.exitSubProgress();
    }

    @Override
    public void operate(AChannelSelection aChannelSelection, AChannelSelection aChannelSelection2) {
        MMArray mMArray = aChannelSelection.getChannel().getSamples();
        int n = aChannelSelection.getOffset();
        int n2 = aChannelSelection.getLength();
        MMArray mMArray2 = aChannelSelection2.getChannel().getSamples();
        aChannelSelection.getChannel().markChange();
        GProgressViewer.entrySubProgress();
        for (int i = 0; i < n2; ++i) {
            GProgressViewer.setProgress((i + 1) * 100 / n2);
            float f = mMArray.get(i + n);
            float f2 = f >= 0.0f ? AOToolkit.interpolate3(mMArray2, f) : -AOToolkit.interpolate3(mMArray2, -f);
            mMArray.set(i + n, aChannelSelection.mixIntensity(i + n, mMArray.get(i + n), f2));
        }
        GProgressViewer.exitSubProgress();
    }
}

