/*
 * Decompiled with CFR 0.152.
 */
package ch.laoe.operation;

import ch.laoe.clip.AChannelSelection;
import ch.laoe.clip.MMArray;
import ch.laoe.operation.AOToolkit;
import ch.laoe.operation.AOperation;
import ch.laoe.ui.Debug;
import ch.laoe.ui.GProgressViewer;

public class AODisharmony
extends AOperation {
    private int convertBufferLength;
    private MMArray re;
    private MMArray im;
    private MMArray shRe;
    private MMArray shIm;
    private int type;
    public static final int SHIFT = 0;
    public static final int BLUR = 1;
    public static final int UNPITCH = 2;
    public static final int BASS_DEPHASE = 3;
    public static final int TREBLE_DEPHASE = 4;
    private float dry;
    private float wet;
    private float disharmony;

    public AODisharmony(int n, float f, float f2, float f3, int n2) {
        this.type = n;
        this.dry = f;
        this.wet = f2;
        this.disharmony = f3;
        this.convertBufferLength = n2;
        this.re = new MMArray(this.convertBufferLength, 0.0f);
        this.im = new MMArray(this.convertBufferLength, 0.0f);
        this.shRe = new MMArray(this.convertBufferLength / 2, 0.0f);
        this.shIm = new MMArray(this.convertBufferLength / 2, 0.0f);
    }

    @Override
    public final void operate(AChannelSelection aChannelSelection) {
        MMArray mMArray = aChannelSelection.getChannel().getSamples();
        int n = aChannelSelection.getOffset();
        int n2 = aChannelSelection.getLength();
        float f = AOToolkit.rmsAverage(mMArray, n, n2);
        MMArray mMArray2 = new MMArray(n2, 0.0f);
        aChannelSelection.getChannel().markChange();
        try {
            int n3;
            int n4 = 3;
            int n5 = n2 / this.convertBufferLength * n4 + 1;
            GProgressViewer.entrySubProgress();
            for (n3 = -1; n3 < n5 + 1; ++n3) {
                int n6;
                int n7;
                int n8 = n + n3 * this.convertBufferLength / n4;
                GProgressViewer.setProgress((n3 + 1) * 100 / n5);
                for (n7 = 0; n7 < this.convertBufferLength; ++n7) {
                    n6 = n8 + n7;
                    if (n6 >= 0 && n6 < n + n2) {
                        this.re.set(n7, mMArray.get(n6));
                    } else {
                        this.re.set(n7, 0.0f);
                    }
                    this.im.set(n7, 0.0f);
                }
                AOToolkit.applyBlackmanWindow(this.re, this.convertBufferLength);
                AOToolkit.complexFft(this.re, this.im);
                switch (this.type) {
                    case 0: {
                        n7 = (int)(this.disharmony * (float)this.convertBufferLength / 10.0f);
                        for (n6 = 0; n6 < this.shRe.getLength(); ++n6) {
                            if (n6 - n7 < this.re.getLength() / 2 && n6 - n7 > 0) {
                                this.shRe.set(n6, this.re.get(n6 - n7));
                                this.shIm.set(n6, this.im.get(n6 - n7));
                                continue;
                            }
                            this.shRe.set(n6, 0.0f);
                            this.shIm.set(n6, 0.0f);
                        }
                        break;
                    }
                    case 1: {
                        n7 = (int)(this.disharmony * (float)this.convertBufferLength / 5.0f);
                        for (n6 = 0; n6 < this.shRe.getLength(); ++n6) {
                            if (n6 - n7 < this.re.getLength() / 2 && n6 - n7 > 0) {
                                this.shRe.set(n6, this.re.get(n6 - n7));
                                this.shIm.set(n6, this.im.get(n6));
                                continue;
                            }
                            this.shRe.set(n6, 0.0f);
                            this.shIm.set(n6, 0.0f);
                        }
                        break;
                    }
                    case 2: {
                        float f2;
                        n7 = (int)(this.disharmony * (float)this.convertBufferLength / 5.0f);
                        for (n6 = 0; n6 < this.shRe.getLength(); ++n6) {
                            f2 = (int)((double)n6 + Math.random() * (double)n7);
                            if (f2 >= 0.0f && f2 < (float)this.shRe.getLength()) {
                                this.shRe.set(n6, AOToolkit.interpolate3(this.re, f2));
                                this.shIm.set(n6, AOToolkit.interpolate3(this.im, f2));
                                continue;
                            }
                            this.shRe.set(n6, 0.0f);
                            this.shIm.set(n6, 0.0f);
                        }
                        break;
                    }
                    case 3: {
                        float f3;
                        float f2;
                        n7 = (int)(this.disharmony * (float)this.convertBufferLength * 10.0f);
                        for (n6 = 0; n6 < this.shRe.getLength(); ++n6) {
                            f2 = AOToolkit.cartesianToMagnitude(this.re.get(n6), this.im.get(n6));
                            f3 = AOToolkit.cartesianToPhase(this.re.get(n6), this.im.get(n6));
                            this.re.set(n6, f2);
                            this.im.set(n6, f3);
                        }
                        for (n6 = 0; n6 < this.shRe.getLength(); ++n6) {
                            f2 = (int)((double)n6 + Math.random() * (double)(n7 / (n6 + 1)));
                            if (!(f2 >= 0.0f) || !(f2 < (float)this.shRe.getLength())) continue;
                            this.im.set(n6, AOToolkit.interpolate3(this.im, f2));
                        }
                        for (n6 = 0; n6 < this.shRe.getLength(); ++n6) {
                            this.shRe.set(n6, AOToolkit.polarToX(this.re.get(n6), this.im.get(n6)));
                            this.shIm.set(n6, AOToolkit.polarToY(this.re.get(n6), this.im.get(n6)));
                        }
                        break;
                    }
                    case 4: {
                        float f3;
                        float f2;
                        n7 = (int)(this.disharmony * (float)this.convertBufferLength * 10.0f);
                        for (n6 = 0; n6 < this.shRe.getLength(); ++n6) {
                            f2 = AOToolkit.cartesianToMagnitude(this.re.get(n6), this.im.get(n6));
                            f3 = AOToolkit.cartesianToPhase(this.re.get(n6), this.im.get(n6));
                            this.re.set(n6, f2);
                            this.im.set(n6, f3);
                        }
                        for (n6 = 0; n6 < this.shRe.getLength(); ++n6) {
                            f2 = (int)((double)n6 + Math.random() * (double)(n7 / (this.shRe.getLength() - n6)));
                            if (!(f2 >= 0.0f) || !(f2 < (float)this.shRe.getLength())) continue;
                            this.im.set(n6, AOToolkit.interpolate3(this.im, f2));
                        }
                        for (n6 = 0; n6 < this.shRe.getLength(); ++n6) {
                            this.shRe.set(n6, AOToolkit.polarToX(this.re.get(n6), this.im.get(n6)));
                            this.shIm.set(n6, AOToolkit.polarToY(this.re.get(n6), this.im.get(n6)));
                        }
                        break;
                    }
                }
                this.re.copy(this.shRe, 0, 0, this.shRe.getLength());
                this.im.copy(this.shIm, 0, 0, this.shIm.getLength());
                this.re.set(0, 0.0f);
                this.im.set(0, 0.0f);
                AOToolkit.complexIfft(this.re, this.im);
                for (n7 = 0; n7 < this.convertBufferLength; ++n7) {
                    if (n8 - n + n7 < 0 || n8 - n + n7 >= n2) continue;
                    mMArray2.set(n8 - n + n7, mMArray2.get(n8 - n + n7) + this.re.get(n7));
                }
            }
            for (n3 = 0; n3 < n2; ++n3) {
                mMArray.set(n + n3, aChannelSelection.mixIntensity(n + n3, mMArray.get(n + n3), mMArray2.get(n3)));
            }
            float f4 = AOToolkit.rmsAverage(mMArray, n, n2);
            AOToolkit.multiply(mMArray, n, n2, f / f4);
            AOToolkit.applyZeroCross(mMArray, n);
            AOToolkit.applyZeroCross(mMArray, n + n2);
            GProgressViewer.exitSubProgress();
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            Debug.printStackTrace(5, arrayIndexOutOfBoundsException);
        }
    }
}

