/*
 * Decompiled with CFR 0.152.
 */
package ch.laoe.operation;

import ch.laoe.clip.AChannelSelection;
import ch.laoe.clip.MMArray;
import ch.laoe.operation.AOToolkit;
import ch.laoe.operation.AOperation;
import ch.laoe.ui.GProgressViewer;
import java.util.ArrayList;

public class AODelayEcho
extends AOperation {
    private MMArray delayShape;
    private MMArray gainShape;
    private float delay;
    private float gain;
    private float dry;
    private float wet;

    public AODelayEcho(MMArray mMArray, MMArray mMArray2, float f, float f2, float f3, float f4) {
        this.delayShape = mMArray;
        this.gainShape = mMArray2;
        this.delay = f;
        this.gain = f2;
        this.dry = f3;
        this.wet = f4;
    }

    public AODelayEcho(float f, float f2) {
        this.dry = f;
        this.wet = f2;
    }

    @Override
    public void operate(AChannelSelection aChannelSelection) {
        int n;
        MMArray mMArray = aChannelSelection.getChannel().getSamples();
        int n2 = aChannelSelection.getOffset();
        int n3 = aChannelSelection.getLength();
        MMArray mMArray2 = new MMArray(n3, 0.0f);
        float f = AOToolkit.rmsAverage(mMArray, n2, n3);
        aChannelSelection.getChannel().markChange();
        GProgressViewer.entrySubProgress();
        for (int i = 0; i < n3; ++i) {
            GProgressViewer.setProgress((i + 1) * 100 / n3);
            for (n = 0; n < this.delayShape.getLength(); ++n) {
                int n4 = (int)(this.delay * this.delayShape.get(n));
                float f2 = this.gain * this.gainShape.get(n);
                if (i + n4 >= n3) continue;
                mMArray2.set(i + n4, mMArray2.get(i + n4) + mMArray.get(i + n2) * f2);
            }
        }
        GProgressViewer.exitSubProgress();
        float f3 = AOToolkit.rmsAverage(mMArray2, 0, n3);
        AOToolkit.multiply(mMArray2, 0, n3, f / f3);
        for (n = 0; n < n3; ++n) {
            float f4 = this.dry * mMArray.get(n + n2) + this.wet * mMArray2.get(n);
            mMArray.set(n + n2, aChannelSelection.mixIntensity(n + n2, mMArray.get(n + n2), f4));
        }
        AOToolkit.applyZeroCross(mMArray, n2);
        AOToolkit.applyZeroCross(mMArray, n2 + n3);
    }

    @Override
    public void operate(AChannelSelection aChannelSelection, AChannelSelection aChannelSelection2) {
        int n;
        MMArray mMArray = aChannelSelection.getChannel().getSamples();
        MMArray mMArray2 = aChannelSelection2.getChannel().getSamples();
        int n2 = aChannelSelection.getOffset();
        int n3 = aChannelSelection.getLength();
        MMArray mMArray3 = new MMArray(n3, 0.0f);
        float f = AOToolkit.rmsAverage(mMArray, n2, n3);
        aChannelSelection.getChannel().markChange();
        class Echo {
            public int delay;
            public float gain;

            public Echo(int n, float f) {
                this.delay = n;
                this.gain = f;
            }
        }
        ArrayList<Echo> arrayList = new ArrayList<Echo>(333);
        for (n = 0; n < mMArray2.getLength(); ++n) {
            if (mMArray2.get(n) == 0.0f) continue;
            arrayList.add(new Echo(n, mMArray2.get(n)));
        }
        try {
            int n4;
            GProgressViewer.entrySubProgress();
            for (n = 0; n < n3; ++n) {
                GProgressViewer.setProgress((n + 1) * 100 / n3);
                for (n4 = 0; n4 < arrayList.size(); ++n4) {
                    int n5 = ((Echo)arrayList.get((int)n4)).delay;
                    float f2 = ((Echo)arrayList.get((int)n4)).gain;
                    if (n + n5 >= n3) continue;
                    mMArray3.set(n + n5, mMArray3.get(n + n5) + mMArray.get(n + n2) * f2);
                }
            }
            GProgressViewer.exitSubProgress();
            float f3 = AOToolkit.rmsAverage(mMArray3, 0, n3);
            AOToolkit.multiply(mMArray3, 0, n3, f / f3);
            for (n4 = 0; n4 < n3; ++n4) {
                float f4 = this.dry * mMArray.get(n4 + n2) + this.wet * mMArray3.get(n4);
                mMArray.set(n4 + n2, aChannelSelection.mixIntensity(n4 + n2, mMArray.get(n4 + n2), f4));
            }
            AOToolkit.applyZeroCross(mMArray, n2);
            AOToolkit.applyZeroCross(mMArray, n2 + n3);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
    }
}

