/*
 * Decompiled with CFR 0.152.
 */
package ch.laoe.operation;

import ch.laoe.clip.AChannelSelection;
import ch.laoe.clip.MMArray;
import ch.laoe.operation.AOToolkit;
import ch.laoe.operation.AOperation;
import ch.laoe.ui.GProgressViewer;

public class AOCompressExpand
extends AOperation {
    private int sampleRate;
    private int tAttack;
    private int tRelease;
    private MMArray fx;
    private MMArray fy;
    private float meanAmplitude;

    public AOCompressExpand(int n, int n2, int n3, MMArray mMArray, MMArray mMArray2) {
        this.sampleRate = n;
        this.tAttack = n2;
        this.tRelease = n3;
        this.fx = mMArray;
        this.fy = mMArray2;
    }

    private void initAmplitude() {
        this.meanAmplitude = 1.0f;
    }

    private void updateAmplitude(float f) {
        this.meanAmplitude = (f = Math.abs(f)) > this.meanAmplitude ? AOToolkit.movingRmsAverage(this.meanAmplitude, f, this.tAttack) : AOToolkit.movingRmsAverage(this.meanAmplitude, f, this.tRelease);
    }

    @Override
    public void operate(AChannelSelection aChannelSelection) {
        MMArray mMArray = aChannelSelection.getChannel().getSamples();
        int n = aChannelSelection.getOffset();
        int n2 = aChannelSelection.getLength();
        aChannelSelection.getChannel().markChange();
        this.initAmplitude();
        try {
            GProgressViewer.entrySubProgress();
            for (int i = n; i < n + n2; ++i) {
                GProgressViewer.setProgress((i + 1 - n) * 100 / n2);
                this.updateAmplitude(mMArray.get(i));
                float f = AOToolkit.interpolate2(this.fx, this.fy, this.meanAmplitude);
                mMArray.set(i, aChannelSelection.mixIntensity(i, mMArray.get(i), mMArray.get(i) * f));
            }
            GProgressViewer.exitSubProgress();
            AOToolkit.applyZeroCross(mMArray, n);
            AOToolkit.applyZeroCross(mMArray, n + n2);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
    }

    @Override
    public void operate(AChannelSelection aChannelSelection, AChannelSelection aChannelSelection2) {
        MMArray mMArray = aChannelSelection.getChannel().getSamples();
        int n = aChannelSelection.getOffset();
        int n2 = aChannelSelection.getLength();
        MMArray mMArray2 = aChannelSelection2.getChannel().getSamples();
        aChannelSelection.getChannel().markChange();
        this.initAmplitude();
        try {
            GProgressViewer.entrySubProgress();
            for (int i = n; i < n + n2; ++i) {
                GProgressViewer.setProgress((i + 1 - n) * 100 / n2);
                this.updateAmplitude(mMArray.get(i));
                float f = mMArray2.get(aChannelSelection2.getChannel().limitIndex((int)this.meanAmplitude)) / this.meanAmplitude;
                mMArray.set(i, aChannelSelection.mixIntensity(i, mMArray.get(i), mMArray.get(i) * f));
            }
            GProgressViewer.exitSubProgress();
            AOToolkit.applyZeroCross(mMArray, n);
            AOToolkit.applyZeroCross(mMArray, n + n2);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
    }
}

