/*
 * Decompiled with CFR 0.152.
 */
package ch.laoe.clip;

import ch.laoe.ui.Debug;

public class MMArray {
    private float[] samples;
    private int length;
    private final float initialValue;

    public MMArray(int n, float f) {
        this.samples = new float[n];
        this.length = n;
        this.initialValue = f;
        if (f != 0.0f) {
            for (int i = 0; i < this.samples.length; ++i) {
                this.samples[i] = f;
            }
        }
    }

    public MMArray(MMArray mMArray) {
        this(mMArray.getLength(), 0.0f);
        System.arraycopy(mMArray.samples, 0, this.samples, 0, mMArray.getLength());
    }

    public final void destroy() {
        this.set(new float[0]);
    }

    public final void cleanup() {
        int n;
        for (n = this.samples.length - 1; n >= 0 && this.samples[n] == this.initialValue; --n) {
        }
        if (n <= this.samples.length / 2) {
            System.out.println("MMArray shrink: length=" + this.getLength() + " memory-usage=" + n);
            float[] fArray = new float[n];
            System.arraycopy(this.samples, 0, fArray, 0, fArray.length);
            this.samples = fArray;
            this.length = Math.min(this.length, this.samples.length);
        }
    }

    public final int getLength() {
        return this.length;
    }

    public final int getMemoryUsage() {
        return this.samples.length;
    }

    public final boolean isInRange(int n) {
        return n >= 0 && n < this.length;
    }

    public final float get(int n) {
        if (this.isInRange(n)) {
            return this.samples[n];
        }
        return this.initialValue;
    }

    public final void set(int n, float f) {
        if (n < 0) {
            return;
        }
        if (n >= this.samples.length) {
            this.grow(n);
        }
        if (n >= this.length) {
            this.length = n + 1;
        }
        this.samples[n] = f;
    }

    public final void set(float[] fArray) {
        this.samples = fArray;
        this.length = fArray.length;
    }

    public final void copy(MMArray mMArray, int n, int n2, int n3) {
        if (mMArray.isInRange(n) && mMArray.isInRange(n + n3 - 1) && this.isInRange(n2) && this.isInRange(n2 + n3 - 1)) {
            System.arraycopy(mMArray.samples, n, this.samples, n2, n3);
            this.length = Math.max(n2 + n3, this.length);
        } else {
            for (int i = 0; i < n3; ++i) {
                this.set(n2 + i, mMArray.get(n + i));
            }
        }
    }

    private final void grow(int n) {
        float[] fArray = new float[Math.max(this.samples.length * 2, n + 1)];
        System.arraycopy(this.samples, 0, fArray, 0, this.samples.length);
        if (this.initialValue != 0.0f) {
            for (int i = this.samples.length; i < fArray.length; ++i) {
                fArray[i] = this.initialValue;
            }
        }
        this.samples = fArray;
        this.length = n + 1;
        Debug.println(6, "MMArray grow: length=" + this.getLength() + " memory-usage=" + this.getMemoryUsage());
    }

    public static void main(String[] stringArray) {
        int n;
        int n2;
        int n3;
        System.out.println("test array with initial value of zero...");
        MMArray mMArray = new MMArray(100, 0.0f);
        if (mMArray.getLength() != 100) {
            System.out.println("failed 1");
        }
        if (!mMArray.isInRange(0)) {
            System.out.println("failed 2");
        }
        if (mMArray.isInRange(-1)) {
            System.out.println("failed 3");
        }
        if (!mMArray.isInRange(66)) {
            System.out.println("failed 4");
        }
        if (!mMArray.isInRange(99)) {
            System.out.println("failed 5");
        }
        if (mMArray.isInRange(100)) {
            System.out.println("failed 6");
        }
        if (mMArray.get(0) != 0.0f) {
            System.out.println("failed 7");
        }
        if (mMArray.get(55) != 0.0f) {
            System.out.println("failed 8");
        }
        if (mMArray.get(99) != 0.0f) {
            System.out.println("failed 9");
        }
        if (mMArray.get(333) != 0.0f) {
            System.out.println("failed 10");
        }
        mMArray.set(77, 4.0f);
        if (mMArray.get(77) != 4.0f) {
            System.out.println("failed 11");
        }
        if (mMArray.getLength() != 100) {
            System.out.println("failed 12");
        }
        mMArray.set(111, 7.0f);
        if (mMArray.get(77) != 4.0f) {
            System.out.println("failed 21");
        }
        if (mMArray.get(110) != 0.0f) {
            System.out.println("failed 22");
        }
        if (mMArray.get(111) != 7.0f) {
            System.out.println("failed 23");
        }
        if (mMArray.getLength() != 112) {
            System.out.println("failed 24");
        }
        mMArray.set(1111, 7777.0f);
        if (mMArray.get(77) != 4.0f) {
            System.out.println("failed 31");
        }
        if (mMArray.get(111) != 7.0f) {
            System.out.println("failed 32");
        }
        if (mMArray.get(1110) != 0.0f) {
            System.out.println("failed 34");
        }
        if (mMArray.get(1111) != 7777.0f) {
            System.out.println("failed 35");
        }
        if (mMArray.getLength() != 1112) {
            System.out.println("failed 36");
        }
        if (!mMArray.isInRange(0)) {
            System.out.println("failed 36a");
        }
        if (mMArray.isInRange(-1)) {
            System.out.println("failed 36b");
        }
        if (!mMArray.isInRange(66)) {
            System.out.println("failed 36c");
        }
        if (!mMArray.isInRange(99)) {
            System.out.println("failed 36d");
        }
        if (!mMArray.isInRange(100)) {
            System.out.println("failed 36e");
        }
        if (!mMArray.isInRange(1111)) {
            System.out.println("failed 36f");
        }
        if (mMArray.isInRange(1112)) {
            System.out.println("failed 36g");
        }
        if (mMArray.isInRange(999999)) {
            System.out.println("failed 36h");
        }
        System.out.println("test copied array...");
        MMArray mMArray2 = new MMArray(mMArray);
        if (mMArray2.get(77) != 4.0f) {
            System.out.println("failed 41");
        }
        if (mMArray2.get(111) != 7.0f) {
            System.out.println("failed 42");
        }
        if (mMArray2.get(1110) != 0.0f) {
            System.out.println("failed 44");
        }
        if (mMArray2.get(1111) != 7777.0f) {
            System.out.println("failed 45");
        }
        if (mMArray2.getLength() != 1112) {
            System.out.println("failed 46");
        }
        mMArray2.set(1234, 2345.0f);
        if (mMArray2.get(1234) != 2345.0f) {
            System.out.println("failed 47");
        }
        if (mMArray2.getLength() != 1235) {
            System.out.println("failed 48");
        }
        if (mMArray.get(1234) != 0.0f) {
            System.out.println("failed 49");
        }
        if (mMArray.getLength() != 1112) {
            System.out.println("failed 49b");
        }
        System.out.println("test array with initial value other than zero...");
        MMArray mMArray3 = new MMArray(100, 69.0f);
        if (mMArray3.getLength() != 100) {
            System.out.println("failed 51");
        }
        if (mMArray3.get(0) != 69.0f) {
            System.out.println("failed 52");
        }
        if (mMArray3.get(55) != 69.0f) {
            System.out.println("failed 53");
        }
        if (mMArray3.get(99) != 69.0f) {
            System.out.println("failed 54");
        }
        if (mMArray3.get(333) != 69.0f) {
            System.out.println("failed 55");
        }
        mMArray3.set(77, 4.0f);
        if (mMArray3.get(77) != 4.0f) {
            System.out.println("failed 61");
        }
        if (mMArray3.getLength() != 100) {
            System.out.println("failed 62");
        }
        mMArray3.set(111, 7.0f);
        if (mMArray3.get(77) != 4.0f) {
            System.out.println("failed 71");
        }
        if (mMArray3.get(110) != 69.0f) {
            System.out.println("failed 72");
        }
        if (mMArray3.get(111) != 7.0f) {
            System.out.println("failed 73");
        }
        if (mMArray3.getLength() != 112) {
            System.out.println("failed 74");
        }
        mMArray3.set(1111, 7777.0f);
        if (mMArray3.get(77) != 4.0f) {
            System.out.println("failed 81");
        }
        if (mMArray3.get(111) != 7.0f) {
            System.out.println("failed 82");
        }
        if (mMArray3.get(1110) != 69.0f) {
            System.out.println("failed 84");
        }
        if (mMArray3.get(1111) != 7777.0f) {
            System.out.println("failed 85");
        }
        if (mMArray3.getLength() != 1112) {
            System.out.println("failed 86");
        }
        System.out.println("test array replaced...");
        mMArray3.set(new float[]{1.0f, 2.0f, 3.0f, 4.0f});
        if (mMArray3.getLength() != 4) {
            System.out.println("failed 91");
        }
        if (mMArray3.get(0) != 1.0f) {
            System.out.println("failed 92");
        }
        if (mMArray3.get(2) != 3.0f) {
            System.out.println("failed 93");
        }
        if (mMArray3.get(3) != 4.0f) {
            System.out.println("failed 94");
        }
        if (mMArray3.get(4) != 69.0f) {
            System.out.println("failed 95");
        }
        System.out.println("test array copy in range...");
        MMArray mMArray4 = new MMArray(100, 44.0f);
        MMArray mMArray5 = new MMArray(100, 44.0f);
        for (n3 = 0; n3 < mMArray4.getLength(); ++n3) {
            mMArray4.set(n3, n3);
        }
        mMArray5.copy(mMArray4, 40, 0, 10);
        for (n3 = 0; n3 < 10; ++n3) {
            if (mMArray5.get(n3) == (float)(40 + n3)) continue;
            System.out.println("failed " + (100 + n3));
        }
        if (mMArray5.get(39) != 44.0f) {
            System.out.println("failed 111");
        }
        if (mMArray5.get(50) != 44.0f) {
            System.out.println("failed 112");
        }
        System.out.println("test array copy extra range...");
        mMArray4 = new MMArray(70, 22.0f);
        mMArray5 = new MMArray(600, 44.0f);
        for (n3 = 0; n3 < mMArray4.getLength(); ++n3) {
            mMArray4.set(n3, n3);
        }
        mMArray5.copy(mMArray4, 40, 0, 300);
        for (n3 = 0; n3 < 20; ++n3) {
            if (mMArray5.get(n3) == (float)(40 + n3)) continue;
            System.out.println("failed " + (200 + n3));
        }
        if (mMArray5.get(299) != 22.0f) {
            System.out.println("failed 221");
        }
        if (mMArray5.get(300) != 44.0f) {
            System.out.println("failed 222");
        }
        System.out.print("profiling calibration...            ");
        mMArray4 = new MMArray(2000000, 0.0f);
        long l = System.currentTimeMillis();
        int n4 = mMArray4.getLength();
        for (n2 = 0; n2 < 100; ++n2) {
            for (n = 0; n < n4; ++n) {
            }
        }
        System.out.println("" + (System.currentTimeMillis() - l) * 10000000L / (long)mMArray4.getLength() + " ps/element");
        System.out.print("profiling get()...                  ");
        mMArray4 = new MMArray(2000000, 0.0f);
        l = System.currentTimeMillis();
        n4 = mMArray4.getLength();
        for (n2 = 0; n2 < 100; ++n2) {
            for (n = 0; n < n4; ++n) {
                mMArray4.get(n);
            }
        }
        System.out.println("" + (System.currentTimeMillis() - l) * 10000000L / (long)mMArray4.getLength() + " ps/element");
        System.out.print("profiling set()...                  ");
        mMArray4 = new MMArray(2000000, 0.0f);
        l = System.currentTimeMillis();
        n4 = mMArray4.getLength();
        for (n2 = 0; n2 < 100; ++n2) {
            for (n = 0; n < n4; ++n) {
                mMArray4.set(n, n);
            }
        }
        System.out.println("" + (System.currentTimeMillis() - l) * 10000000L / (long)mMArray4.getLength() + " ps/element");
        System.out.print("profiling manual get() and set()... ");
        mMArray4 = new MMArray(2000000, 0.0f);
        l = System.currentTimeMillis();
        n4 = mMArray4.getLength();
        for (n2 = 0; n2 < 100; ++n2) {
            for (n = 0; n < n4; ++n) {
                mMArray4.set(n, mMArray4.get(n + 2));
            }
        }
        System.out.println("" + (System.currentTimeMillis() - l) * 10000000L / (long)mMArray4.getLength() + " ps/element");
        System.out.print("profiling copy() in range...        ");
        mMArray4 = new MMArray(2000000, 44.0f);
        MMArray mMArray6 = new MMArray(2000001, 22.0f);
        long l2 = System.currentTimeMillis();
        for (n2 = 0; n2 < 100; ++n2) {
            mMArray6.copy(mMArray4, 0, 0, mMArray4.getLength());
        }
        System.out.println("" + (System.currentTimeMillis() - l2) * 10000000L / (long)mMArray4.getLength() + " ps/element");
        System.out.print("profiling copy() extra range...     ");
        mMArray4 = new MMArray(2000000, 44.0f);
        mMArray6 = new MMArray(2000001, 22.0f);
        l2 = System.currentTimeMillis();
        for (n2 = 0; n2 < 100; ++n2) {
            mMArray6.copy(mMArray4, 0, 0, mMArray6.getLength());
        }
        System.out.println("" + (System.currentTimeMillis() - l2) * 10000000L / (long)mMArray6.getLength() + " ps/element");
        System.out.println("if not failed then passed...!");
    }
}

