/*
 * Decompiled with CFR 0.152.
 */
package ch.laoe.clip;

import ch.laoe.clip.AChannelSelection;
import ch.laoe.clip.ALayer;
import ch.laoe.clip.ASelection;
import ch.laoe.operation.AOperation;
import ch.laoe.ui.GProgressViewer;
import java.util.Vector;

public class ALayerSelection
extends ASelection {
    private static int nameCounter;
    private Vector channelSelection = new Vector();

    public ALayerSelection(ALayer aLayer) {
        super(aLayer);
    }

    public ALayerSelection(ALayerSelection aLayerSelection) {
        this((ALayer)aLayerSelection.model);
        this.name = aLayerSelection.name;
        for (int i = 0; i < aLayerSelection.getNumberOfChannelSelections(); ++i) {
            this.addChannelSelection(new AChannelSelection(aLayerSelection.getChannelSelection(i)));
        }
    }

    public ALayer getLayer() {
        return (ALayer)this.model;
    }

    public void setLayer(ALayer aLayer) {
        this.model = aLayer;
    }

    @Override
    public void setDefaultName() {
        this.setDefaultName("layerSelection", nameCounter++);
    }

    public void addChannelSelection(AChannelSelection aChannelSelection) {
        this.channelSelection.add(aChannelSelection);
    }

    public AChannelSelection getChannelSelection(int n) {
        return (AChannelSelection)this.channelSelection.get(n);
    }

    public int getNumberOfChannelSelections() {
        return this.channelSelection.size();
    }

    @Override
    public boolean isSelected() {
        for (int i = 0; i < this.getNumberOfChannelSelections(); ++i) {
            if (!this.getChannelSelection(i).isSelected()) continue;
            return true;
        }
        return false;
    }

    public int getMaxLength() {
        int n = 0;
        for (int i = 0; i < this.getNumberOfChannelSelections(); ++i) {
            int n2 = this.getChannelSelection(i).getLength();
            if (n2 <= n) continue;
            n = n2;
        }
        return n;
    }

    public int getLowestSelectedIndex() {
        int n = Integer.MAX_VALUE;
        for (int i = 0; i < this.getNumberOfChannelSelections(); ++i) {
            int n2 = this.getChannelSelection(i).getOffset();
            if (n2 >= n) continue;
            n = n2;
        }
        return n;
    }

    public int getHighestSelectedIndex() {
        int n = 0;
        for (int i = 0; i < this.getNumberOfChannelSelections(); ++i) {
            AChannelSelection aChannelSelection = this.getChannelSelection(i);
            int n2 = aChannelSelection.getOffset() + aChannelSelection.getLength();
            if (n2 <= n) continue;
            n = n2;
        }
        return n;
    }

    public void clearIntensity() {
        for (int i = 0; i < this.getNumberOfChannelSelections(); ++i) {
            this.getChannelSelection(i).clearIntensity();
        }
    }

    public void operateEachChannel(AOperation aOperation) {
        GProgressViewer.entrySubProgress("layer");
        aOperation.startOperation();
        for (int i = 0; i < this.getNumberOfChannelSelections(); ++i) {
            if (!this.getChannelSelection(i).isSelected()) continue;
            GProgressViewer.setProgress((i + 1) * 100 / this.getNumberOfChannelSelections());
            GProgressViewer.entrySubProgress("channel", " " + i);
            aOperation.operate(this.getChannelSelection(i));
            GProgressViewer.exitSubProgress();
        }
        aOperation.endOperation();
        System.gc();
        GProgressViewer.exitSubProgress();
    }

    public void operateChannel0WithChannel1(AOperation aOperation) {
        aOperation.startOperation();
        if (this.getChannelSelection(0).isSelected()) {
            aOperation.operate(this.getChannelSelection(0), this.getChannelSelection(1));
        }
        aOperation.endOperation();
        System.gc();
    }

    public void operateChannel0WithChannel1WithChannel2(AOperation aOperation) {
        aOperation.startOperation();
        if (this.getChannelSelection(0).isSelected()) {
            aOperation.operate(this.getChannelSelection(0), this.getChannelSelection(1), this.getChannelSelection(2));
        }
        aOperation.endOperation();
        System.gc();
    }
}

