/*
 * Decompiled with CFR 0.152.
 */
package ch.laoe.clip;

import ch.laoe.clip.ALayer;
import ch.laoe.clip.AModel;
import ch.laoe.clip.APlotter;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;

public class ALayerPlotter
extends APlotter {
    private boolean isVisible;
    private Color color;
    private float colorGamma = 0.5f;

    public ALayerPlotter(AModel aModel) {
        super(aModel);
        this.setVisible(true);
        this.initColor();
    }

    @Override
    public void setDefaultName() {
        this.name = "";
    }

    public ALayer getLayerModel() {
        return (ALayer)this.model;
    }

    public void setVisible(boolean bl) {
        this.isVisible = bl;
    }

    public boolean isVisible() {
        return this.isVisible;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public Color getColor() {
        return this.color;
    }

    private void initColor() {
        this.setColor(new Color(0x111144));
    }

    public void setColorGamma(float f) {
        this.colorGamma = f;
    }

    public float getColorGamma() {
        return this.colorGamma;
    }

    public void setXRange(float f, float f2) {
        for (int i = 0; i < this.getLayerModel().getNumberOfElements(); ++i) {
            this.getLayerModel().getChannel(i).getChannelPlotter().setXRange(f, f2);
        }
    }

    public void setYRange(float f, float f2) {
        for (int i = 0; i < this.getLayerModel().getNumberOfElements(); ++i) {
            this.getLayerModel().getChannel(i).getChannelPlotter().setYRange(f, f2);
        }
    }

    public void translateXOffset(float f) {
        for (int i = 0; i < this.getLayerModel().getNumberOfElements(); ++i) {
            this.getLayerModel().getChannel(i).getChannelPlotter().translateXOffset(f);
        }
    }

    public void translateYOffset(float f) {
        for (int i = 0; i < this.getLayerModel().getNumberOfElements(); ++i) {
            this.getLayerModel().getChannel(i).getChannelPlotter().translateYOffset(f);
        }
    }

    public void zoomX(float f) {
        for (int i = 0; i < this.getLayerModel().getNumberOfElements(); ++i) {
            this.getLayerModel().getChannel(i).getChannelPlotter().zoomX(f);
        }
    }

    public void zoomX(float f, float f2) {
        for (int i = 0; i < this.getLayerModel().getNumberOfElements(); ++i) {
            this.getLayerModel().getChannel(i).getChannelPlotter().zoomX(f, f2);
        }
    }

    public void zoomY(float f) {
        for (int i = 0; i < this.getLayerModel().getNumberOfElements(); ++i) {
            this.getLayerModel().getChannel(i).getChannelPlotter().zoomY(f);
        }
    }

    public void autoScaleX() {
        float f = this.getAutoscaleXOffset();
        float f2 = this.getAutoscaleXLength();
        this.setXRange(f - f2 * 0.03f, f2 * 1.06f);
    }

    public void autoScaleY() {
        this.autoScaleY(0, this.getLayerModel().getMaxSampleLength());
    }

    public void autoScaleY(int n, int n2) {
        float f = this.getAutoscaleYOffset(n, n2);
        float f2 = this.getAutoscaleYLength(n, n2);
        this.setYRange(f - f2 * 0.03f, f2 * 1.06f);
    }

    public float getAutoscaleXOffset() {
        float f = Float.MAX_VALUE;
        ALayer aLayer = this.getLayerModel();
        for (int i = 0; i < aLayer.getNumberOfChannels(); ++i) {
            float f2 = aLayer.getChannel(i).getChannelPlotter().getAutoscaleXOffset();
            if (!(f2 < f)) continue;
            f = f2;
        }
        return f;
    }

    public float getAutoscaleXLength() {
        float f = Float.MIN_VALUE;
        ALayer aLayer = this.getLayerModel();
        for (int i = 0; i < aLayer.getNumberOfChannels(); ++i) {
            float f2 = aLayer.getChannel(i).getChannelPlotter().getAutoscaleXLength();
            if (!(f2 > f)) continue;
            f = f2;
        }
        return f;
    }

    public float getAutoscaleYOffset(int n, int n2) {
        float f = Float.MAX_VALUE;
        ALayer aLayer = this.getLayerModel();
        for (int i = 0; i < aLayer.getNumberOfChannels(); ++i) {
            float f2 = aLayer.getChannel(i).getChannelPlotter().getAutoscaleYOffset(n, n2);
            if (!(f2 < f)) continue;
            f = f2;
        }
        return f;
    }

    public float getAutoscaleYLength(int n, int n2) {
        float f = Float.MIN_VALUE;
        ALayer aLayer = this.getLayerModel();
        for (int i = 0; i < aLayer.getNumberOfChannels(); ++i) {
            float f2 = aLayer.getChannel(i).getChannelPlotter().getAutoscaleYLength(n, n2);
            if (!(f2 > f)) continue;
            f = f2;
        }
        return f;
    }

    private int getSkalaSize(Rectangle rectangle, int n) {
        int n2 = 3;
        int n3 = 8;
        return Math.max(Math.min(rectangle.height / n / 20, n3), n2);
    }

    private Rectangle createChannelRect(Rectangle rectangle, int n, int n2) {
        int n3 = rectangle.width;
        int n4 = rectangle.height;
        int n5 = this.getSkalaSize(rectangle, n2);
        int n6 = n4 / n2 - n5;
        int n7 = n3 - n5;
        return new Rectangle(n5, n * (n6 + n5), n7, n6);
    }

    private Rectangle createYSkalaRect(Rectangle rectangle, int n, int n2) {
        int n3 = rectangle.width;
        int n4 = rectangle.height;
        int n5 = this.getSkalaSize(rectangle, n2);
        int n6 = n4 / n2 - n5;
        int n7 = n3 - n5;
        return new Rectangle(0, n * (n6 + n5), n5, n6);
    }

    private Rectangle createXSkalaRect(Rectangle rectangle, int n, int n2) {
        int n3 = rectangle.width;
        int n4 = rectangle.height;
        int n5 = this.getSkalaSize(rectangle, n2);
        int n6 = n4 / n2 - n5;
        int n7 = n3 - n5;
        return new Rectangle(n5, n * (n6 + n5) + n6, n7 - n5, n5);
    }

    public void paintLayer(Graphics2D graphics2D, Rectangle rectangle, int n, int n2, boolean bl, boolean bl2, float f) {
        if (this.isVisible || !bl2) {
            ALayer aLayer = this.getLayerModel();
            for (int i = 0; i < n2; ++i) {
                Rectangle rectangle2 = this.createChannelRect(rectangle, i, n2);
                if (i < aLayer.getNumberOfChannels()) {
                    graphics2D.setComposite(AlphaComposite.getInstance(3, f));
                    aLayer.getChannel(i).getChannelPlotter().setRectangle(rectangle2);
                    aLayer.getChannel(i).getChannelPlotter().paintSamples(graphics2D, this.color, this.colorGamma);
                    graphics2D.setComposite(AlphaComposite.getInstance(3, 1.0f));
                    aLayer.getChannel(i).getChannelPlotter().paintFrame(graphics2D);
                }
                if (!bl || i >= aLayer.getNumberOfChannels()) continue;
                Rectangle rectangle3 = this.createXSkalaRect(rectangle, i, n2);
                Rectangle rectangle4 = this.createYSkalaRect(rectangle, i, n2);
                aLayer.getChannel(i).getChannelPlotter().paintXSkala(graphics2D, rectangle3);
                aLayer.getChannel(i).getChannelPlotter().paintYSkala(graphics2D, rectangle4);
            }
        }
    }

    public void paintAllSelections(Graphics2D graphics2D, Rectangle rectangle, Color color, int n, int n2) {
        if (this.isVisible) {
            ALayer aLayer = this.getLayerModel();
            for (int i = 0; i < n2; ++i) {
                Rectangle rectangle2 = this.createChannelRect(rectangle, i, n2);
                if (i >= aLayer.getNumberOfChannels()) continue;
                aLayer.getChannel(i).getChannelPlotter().setRectangle(rectangle2);
                aLayer.getChannel(i).getChannelPlotter().paintSelection(graphics2D, color);
            }
        }
    }

    public void paintMasks(Graphics2D graphics2D, Rectangle rectangle, Color color, int n, int n2) {
        if (this.isVisible) {
            ALayer aLayer = this.getLayerModel();
            for (int i = 0; i < n2; ++i) {
                Rectangle rectangle2 = this.createChannelRect(rectangle, i, n2);
                if (i >= aLayer.getNumberOfChannels()) continue;
                aLayer.getChannel(i).getChannelPlotter().setRectangle(rectangle2);
                aLayer.getChannel(i).getChannelPlotter().paintMask(graphics2D, color);
            }
        }
    }

    public void paintMarkers(Graphics2D graphics2D, Rectangle rectangle, int n, int n2) {
        if (this.isVisible) {
            ALayer aLayer = this.getLayerModel();
            for (int i = 0; i < n2; ++i) {
                Rectangle rectangle2 = this.createChannelRect(rectangle, i, n2);
                if (i >= aLayer.getNumberOfChannels()) continue;
                Rectangle rectangle3 = this.createXSkalaRect(rectangle, i, n2);
                aLayer.getChannel(i).getChannelPlotter().paintMarker(graphics2D, rectangle3);
            }
        }
    }

    public int getInsideChannelIndex(Point point) {
        try {
            ALayer aLayer = this.getLayerModel();
            for (int i = 0; i < aLayer.getNumberOfChannels(); ++i) {
                if (!aLayer.getChannel(i).getChannelPlotter().isInsideChannel(point)) continue;
                return i;
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return -1;
    }
}

