/*
 * Decompiled with CFR 0.152.
 */
package ch.laoe.clip;

import ch.laoe.clip.AChannel;
import ch.laoe.clip.AChannelSelection;
import ch.laoe.clip.AClip;
import ch.laoe.clip.AContainerModel;
import ch.laoe.clip.ALayerPlotter;
import ch.laoe.clip.ALayerSelection;
import ch.laoe.clip.AModel;
import ch.laoe.operation.AOMix;
import ch.laoe.ui.GLanguage;
import java.awt.Point;

public class ALayer
extends AContainerModel {
    private int plotType = 1;
    public static final int SAMPLE_CURVE_TYPE = 1;
    public static final int SPECTROGRAM_TYPE = 2;
    private static int nameCounter;
    private int type = 1;
    public static final int AUDIO_LAYER = 1;
    public static final int PARAMETER_LAYER = 2;

    public ALayer() {
        this.selection = new ALayerSelection(this);
        this.plotter = new ALayerPlotter(this);
    }

    public ALayer(int n) {
        this();
        for (int i = 0; i < n; ++i) {
            this.add(new AChannel());
        }
        this.setStandardChannelNames();
    }

    public ALayer(int n, int n2) {
        this();
        for (int i = 0; i < n; ++i) {
            this.add(new AChannel(n2));
        }
        this.setStandardChannelNames();
    }

    public ALayer(ALayer aLayer) {
        this();
        this.type = aLayer.type;
        this.getLayerPlotter().setColor(aLayer.getLayerPlotter().getColor());
        this.name = GLanguage.translate("copyOf") + " " + aLayer.name;
        for (int i = 0; i < aLayer.getNumberOfChannels(); ++i) {
            this.add(new AChannel(aLayer.getChannel(i)));
        }
    }

    private void setStandardChannelNames() {
        int n = this.getNumberOfChannels();
        if (n == 1) {
            this.getChannel(0).setName(GLanguage.translate("mono"));
        } else if (n == 2) {
            this.getChannel(0).setName(GLanguage.translate("left"));
            this.getChannel(1).setName(GLanguage.translate("right"));
        }
    }

    public AClip getParentClip() {
        return (AClip)this.getParent();
    }

    @Override
    public void add(AModel aModel) {
        super.add(aModel);
        this.setType(this.type);
        ((AChannel)aModel).setPlotType(this.plotType);
    }

    @Override
    public void insert(AModel aModel, int n) {
        super.insert(aModel, n);
        this.setType(this.type);
        ((AChannel)aModel).setPlotType(this.plotType);
    }

    public ALayerPlotter getLayerPlotter() {
        return (ALayerPlotter)this.getPlotter();
    }

    public void setPlotType(int n) {
        this.plotType = n;
        for (int i = 0; i < this.getNumberOfChannels(); ++i) {
            this.getChannel(i).setPlotType(n);
        }
    }

    public int getPlotType() {
        return this.plotType;
    }

    @Override
    public void setDefaultName() {
        this.setDefaultName("layer", nameCounter++);
    }

    public void setType(int n) {
        this.type = n;
    }

    public int getType() {
        return this.type;
    }

    public AChannel getChannel(int n) {
        return (AChannel)this.get(n);
    }

    public void mergeDownChannel(int n) {
        if (this.getNumberOfElements() > 1 && n > 0) {
            AChannelSelection aChannelSelection = this.getChannel(n - 1).createChannelSelection();
            AChannelSelection aChannelSelection2 = this.getChannel(n).createChannelSelection();
            ALayerSelection aLayerSelection = new ALayerSelection(this);
            aLayerSelection.addChannelSelection(aChannelSelection);
            aLayerSelection.addChannelSelection(aChannelSelection2);
            aLayerSelection.operateChannel0WithChannel1(new AOMix());
            this.remove(n);
        }
    }

    public void mergeAllChannels() {
        while (this.getNumberOfElements() > 1) {
            this.mergeDownChannel(1);
        }
    }

    public AChannel getSelectedChannel() {
        return (AChannel)this.getSelected();
    }

    public int getNumberOfChannels() {
        return this.getNumberOfElements();
    }

    public AChannel getChannel(Point point) {
        try {
            return this.getChannel(this.getLayerPlotter().getInsideChannelIndex(point));
        }
        catch (Exception exception) {
            return null;
        }
    }

    public int getMaxSampleLength() {
        int n = 0;
        for (int i = 0; i < this.getNumberOfElements(); ++i) {
            int n2 = this.getChannel(i).getSampleLength();
            if (n2 <= n) continue;
            n = n2;
        }
        return n;
    }

    public float getMaxSampleValue() {
        float f = 0.0f;
        for (int i = 0; i < this.getNumberOfElements(); ++i) {
            float f2 = this.getChannel(i).getMaxSampleValue();
            if (!(f2 > f)) continue;
            f = f2;
        }
        return f;
    }

    public float getMaxSampleValue(int n, int n2) {
        float f = 0.0f;
        for (int i = 0; i < this.getNumberOfElements(); ++i) {
            float f2 = this.getChannel(i).getMaxSampleValue(n, n2);
            if (!(f2 > f)) continue;
            f = f2;
        }
        return f;
    }

    public boolean isMaskEnabled() {
        for (int i = 0; i < this.getNumberOfChannels(); ++i) {
            if (!this.getChannel(i).isMaskEnabled()) continue;
            return true;
        }
        return false;
    }

    public void setLayerSelection(ALayerSelection aLayerSelection) {
        int n = Math.min(this.getNumberOfChannels(), aLayerSelection.getNumberOfChannelSelections());
        aLayerSelection.setLayer(this);
        for (int i = 0; i < n; ++i) {
            this.getChannel(i).setChannelSelection(aLayerSelection.getChannelSelection(i));
            aLayerSelection.getChannelSelection(i).setChannel(this.getChannel(i));
        }
        this.selection = aLayerSelection;
    }

    public ALayerSelection getLayerSelection() {
        ALayerSelection aLayerSelection = new ALayerSelection(this);
        for (int i = 0; i < this.getNumberOfChannels(); ++i) {
            AChannelSelection aChannelSelection = this.getChannel(i).getChannelSelection();
            if (!aChannelSelection.isSelected()) continue;
            aLayerSelection.addChannelSelection(aChannelSelection);
        }
        if (!aLayerSelection.isSelected()) {
            return this.createLayerSelection();
        }
        return aLayerSelection;
    }

    public ALayerSelection createLayerSelection() {
        ALayerSelection aLayerSelection = new ALayerSelection(this);
        for (int i = 0; i < this.getNumberOfChannels(); ++i) {
            aLayerSelection.addChannelSelection(this.getChannel(i).createChannelSelection());
        }
        return aLayerSelection;
    }

    public void modifyLayerSelection(int n, int n2) {
        for (int i = 0; i < this.getNumberOfChannels(); ++i) {
            this.getChannel(i).modifyChannelSelection(n, n2);
        }
    }

    public void setFullLayerSelection() {
        ALayerSelection aLayerSelection = new ALayerSelection(this);
        for (int i = 0; i < this.getNumberOfChannels(); ++i) {
            this.getChannel(i).setFullChannelSelection();
            aLayerSelection.addChannelSelection(this.getChannel(i).getChannelSelection());
        }
        this.selection = aLayerSelection;
    }

    public void setEmptyLayerSelection() {
        ALayerSelection aLayerSelection = new ALayerSelection(this);
        for (int i = 0; i < this.getNumberOfChannels(); ++i) {
            this.getChannel(i).setEmptyChannelSelection();
            aLayerSelection.addChannelSelection(this.getChannel(i).getChannelSelection());
        }
        this.selection = aLayerSelection;
    }
}

