/*
 * Decompiled with CFR 0.152.
 */
package ch.laoe.clip;

import ch.laoe.clip.AModel;
import java.util.Vector;

public abstract class AContainerModel
extends AModel {
    private Vector elements = new Vector();
    protected int selectedIndex = 0;

    public void add(AModel aModel) {
        aModel.setParent(this);
        this.elements.add(aModel);
    }

    public void link(AModel aModel) {
        this.elements.add(aModel);
    }

    public void insert(AModel aModel, int n) {
        aModel.setParent(this);
        this.elements.insertElementAt(aModel, n);
    }

    public AModel get(int n) {
        return (AModel)this.elements.get(n);
    }

    public boolean contains(AModel aModel) {
        for (int i = 0; i < this.getNumberOfElements(); ++i) {
            if (this.get(i) != aModel) continue;
            return true;
        }
        return false;
    }

    public void remove(int n) {
        if (this.elements.size() > 1) {
            AModel aModel = (AModel)this.elements.get(n);
            aModel.destroy();
            this.elements.remove(aModel);
            System.gc();
        }
    }

    public void removeAll() {
        for (int i = 0; i < this.elements.size(); ++i) {
            AModel aModel = (AModel)this.elements.get(0);
            aModel.destroy();
            this.elements.remove(aModel);
        }
        System.gc();
    }

    @Override
    public void destroy() {
        this.removeAll();
    }

    public int getNumberOfElements() {
        return this.elements.size();
    }

    public void moveUp(int n) {
        if (n < this.getNumberOfElements() - 1 && n >= 0) {
            Object e = this.elements.get(n + 1);
            this.elements.set(n + 1, this.elements.get(n));
            this.elements.set(n, e);
        }
    }

    public void moveDown(int n) {
        this.moveUp(n - 1);
    }

    public AModel getTop() {
        return (AModel)this.elements.get(this.getNumberOfElements() - 1);
    }

    public AModel getBottom() {
        return (AModel)this.elements.get(0);
    }

    public AModel getSelected() {
        return this.get(this.getSelectedIndex());
    }

    public int getSelectedIndex() {
        if (this.selectedIndex >= this.elements.size()) {
            this.selectedIndex = this.elements.size() - 1;
        }
        if (this.selectedIndex < 0) {
            this.selectedIndex = 0;
        }
        return this.selectedIndex;
    }

    public void setSelectedIndex(int n) {
        this.selectedIndex = n;
    }

    public int getMaxNumberOfSubElements() {
        int n = 0;
        for (int i = 0; i < this.elements.size(); ++i) {
            int n2 = ((AContainerModel)this.elements.get(i)).getNumberOfElements();
            if (n2 <= n) continue;
            n = n2;
        }
        return n;
    }
}

