/*
 * Decompiled with CFR 0.152.
 */
package ch.laoe.clip;

import ch.laoe.clip.AClip;
import ch.laoe.clip.ALayerSelection;
import ch.laoe.clip.ASelection;
import ch.laoe.operation.AOperation;
import ch.laoe.ui.GProgressViewer;
import java.util.Vector;

public class AClipSelection
extends ASelection {
    private static int nameCounter;
    private Vector layerSelection = new Vector();

    public AClipSelection(AClip aClip) {
        super(aClip);
    }

    public AClipSelection(AClipSelection aClipSelection) {
        this((AClip)aClipSelection.model);
        this.name = aClipSelection.name;
    }

    public AClip getClip() {
        return (AClip)this.model;
    }

    @Override
    public void setDefaultName() {
        this.setDefaultName("clipSelection", nameCounter++);
    }

    public void addLayerSelection(ALayerSelection aLayerSelection) {
        this.layerSelection.add(aLayerSelection);
    }

    public ALayerSelection getLayerSelection(int n) {
        return (ALayerSelection)this.layerSelection.get(n);
    }

    public int getNumberOfLayerSelections() {
        return this.layerSelection.size();
    }

    @Override
    public boolean isSelected() {
        for (int i = 0; i < this.getNumberOfLayerSelections(); ++i) {
            if (!this.getLayerSelection(i).isSelected()) continue;
            return true;
        }
        return false;
    }

    public void operateEachChannel(AOperation aOperation) {
        GProgressViewer.entrySubProgress("clip");
        aOperation.startOperation();
        for (int i = 0; i < this.getNumberOfLayerSelections(); ++i) {
            GProgressViewer.setProgress((i + 1) * 100 / this.getNumberOfLayerSelections());
            GProgressViewer.entrySubProgress("layer", " " + i);
            for (int j = 0; j < this.getLayerSelection(i).getNumberOfChannelSelections(); ++j) {
                GProgressViewer.setProgress((j + 1) * 100 / this.getLayerSelection(i).getNumberOfChannelSelections());
                GProgressViewer.entrySubProgress("channel", " " + j);
                if (this.getLayerSelection(i).getChannelSelection(j).isSelected()) {
                    aOperation.operate(this.getLayerSelection(i).getChannelSelection(j));
                }
                GProgressViewer.exitSubProgress();
            }
            GProgressViewer.exitSubProgress();
        }
        aOperation.endOperation();
        System.gc();
        GProgressViewer.exitSubProgress();
    }

    public void operateLayer0WithLayer1(AOperation aOperation) {
        int n = this.getLayerSelection(0).getNumberOfChannelSelections();
        int n2 = this.getLayerSelection(1).getNumberOfChannelSelections();
        int n3 = Math.min(n, n2);
        GProgressViewer.entrySubProgress("clip");
        aOperation.startOperation();
        for (int i = 0; i < n3; ++i) {
            GProgressViewer.setProgress((i + 1) * 100 / n3);
            if (!this.getLayerSelection(0).getChannelSelection(i).isSelected()) continue;
            aOperation.operate(this.getLayerSelection(0).getChannelSelection(i), this.getLayerSelection(1).getChannelSelection(i));
        }
        aOperation.endOperation();
        System.gc();
        GProgressViewer.exitSubProgress();
    }

    public void operateLayer0WithLayer1And2(AOperation aOperation) {
        int n = this.getLayerSelection(0).getNumberOfChannelSelections();
        int n2 = this.getLayerSelection(1).getNumberOfChannelSelections();
        int n3 = this.getLayerSelection(1).getNumberOfChannelSelections();
        int n4 = Math.min(Math.min(n, n2), n3);
        GProgressViewer.entrySubProgress("clip");
        aOperation.startOperation();
        for (int i = 0; i < n4; ++i) {
            GProgressViewer.setProgress((i + 1) * 100 / n4);
            if (!this.getLayerSelection(0).getChannelSelection(i).isSelected()) continue;
            aOperation.operate(this.getLayerSelection(0).getChannelSelection(i), this.getLayerSelection(1).getChannelSelection(i), this.getLayerSelection(2).getChannelSelection(i));
        }
        aOperation.endOperation();
        System.gc();
        GProgressViewer.exitSubProgress();
    }
}

