/*
 * Decompiled with CFR 0.152.
 */
package ch.laoe.clip;

import ch.laoe.clip.AChannel;
import ch.laoe.clip.AClip;
import ch.laoe.clip.ALayer;
import ch.laoe.clip.ALayerPlotter;
import ch.laoe.clip.AModel;
import ch.laoe.clip.APlotter;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;

public class AClipPlotter
extends APlotter {
    private static boolean autoScaleIndividualYEnable = false;
    private static final int X_UNIT_1 = 0;
    private static final int X_UNIT_S = 1;
    private static final int X_UNIT_MS = 2;
    private static final int X_UNIT_PERCENT = 3;
    private static final int X_UNIT_HZ = 4;
    private static final int X_UNIT_FDHZ = 5;
    private static final int Y_UNIT_1 = 0;
    private static final int Y_UNIT_PERCENT = 1;
    private static final int Y_UNIT_DB = 2;
    private int plotterXUnit = 1;
    private int plotterYUnit = 1;
    private static boolean skalaValuesVisible = true;
    protected int maxNumberOfChannels;
    protected int maxSampleLength;

    public AClipPlotter(AModel aModel) {
        super(aModel);
    }

    @Override
    public void setDefaultName() {
        this.name = "";
    }

    public AClip getClipModel() {
        return (AClip)this.model;
    }

    public void setXRange(float f, float f2) {
        for (int i = 0; i < this.getClipModel().getNumberOfElements(); ++i) {
            this.getClipModel().getLayer(i).getLayerPlotter().setXRange(f, f2);
        }
    }

    public void setYRange(float f, float f2) {
        for (int i = 0; i < this.getClipModel().getNumberOfElements(); ++i) {
            this.getClipModel().getLayer(i).getLayerPlotter().setYRange(f, f2);
        }
    }

    public void translateXOffset(float f) {
        for (int i = 0; i < this.getClipModel().getNumberOfElements(); ++i) {
            this.getClipModel().getLayer(i).getLayerPlotter().translateXOffset(f);
        }
    }

    public void translateYOffset(float f) {
        for (int i = 0; i < this.getClipModel().getNumberOfElements(); ++i) {
            this.getClipModel().getLayer(i).getLayerPlotter().translateYOffset(f);
        }
    }

    public void zoomX(float f) {
        for (int i = 0; i < this.getClipModel().getNumberOfElements(); ++i) {
            this.getClipModel().getLayer(i).getLayerPlotter().zoomX(f);
        }
    }

    public void zoomX(float f, float f2) {
        for (int i = 0; i < this.getClipModel().getNumberOfElements(); ++i) {
            this.getClipModel().getLayer(i).getLayerPlotter().zoomX(f, f2);
        }
    }

    public void zoomY(float f) {
        for (int i = 0; i < this.getClipModel().getNumberOfElements(); ++i) {
            this.getClipModel().getLayer(i).getLayerPlotter().zoomY(f);
        }
    }

    public static void setAutoScaleIndividualYEnabled(boolean bl) {
        autoScaleIndividualYEnable = bl;
    }

    public void autoScale() {
        this.autoScaleX();
        this.autoScaleY();
    }

    public void autoScaleX() {
        float f = this.getAutoscaleXOffset();
        float f2 = this.getAutoscaleXLength();
        AClip aClip = this.getClipModel();
        for (int i = 0; i < aClip.getNumberOfLayers(); ++i) {
            ALayerPlotter aLayerPlotter = aClip.getLayer(i).getLayerPlotter();
            if (!aLayerPlotter.isVisible()) continue;
            aLayerPlotter.setXRange(f - f2 * 0.03f, f2 * 1.06f);
        }
    }

    public void autoScaleY() {
        this.autoScaleY(0, this.getClipModel().getMaxSampleLength());
    }

    public void autoScaleY(int n, int n2) {
        float f = this.getAutoscaleYOffset(n, n2);
        float f2 = this.getAutoscaleYLength(n, n2);
        AClip aClip = this.getClipModel();
        for (int i = 0; i < aClip.getNumberOfLayers(); ++i) {
            ALayerPlotter aLayerPlotter = aClip.getLayer(i).getLayerPlotter();
            if (!aLayerPlotter.isVisible()) continue;
            if (autoScaleIndividualYEnable) {
                aLayerPlotter.autoScaleY(n, n2);
                continue;
            }
            aLayerPlotter.setYRange(f - f2 * 0.03f, f2 * 1.06f);
        }
    }

    public float getAutoscaleXOffset() {
        float f = Float.MAX_VALUE;
        AClip aClip = this.getClipModel();
        for (int i = 0; i < aClip.getNumberOfLayers(); ++i) {
            float f2;
            ALayerPlotter aLayerPlotter = aClip.getLayer(i).getLayerPlotter();
            if (!aLayerPlotter.isVisible() || !((f2 = aLayerPlotter.getAutoscaleXOffset()) < f)) continue;
            f = f2;
        }
        return f;
    }

    public float getAutoscaleXLength() {
        float f = Float.MIN_VALUE;
        AClip aClip = this.getClipModel();
        for (int i = 0; i < aClip.getNumberOfLayers(); ++i) {
            float f2;
            ALayerPlotter aLayerPlotter = aClip.getLayer(i).getLayerPlotter();
            if (!aLayerPlotter.isVisible() || !((f2 = aLayerPlotter.getAutoscaleXLength()) > f)) continue;
            f = f2;
        }
        return f;
    }

    public float getAutoscaleYOffset(int n, int n2) {
        float f = Float.MAX_VALUE;
        AClip aClip = this.getClipModel();
        for (int i = 0; i < aClip.getNumberOfLayers(); ++i) {
            float f2;
            ALayerPlotter aLayerPlotter = aClip.getLayer(i).getLayerPlotter();
            if (!aLayerPlotter.isVisible() || !((f2 = aLayerPlotter.getAutoscaleYOffset(n, n2)) < f)) continue;
            f = f2;
        }
        return f;
    }

    public float getAutoscaleYLength(int n, int n2) {
        float f = Float.MIN_VALUE;
        AClip aClip = this.getClipModel();
        for (int i = 0; i < aClip.getNumberOfLayers(); ++i) {
            float f2;
            ALayerPlotter aLayerPlotter = aClip.getLayer(i).getLayerPlotter();
            if (!aLayerPlotter.isVisible() || !((f2 = aLayerPlotter.getAutoscaleYLength(n, n2)) > f)) continue;
            f = f2;
        }
        return f;
    }

    public void setPlotterXUnit(int n) {
        this.plotterXUnit = n;
    }

    public void togglePlotterXUnit() {
        this.plotterXUnit = this.plotterXUnit < 5 ? ++this.plotterXUnit : 0;
    }

    public void setPlotterYUnit(int n) {
        this.plotterYUnit = n;
    }

    public void togglePlotterYUnit() {
        this.plotterYUnit = this.plotterYUnit < 2 ? ++this.plotterYUnit : 0;
    }

    public String getPlotterXUnitName() {
        switch (this.plotterXUnit) {
            case 0: {
                return "";
            }
            case 1: {
                return "s";
            }
            case 2: {
                return "ms";
            }
            case 3: {
                return "%";
            }
            case 4: {
                return "1/s";
            }
            case 5: {
                return "Hz";
            }
        }
        return "";
    }

    public String getPlotterYUnitName() {
        switch (this.plotterYUnit) {
            case 0: {
                return "";
            }
            case 1: {
                return "%";
            }
            case 2: {
                return "dB";
            }
        }
        return "";
    }

    public static void setSkalaValuesVisible(boolean bl) {
        skalaValuesVisible = bl;
    }

    public static boolean isSkalaValuesVisible() {
        return skalaValuesVisible;
    }

    public float toPlotterXUnit(float f) {
        switch (this.plotterXUnit) {
            case 0: {
                return f;
            }
            case 1: {
                return f / this.getClipModel().getSampleRate();
            }
            case 2: {
                return f / this.getClipModel().getSampleRate() * 1000.0f;
            }
            case 3: {
                return f / (float)this.getClipModel().getMaxSampleLength() * 100.0f;
            }
            case 4: {
                return this.getClipModel().getSampleRate() / f;
            }
            case 5: {
                return f / (float)(2 * this.getClipModel().getMaxSampleLength()) * this.getClipModel().getSampleRate();
            }
        }
        return f;
    }

    public float toPlotterYUnit(float f) {
        try {
            switch (this.plotterYUnit) {
                case 0: {
                    return f;
                }
                case 1: {
                    return f / (float)(1 << this.getClipModel().getSampleWidth() - 1) * 100.0f;
                }
                case 2: {
                    if (f >= 0.0f) {
                        return (float)(8.68589 * Math.log((double)Math.abs(f * 2.0f) / Math.pow(2.0, this.getClipModel().getSampleWidth())));
                    }
                    return (float)(8.68589 * Math.log((double)Math.abs(f * 2.0f) / Math.pow(2.0, this.getClipModel().getSampleWidth())));
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return f;
    }

    float fromPlotterXUnit(float f) {
        switch (this.plotterXUnit) {
            case 0: {
                return f;
            }
            case 1: {
                return f * this.getClipModel().getSampleRate();
            }
            case 2: {
                return f * this.getClipModel().getSampleRate() / 1000.0f;
            }
            case 3: {
                return f * (float)this.getClipModel().getMaxSampleLength() / 100.0f;
            }
            case 4: {
                return this.getClipModel().getSampleRate() / f;
            }
            case 5: {
                return f * (float)(2 * this.getClipModel().getMaxSampleLength()) / this.getClipModel().getSampleRate();
            }
        }
        return f;
    }

    float fromPlotterYUnit(float f) {
        try {
            switch (this.plotterYUnit) {
                case 0: {
                    return f;
                }
                case 1: {
                    return f * (float)(1 << this.getClipModel().getSampleWidth() - 1) / 100.0f;
                }
                case 2: {
                    if (f >= 0.0f) {
                        return (float)(Math.exp((double)f / 8.68589) * Math.pow(2.0, this.getClipModel().getSampleWidth()) / 2.0);
                    }
                    return (float)(Math.exp((double)f / 8.68589) * Math.pow(2.0, this.getClipModel().getSampleWidth()) / 2.0);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return f;
    }

    public void paintFullClip(Graphics2D graphics2D, Rectangle rectangle) {
        if (rectangle.width > 0 && rectangle.height > 0) {
            this.maxNumberOfChannels = this.getClipModel().getMaxNumberOfChannels();
            this.maxSampleLength = this.getClipModel().getMaxSampleLength();
            ALayer aLayer = this.getClipModel().getSelectedLayer();
            for (int i = 0; i < this.getClipModel().getNumberOfLayers(); ++i) {
                ALayer aLayer2 = this.getClipModel().getLayer(i);
                if (aLayer2 == aLayer) continue;
                aLayer2.getLayerPlotter().paintLayer(graphics2D, rectangle, this.maxSampleLength, this.maxNumberOfChannels, false, true, 0.2f);
            }
            aLayer.getLayerPlotter().paintLayer(graphics2D, rectangle, this.maxSampleLength, this.maxNumberOfChannels, true, true, 1.0f);
        }
    }

    public void paintDetailsOfSelectedLayer(Graphics2D graphics2D, Rectangle rectangle) {
        if (this.getClipModel().getNumberOfLayers() > 0) {
            this.getClipModel().getSelectedLayer().getLayerPlotter().paintAllSelections(graphics2D, rectangle, Color.yellow, this.maxSampleLength, this.maxNumberOfChannels);
            this.getClipModel().getSelectedLayer().getLayerPlotter().paintMasks(graphics2D, rectangle, Color.yellow, this.maxSampleLength, this.maxNumberOfChannels);
            this.getClipModel().getSelectedLayer().getLayerPlotter().paintMarkers(graphics2D, rectangle, this.maxSampleLength, this.maxNumberOfChannels);
            this.getClipModel().getAudio().getPlotter().paintPlayPointer(graphics2D, rectangle, Color.black);
            this.getClipModel().getAudio().getPlotter().paintLoopPointer(graphics2D, rectangle, Color.red);
        }
    }

    public void paintLayerThumbnail(Graphics2D graphics2D, Rectangle rectangle, int n) {
        ALayer aLayer = this.getClipModel().getLayer(n);
        aLayer.getLayerPlotter().paintLayer(graphics2D, rectangle, aLayer.getMaxSampleLength(), aLayer.getNumberOfChannels(), false, false, 1.0f);
    }

    public void paintChannelThumbnail(Graphics2D graphics2D, Rectangle rectangle, int n, int n2) {
        ALayer aLayer = this.getClipModel().getLayer(n);
        AChannel aChannel = aLayer.getChannel(n2);
        aChannel.getChannelPlotter().setRectangle(rectangle);
        aChannel.getChannelPlotter().paintSamples(graphics2D, aLayer.getLayerPlotter().getColor(), aLayer.getLayerPlotter().getColorGamma());
        graphics2D.setComposite(AlphaComposite.getInstance(3, 1.0f));
        aChannel.getChannelPlotter().paintFrame(graphics2D);
    }
}

