/*
 * Decompiled with CFR 0.152.
 */
package ch.laoe.clip;

import ch.laoe.audio.Audio;
import ch.laoe.audio.AudioException;
import ch.laoe.clip.AChannel;
import ch.laoe.clip.AClipHistory;
import ch.laoe.clip.AClipPlotter;
import ch.laoe.clip.AClipSelection;
import ch.laoe.clip.AContainerModel;
import ch.laoe.clip.ALayer;
import ch.laoe.clip.ALayerSelection;
import ch.laoe.operation.AOAmplify;
import ch.laoe.operation.AOMix;
import ch.laoe.ui.Debug;
import ch.laoe.ui.GLanguage;
import ch.laoe.ui.GPersistence;
import ch.laoe.ui.GProgressViewer;
import java.io.File;

public class AClip
extends AContainerModel {
    private Audio audio;
    private static int uniqueIdIndex = 0;
    private String uniqueId;
    private AClipHistory history;
    private static int nameCounter;
    private String comments;
    private float sampleRate;
    private static final float DEFAULT_SAMPLE_RATE = 8000.0f;
    private int sampleWidth;
    private static final int DEFAULT_SAMPLE_WIDTH = 16;
    private boolean bigEndian;

    public AClip() {
        this.changeId();
        this.sampleRate = 8000.0f;
        this.sampleWidth = 16;
        this.comments = GPersistence.createPersistance().getString("clip.defaultComment");
        this.selection = new AClipSelection(this);
        this.plotter = new AClipPlotter(this);
    }

    public AClip(int n, int n2) {
        this();
        for (int i = 0; i < n; ++i) {
            this.add(new ALayer(n2));
        }
        this.audio = new Audio(this);
        this.history = new AClipHistory(this);
        this.history.store(GLanguage.translate("initialState"));
    }

    public AClip(int n, int n2, int n3) {
        this();
        for (int i = 0; i < n; ++i) {
            this.add(new ALayer(n2, n3));
        }
        this.audio = new Audio(this);
        this.history = new AClipHistory(this);
        this.history.store(GLanguage.translate("initialState"));
    }

    public AClip(AClip aClip) {
        this();
        this.sampleRate = aClip.sampleRate;
        this.sampleWidth = aClip.sampleWidth;
        this.comments = aClip.comments;
        this.name = aClip.name;
        this.selection = aClip.selection;
        for (int i = 0; i < aClip.getNumberOfLayers(); ++i) {
            this.add(new ALayer(aClip.getLayer(i)));
        }
        this.audio = new Audio(this);
        this.history = new AClipHistory(aClip.history, this);
    }

    public AClip(File file) throws AudioException {
        this();
        GProgressViewer.entrySubProgress();
        GProgressViewer.setProgress(10);
        this.audio = new Audio(this);
        GProgressViewer.setProgress(90);
        this.audio.open(file);
        GProgressViewer.setProgress(100);
        this.history = new AClipHistory(this);
        this.history.store(GLanguage.translate("initialState"));
        GProgressViewer.exitSubProgress();
    }

    @Override
    public void destroy() {
        super.destroy();
        this.audio.destroy();
        System.gc();
    }

    public void copyAllAttributes(AClip aClip) {
        this.sampleRate = aClip.sampleRate;
        this.sampleWidth = aClip.sampleWidth;
        this.comments = aClip.comments;
        this.name = aClip.name;
        this.selection = aClip.selection;
    }

    public Audio getAudio() {
        return this.audio;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changeId() {
        AClip aClip = this;
        synchronized (aClip) {
        }
        this.uniqueId = "clip" + ++uniqueIdIndex;
    }

    public String getId() {
        return this.uniqueId;
    }

    public AClipHistory getHistory() {
        return this.history;
    }

    public AClipSelection getClipSelection() {
        return (AClipSelection)this.selection;
    }

    public AClipPlotter getClipPlotter() {
        return (AClipPlotter)this.getPlotter();
    }

    public void setPlotType(int n) {
        for (int i = 0; i < this.getNumberOfLayers(); ++i) {
            this.getLayer(i).setPlotType(n);
        }
    }

    @Override
    public void setDefaultName() {
        this.setDefaultName("clip", nameCounter++);
    }

    public String getComments() {
        return this.comments;
    }

    public void setComments(String string) {
        this.comments = string;
    }

    public ALayer getLayer(int n) {
        return (ALayer)this.get(n);
    }

    public void mergeDownLayer(int n) {
        if (this.getNumberOfElements() > 1 && n > 0) {
            ALayer aLayer = this.getLayer(n - 1);
            ALayer aLayer2 = this.getLayer(n);
            ALayerSelection aLayerSelection = aLayer.createLayerSelection();
            ALayerSelection aLayerSelection2 = aLayer2.createLayerSelection();
            AClipSelection aClipSelection = new AClipSelection(this);
            aClipSelection.addLayerSelection(aLayerSelection);
            aClipSelection.addLayerSelection(aLayerSelection2);
            aClipSelection.operateLayer0WithLayer1(new AOMix());
            this.remove(n);
            for (int i = 0; i < aLayer.getNumberOfChannels(); ++i) {
                aLayer.getChannel(i).getMask().clear();
            }
        }
    }

    public void mergeAllLayers() {
        while (this.getNumberOfElements() > 1) {
            this.mergeDownLayer(1);
        }
    }

    public ALayer getSelectedLayer() {
        return (ALayer)this.getSelected();
    }

    public int getNumberOfLayers() {
        return this.getNumberOfElements();
    }

    public int getMaxNumberOfChannels() {
        return this.getMaxNumberOfSubElements();
    }

    public int getMaxSampleLength() {
        int n = 0;
        for (int i = 0; i < this.getNumberOfElements(); ++i) {
            int n2 = this.getLayer(i).getMaxSampleLength();
            if (n2 <= n) continue;
            n = n2;
        }
        return n;
    }

    public float getMaxSampleValue() {
        float f = 0.0f;
        for (int i = 0; i < this.getNumberOfElements(); ++i) {
            float f2 = this.getLayer(i).getMaxSampleValue();
            if (!(f2 > f)) continue;
            f = f2;
        }
        return f;
    }

    public float getMaxSampleValue(int n, int n2) {
        float f = 0.0f;
        for (int i = 0; i < this.getNumberOfElements(); ++i) {
            float f2 = this.getLayer(i).getMaxSampleValue(n, n2);
            if (!(f2 > f)) continue;
            f = f2;
        }
        return f;
    }

    public ALayer createFlattenedLayer(ALayer aLayer) {
        try {
            int n = 0;
            int n2 = 0;
            for (int i = 0; i < this.getNumberOfLayers(); ++i) {
                if (this.getLayer(i).getType() != 1) continue;
                ++n;
                n2 = i;
            }
            if (n == 1 && !this.getLayer(n2).isMaskEnabled()) {
                ALayer aLayer2 = this.getLayer(n2);
                aLayer = new ALayer();
                for (int i = 0; i < aLayer2.getNumberOfChannels(); ++i) {
                    if (aLayer2.getChannel(i).isAudible()) {
                        aLayer.link(aLayer2.getChannel(i));
                    } else {
                        aLayer.add(new AChannel());
                    }
                    aLayer.createLayerSelection();
                }
                return aLayer;
            }
            if (aLayer == null || aLayer.getMaxSampleLength() != this.getMaxSampleLength() || aLayer.getNumberOfChannels() != this.getMaxNumberOfChannels() || this.contains(aLayer)) {
                aLayer = new ALayer(this.getMaxNumberOfChannels(), this.getMaxSampleLength());
            }
            ALayerSelection aLayerSelection = aLayer.createLayerSelection();
            aLayerSelection.operateEachChannel(new AOAmplify(0.0f));
            for (int i = 0; i < this.getNumberOfLayers(); ++i) {
                ALayer aLayer3 = this.getLayer(i);
                ALayerSelection aLayerSelection2 = aLayer3.createLayerSelection();
                AClipSelection aClipSelection = new AClipSelection(this);
                aClipSelection.addLayerSelection(aLayerSelection);
                aClipSelection.addLayerSelection(aLayerSelection2);
                if (aLayer3.getType() != 1) continue;
                aClipSelection.operateLayer0WithLayer1(new AOMix());
            }
        }
        catch (Exception exception) {
            Debug.printStackTrace(5, exception);
        }
        return aLayer;
    }

    public float getSampleRate() {
        return this.sampleRate;
    }

    public void setSampleRate(float f) {
        this.sampleRate = f > 48000.0f ? 48000.0f : (f < 1000.0f ? 1000.0f : f);
        this.audio.changeSampleRate(f);
    }

    public int getSampleWidth() {
        return this.sampleWidth;
    }

    public void setSampleWidth(int n) {
        this.sampleWidth = n < 1 ? 1 : (n > 32 ? 32 : n);
    }

    public boolean isBigEndian() {
        return false;
    }

    public void setBigEndian(boolean bl) {
        this.bigEndian = bl;
    }
}

