/*
 * Decompiled with CFR 0.152.
 */
package ch.laoe.clip;

import ch.laoe.clip.AChannel;
import ch.laoe.clip.ASelection;
import ch.laoe.clip.ASelectionPlotter;
import ch.laoe.clip.MMArray;
import ch.laoe.operation.AOToolkit;
import ch.laoe.operation.AOperation;
import java.util.ArrayList;

public class AChannelSelection
extends ASelection {
    private static int nameCounter;
    private ASelectionPlotter plotter = new ASelectionPlotter(this);
    private int offset;
    private int length;
    private ArrayList intensityPoints;
    private boolean intensityUsed = false;
    private int activeIntensityPointIndex = -1;
    public static final int LINEAR_INTENSITY_SCALE = 1;
    public static final int SQUARE_INTENSITY_SCALE = 2;
    public static final int CUBIC_INTENSITY_SCALE = 3;
    public static final int SQUARE_ROOT_INTENSITY_SCALE = -1;
    private static int intensityScale;
    private MMArray px;
    private MMArray py;
    private boolean intensityChanged;

    public AChannelSelection(AChannel aChannel) {
        super(aChannel);
        this.initIntensityPoints();
    }

    public AChannelSelection() {
        super(null);
        this.initIntensityPoints();
        this.length = 0;
    }

    public AChannelSelection(AChannel aChannel, int n, int n2) {
        this(aChannel);
        this.setOffset(n);
        this.setLength(n2);
    }

    public AChannelSelection(AChannelSelection aChannelSelection) {
        this((AChannel)aChannelSelection.model);
        this.name = aChannelSelection.name;
        this.offset = aChannelSelection.offset;
        this.length = aChannelSelection.length;
        this.plotter = aChannelSelection.plotter;
        this.intensityPoints = new ArrayList();
        for (int i = 0; i < aChannelSelection.getIntensityPoints().size(); ++i) {
            this.intensityPoints.add(new Point((Point)aChannelSelection.getIntensityPoints().get(i)));
        }
        this.intensityUsed = aChannelSelection.intensityUsed;
    }

    public AChannel getChannel() {
        return (AChannel)this.model;
    }

    public void setChannel(AChannel aChannel) {
        this.model = aChannel;
    }

    @Override
    public void setDefaultName() {
        this.setDefaultName("channelSelection", nameCounter++);
    }

    public ASelectionPlotter getPlotter() {
        return this.plotter;
    }

    public void setOffset(int n) {
        this.offset = n < 0 ? 0 : n;
    }

    public int getOffset() {
        return this.offset;
    }

    public void setLength(int n) {
        this.length = n < 0 ? 0 : n;
    }

    public int getLength() {
        return this.length;
    }

    public boolean isSelected(int n) {
        return n >= this.offset && n < this.offset + this.length;
    }

    @Override
    public boolean isSelected() {
        return this.length > 0;
    }

    public ArrayList getIntensityPoints() {
        this.intensityChanged = true;
        return this.intensityPoints;
    }

    public int searchLeftIntensityPointIndex(float f) {
        for (int i = 0; i < this.intensityPoints.size(); ++i) {
            if (!(f < ((Point)this.intensityPoints.get((int)i)).x)) continue;
            return i;
        }
        return 0;
    }

    public int searchNearestIntensityPointIndex(float f) {
        float f2 = Float.MAX_VALUE;
        int n = 0;
        for (int i = 0; i < this.intensityPoints.size(); ++i) {
            float f3 = Math.abs(f - ((Point)this.intensityPoints.get((int)i)).x);
            if (!(f3 < f2)) continue;
            f2 = f3;
            n = i;
        }
        return n;
    }

    public void addIntensityPoint(float f, float f2) {
        int n;
        for (n = 0; n < this.intensityPoints.size(); ++n) {
            if (f != ((Point)this.intensityPoints.get((int)n)).x) continue;
            this.modifyIntensityPoint(n, f, f2);
            return;
        }
        if (f > 0.0f && f < 1.0f && (n = this.searchLeftIntensityPointIndex(f)) > 0 && n < this.intensityPoints.size()) {
            this.intensityPoints.add(n, new Point(f, f2));
            this.intensityChanged = true;
            this.intensityUsed = true;
        }
    }

    public void modifyIntensityPoint(int n, float f, float f2) {
        Point point = (Point)this.intensityPoints.get(n);
        point.y = f2;
        if (n > 0 && n < this.intensityPoints.size() - 1) {
            float f3 = ((Point)this.intensityPoints.get((int)(n - 1))).x;
            float f4 = ((Point)this.intensityPoints.get((int)(n + 1))).x;
            point.x = f < f3 ? f3 + 0.001f : (f > f4 ? f4 - 0.001f : f);
        }
        this.intensityChanged = true;
        this.intensityUsed = true;
    }

    public void removeIntensityPoint(float f) {
        int n = this.searchNearestIntensityPointIndex(f);
        if (n > 0 && n < this.intensityPoints.size() - 1) {
            this.intensityPoints.remove(n);
            this.intensityChanged = true;
            this.intensityUsed = true;
        }
    }

    public void clearIntensity() {
        this.intensityPoints.clear();
        this.intensityPoints.add(new Point(0.0f, 1.0f));
        this.intensityPoints.add(new Point(1.0f, 1.0f));
        this.intensityChanged = true;
        this.intensityUsed = false;
    }

    public void setActiveIntensityPoint(float f) {
        this.activeIntensityPointIndex = f > 0.0f && f < 1.0f ? this.searchNearestIntensityPointIndex(f) : -1;
    }

    public int getActiveIntensityPointIndex() {
        return this.activeIntensityPointIndex;
    }

    public static void setIntensityScale(int n) {
        intensityScale = n;
    }

    public float getIntensity(int n) {
        if (!this.intensityUsed) {
            return 1.0f;
        }
        if (this.intensityChanged) {
            this.px = new MMArray(this.intensityPoints.size(), 0.0f);
            this.py = new MMArray(this.intensityPoints.size(), 0.0f);
            for (int i = 0; i < this.intensityPoints.size(); ++i) {
                this.px.set(i, ((Point)this.intensityPoints.get((int)i)).x);
                this.py.set(i, ((Point)this.intensityPoints.get((int)i)).y);
            }
            this.intensityChanged = false;
        }
        float f = AOToolkit.interpolate1(this.px, this.py, ((float)n - (float)this.getOffset()) / (float)this.getLength());
        switch (intensityScale) {
            case 2: {
                return f * f;
            }
            case 3: {
                return f * f * f;
            }
            case -1: {
                return (float)Math.sqrt(f);
            }
        }
        return f;
    }

    public float mixIntensity(int n, float f, float f2) {
        float f3 = this.getIntensity(n);
        return f2 * f3 + f * (1.0f - f3);
    }

    private void initIntensityPoints() {
        if (this.intensityPoints == null) {
            this.intensityPoints = new ArrayList();
            this.clearIntensity();
        }
    }

    public void operateChannel(AOperation aOperation) {
        aOperation.startOperation();
        if (this.isSelected()) {
            aOperation.operate(this);
        }
        aOperation.endOperation();
        System.gc();
    }

    static {
        intensityScale = 1;
    }

    public class Point {
        public float x;
        public float y;

        public Point(Point point) {
            this.x = point.x;
            this.y = point.y;
        }

        public Point(float f, float f2) {
            this.setPoint(f, f2);
        }

        public void setPoint(float f, float f2) {
            this.x = f > 1.0f ? 1.0f : (f < 0.0f ? 0.0f : f);
            this.y = f2 > 1.0f ? 1.0f : (f2 < 0.0f ? 0.0f : f2);
        }
    }
}

