/*
 * Decompiled with CFR 0.152.
 */
package ch.laoe.clip;

import ch.laoe.clip.AChannel;
import ch.laoe.clip.AChannelPlotter;
import ch.laoe.clip.AClip;
import ch.laoe.clip.AModel;
import ch.laoe.clip.MMArray;
import ch.laoe.operation.AOToolkit;
import ch.laoe.ui.Debug;
import ch.laoe.ui.GToolkit;
import java.awt.Color;
import java.awt.Graphics2D;

public class AChannelPlotterSpectrogram
extends AChannelPlotter {
    private static int fftLength = 512;
    public static final int HAMMING_WINDOW = 1;
    public static final int RECTANGULAR_WINDOW = 2;
    public static final int BLACKMAN_WINDOW = 3;
    public static final int FLATTOP_WINDOW = 4;
    private static int windowType = 1;
    private Color[] colorGrade = new Color[777];
    private int oldRgb = 0;
    private float oldGamma = 0.0f;

    public AChannelPlotterSpectrogram(AModel aModel, AChannelPlotter aChannelPlotter) {
        super(aModel, aChannelPlotter);
    }

    @Override
    public float getAutoscaleXOffset() {
        return 0.0f;
    }

    @Override
    public float getAutoscaleXLength() {
        return this.getChannelModel().getSampleLength();
    }

    @Override
    public float getAutoscaleYOffset(int n, int n2) {
        return 0.0f;
    }

    @Override
    public float getAutoscaleYLength(int n, int n2) {
        return ((AClip)this.getChannelModel().getParent().getParent()).getSampleRate() / 2.0f;
    }

    @Override
    protected float getValidYOffset() {
        return 0.0f;
    }

    @Override
    protected float getValidYLength() {
        return ((AClip)this.getChannelModel().getParent().getParent()).getSampleRate() / 2.0f;
    }

    public static void setFftLength(int n) {
        switch (n) {
            case 32: 
            case 64: 
            case 128: 
            case 256: 
            case 512: 
            case 1024: 
            case 2048: 
            case 4096: 
            case 8192: {
                fftLength = n;
                break;
            }
            default: {
                fftLength = 512;
            }
        }
    }

    public static int getFftLength() {
        return fftLength;
    }

    public static void setWindowType(int n) {
        switch (n) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                windowType = n;
                break;
            }
            default: {
                windowType = 1;
            }
        }
    }

    public static int getWindowType() {
        return windowType;
    }

    private void setColorGamma(float f) {
        if (f != this.oldGamma) {
            if (f < 0.0f) {
                f = 0.0f;
            }
            if (f > 1.0f) {
                f = 1.0f;
            }
            this.oldGamma = f;
            this.updateColorPalette();
        }
    }

    private void setColor(Color color) {
        if (color.getRGB() != this.oldRgb) {
            this.oldRgb = color.getRGB();
            this.updateColorPalette();
        }
    }

    private void updateColorPalette() {
        Debug.println(3, "spectrogram plotter: update color palette");
        Color color = new Color(this.oldRgb);
        for (int i = 0; i < this.colorGrade.length; ++i) {
            float f = (float)Math.pow(1.0f * (float)i / (float)this.colorGrade.length, 1.0f - this.oldGamma);
            System.out.println("gamma[" + i + "]=" + f);
            this.colorGrade[i] = GToolkit.mixColors(Color.lightGray, color, f);
        }
    }

    private Color getColorGrade(float f) {
        int n = (int)(Math.abs(f) * (float)this.colorGrade.length);
        if (n > this.colorGrade.length - 1) {
            n = this.colorGrade.length - 1;
        }
        return this.colorGrade[n];
    }

    @Override
    public void paintSamples(Graphics2D graphics2D, Color color, float f) {
        try {
            int n;
            int n2;
            this.setColor(color);
            this.setColorGamma(f);
            graphics2D.setClip(this.rectangle.x, this.rectangle.y, this.rectangle.width, this.rectangle.height);
            AChannel aChannel = this.getChannelModel();
            AClip aClip = (AClip)aChannel.getParent().getParent();
            int n3 = 1 << aClip.getSampleWidth() - 1;
            int n4 = this.rectangle.width;
            int n5 = this.rectangle.height;
            int n6 = this.rectangle.x;
            int n7 = this.rectangle.y;
            float f2 = aClip.getSampleRate();
            MMArray mMArray = new MMArray(fftLength, 0.0f);
            MMArray mMArray2 = new MMArray(fftLength, 0.0f);
            int[] nArray = new int[fftLength / 2 + 1];
            for (n2 = 0; n2 < fftLength / 2 + 1; ++n2) {
                nArray[n2] = this.sampleToGraphY((float)n2 * f2 / (float)fftLength);
            }
            block8: for (n2 = n6; n2 < n6 + n4; n2 += n) {
                int n8 = (int)this.graphToSampleX(n2);
                n = Math.max((this.sampleToGraphX(n8 + fftLength) - n2) / 8, 1);
                if (n8 < aChannel.getSampleLength()) {
                    int n9;
                    if (n8 < 0) continue;
                    mMArray.copy(aChannel.getSamples(), n8, 0, fftLength);
                    for (n9 = 0; n9 < fftLength; ++n9) {
                        mMArray2.set(n9, 0.0f);
                    }
                    switch (windowType) {
                        case 1: {
                            AOToolkit.applyHammingWindow(mMArray, fftLength);
                            break;
                        }
                        case 3: {
                            AOToolkit.applyBlackmanWindow(mMArray, fftLength);
                            break;
                        }
                        case 4: {
                            AOToolkit.applyFlattopWindow(mMArray, fftLength);
                            break;
                        }
                        default: {
                            AOToolkit.applyRectangularWindow(mMArray, fftLength);
                        }
                    }
                    AOToolkit.complexFft(mMArray, mMArray2);
                    for (n9 = 0; n9 < fftLength / 2; ++n9) {
                        mMArray.set(n9, AOToolkit.cartesianToMagnitude(mMArray.get(n9), mMArray2.get(n9)));
                    }
                    for (n9 = 0; n9 < fftLength / 2; ++n9) {
                        if (nArray[n9] > n7 + n5) continue;
                        if (nArray[n9] < n7) continue block8;
                        graphics2D.setColor(this.getColorGrade(mMArray.get(n9) / (float)n3));
                        graphics2D.fillRect(n2, nArray[n9 + 1], n, nArray[n9] - nArray[n9 + 1]);
                    }
                    continue;
                }
                break;
            }
        }
        catch (Exception exception) {
            Debug.printStackTrace(5, exception);
        }
    }
}

