/*
 * Decompiled with CFR 0.152.
 */
package ch.laoe.clip;

import ch.laoe.clip.AChannel;
import ch.laoe.clip.AChannelPlotter;
import ch.laoe.clip.AClip;
import ch.laoe.clip.ALayer;
import ch.laoe.clip.AModel;
import ch.laoe.clip.MMArray;
import ch.laoe.operation.AOSpline;
import ch.laoe.operation.AOToolkit;
import ch.laoe.ui.Debug;
import java.awt.Color;
import java.awt.Graphics2D;

public class AChannelPlotterSampleCurve
extends AChannelPlotter {
    private int style = 1;
    public static final int FILLED = 1;
    public static final int DRAWED = 2;
    private AOSpline spline = AOToolkit.createSpline();
    private MMArray x = null;
    private MMArray y = null;
    private MMArray cachedMin;
    private MMArray cachedMax;
    private static final int reduction = 333;
    private String oldId = "";

    public AChannelPlotterSampleCurve(AModel aModel, AChannelPlotter aChannelPlotter) {
        super(aModel, aChannelPlotter);
    }

    @Override
    public float getAutoscaleXOffset() {
        return 0.0f;
    }

    @Override
    public float getAutoscaleXLength() {
        return this.getChannelModel().getSampleLength();
    }

    @Override
    public float getAutoscaleYOffset(int n, int n2) {
        return -this.getChannelModel().getMaxSampleValue(n, n2);
    }

    @Override
    public float getAutoscaleYLength(int n, int n2) {
        return 2.0f * this.getChannelModel().getMaxSampleValue(n, n2);
    }

    @Override
    protected float getValidYOffset() {
        return -(1 << ((AClip)this.getChannelModel().getParent().getParent()).getSampleWidth() - 1);
    }

    @Override
    protected float getValidYLength() {
        return 1 << ((AClip)this.getChannelModel().getParent().getParent()).getSampleWidth();
    }

    public void setStyle(int n) {
        this.style = n;
    }

    private final void reloadCache() {
        AChannel aChannel = this.getChannelModel();
        if (!this.oldId.equals(aChannel.getChangeId())) {
            this.oldId = aChannel.getChangeId();
            Debug.println(7, "reload cache of channel plotter name=" + aChannel.getName() + " id=" + aChannel.getChangeId());
            this.cachedMin = new MMArray(aChannel.getSampleLength() / 333, 0.0f);
            this.cachedMax = new MMArray(aChannel.getSampleLength() / 333, 0.0f);
            for (int i = 0; i < this.cachedMin.getLength(); ++i) {
                this.cachedMin.set(i, this.getMinSample(i * 333, (i + 1) * 333));
                this.cachedMax.set(i, this.getMaxSample(i * 333, (i + 1) * 333));
            }
        }
    }

    private final float getMinSample(int n, int n2) {
        if (n2 - n > 666) {
            n2 /= 333;
            float f = this.cachedMin.get(n /= 333);
            for (int i = n; i <= n2; ++i) {
                float f2 = this.cachedMin.get(i);
                if (!(f2 < f)) continue;
                f = f2;
            }
            return f;
        }
        AChannel aChannel = this.getChannelModel();
        float f = aChannel.getSample(n);
        for (int i = n; i <= n2; ++i) {
            float f3 = aChannel.getSample(i);
            if (!(f3 < f)) continue;
            f = f3;
        }
        return f;
    }

    private final float getMaxSample(int n, int n2) {
        if (n2 - n > 666) {
            n2 /= 333;
            float f = this.cachedMax.get(n /= 333);
            for (int i = n; i <= n2; ++i) {
                float f2 = this.cachedMax.get(i);
                if (!(f2 > f)) continue;
                f = f2;
            }
            return f;
        }
        AChannel aChannel = this.getChannelModel();
        float f = aChannel.getSample(n);
        for (int i = n; i <= n2; ++i) {
            float f3 = aChannel.getSample(i);
            if (!(f3 > f)) continue;
            f = f3;
        }
        return f;
    }

    @Override
    public void paintSamples(Graphics2D graphics2D, Color color, float f) {
        try {
            int n;
            AChannel aChannel = this.getChannelModel();
            ALayer aLayer = (ALayer)aChannel.getParent();
            int n2 = this.rectangle.width;
            int n3 = this.rectangle.height;
            switch (aLayer.getType()) {
                case 1: {
                    this.style = 1;
                    break;
                }
                default: {
                    this.style = 2;
                }
            }
            float f2 = 0.0f;
            float f3 = 0.0f;
            boolean bl = true;
            graphics2D.setColor(color);
            graphics2D.setClip(this.rectangle.x, this.rectangle.y, this.rectangle.width, this.rectangle.height);
            int n4 = (int)this.getXLength() + 3;
            if ((double)((float)n2 / this.getXLength()) > 2.5) {
                if (this.x == null || this.x.getLength() != n4) {
                    this.x = new MMArray(n4, 0.0f);
                    this.y = new MMArray(n4, 0.0f);
                }
                for (n = 0; n < n4; ++n) {
                    this.x.set(n, this.sampleToGraphX((int)this.getXOffset() + n));
                    this.y.set(n, this.sampleToGraphY(aChannel.getSample((int)this.getXOffset() + n)));
                }
                n = (int)this.x.get(0) - 1;
                int n5 = (int)this.y.get(0);
                this.spline.load(this.x, this.y);
                for (int i = 0; i < n2; ++i) {
                    int n6 = i;
                    int n7 = (int)this.spline.getResult(i);
                    if (aChannel.getSamples().isInRange((int)this.graphToSampleX(n6))) {
                        graphics2D.drawLine(n, n5, n6, n7);
                    }
                    n = n6;
                    n5 = n7;
                }
            } else {
                this.reloadCache();
                for (n = 0; n < n2; ++n) {
                    int n8 = (int)this.graphToSampleX(n);
                    int n9 = (int)this.graphToSampleX(n + 1);
                    if (n8 < aChannel.getSampleLength() && n9 < aChannel.getSampleLength()) {
                        if (n8 < 0 || n9 < 0) continue;
                        float f4 = aChannel.getSample(n8);
                        float f5 = aChannel.getSample(n8);
                        f5 = this.getMinSample(n8, n9);
                        f4 = this.getMaxSample(n8, n9);
                        f5 = this.sampleToGraphY(f5);
                        f4 = this.sampleToGraphY(f4);
                        if (bl) {
                            bl = false;
                            f3 = f5;
                            f2 = f4;
                        }
                        switch (this.style) {
                            case 2: {
                                graphics2D.drawLine(n - 1, (int)f3, n, (int)f5);
                                graphics2D.drawLine(n - 1, (int)f2, n, (int)f4);
                                break;
                            }
                            case 1: {
                                graphics2D.drawLine(n, (int)f5, n, (int)f4);
                            }
                        }
                        f3 = f5;
                        f2 = f4;
                        continue;
                    }
                    break;
                }
            }
            if ((float)n2 / this.getXLength() > 5.0f) {
                for (n = 0; n < n4; ++n) {
                    if (!aChannel.getSamples().isInRange((int)this.graphToSampleX((int)this.x.get(n)))) continue;
                    graphics2D.fillRect((int)this.x.get(n) - 2, (int)this.y.get(n) - 2, 4, 4);
                }
            }
        }
        catch (Exception exception) {
            Debug.printStackTrace(5, exception);
        }
    }
}

