/*
 * Decompiled with CFR 0.152.
 */
package ch.laoe.clip;

import ch.laoe.clip.AChannel;
import ch.laoe.clip.AChannelSelection;
import ch.laoe.clip.AClip;
import ch.laoe.clip.AClipPlotter;
import ch.laoe.clip.AModel;
import ch.laoe.clip.APlotter;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.text.NumberFormat;

public abstract class AChannelPlotter
extends APlotter {
    private float xOffset;
    private float xLength = 1.0f;
    private float yOffset;
    private float yLength = 1.0f;
    protected Rectangle rectangle = new Rectangle(1, 1);

    public AChannelPlotter(AModel aModel) {
        super(aModel);
    }

    public AChannelPlotter(AModel aModel, AChannelPlotter aChannelPlotter) {
        this(aModel);
        if (aChannelPlotter != null) {
            this.xOffset = aChannelPlotter.xOffset;
            this.xLength = aChannelPlotter.xLength;
            this.yOffset = aChannelPlotter.yOffset;
            this.yLength = aChannelPlotter.yLength;
        }
    }

    public AChannel getChannelModel() {
        return (AChannel)this.model;
    }

    @Override
    public void setDefaultName() {
        this.name = "";
    }

    public float getXOffset() {
        return this.xOffset;
    }

    public float getXLength() {
        return this.xLength;
    }

    public float getYOffset() {
        return this.yOffset;
    }

    public float getYLength() {
        return this.yLength;
    }

    public abstract float getAutoscaleXOffset();

    public abstract float getAutoscaleXLength();

    public abstract float getAutoscaleYOffset(int var1, int var2);

    public abstract float getAutoscaleYLength(int var1, int var2);

    protected abstract float getValidYOffset();

    protected abstract float getValidYLength();

    public void setXRange(float f, float f2) {
        this.xOffset = f;
        this.xLength = f2;
        this.limitXRange();
    }

    public void setYRange(float f, float f2) {
        this.yOffset = f;
        this.yLength = f2;
        this.limitYRange();
    }

    public void translateXOffset(float f) {
        this.xOffset += f;
        this.limitXRange();
    }

    public void translateYOffset(float f) {
        this.yOffset += f;
        this.limitYRange();
    }

    private void limitXRange() {
        if (this.xOffset < -1.0737418E9f) {
            this.xOffset = -1.0737418E9f;
        } else if (this.xOffset > 1.0737418E9f) {
            this.xOffset = 1.0737418E9f;
        }
        if (this.xLength > 2.1474836E9f) {
            this.xLength = 2.1474836E9f;
        } else if (this.xLength < 0.1f) {
            this.xLength = 0.1f;
        }
    }

    private void limitYRange() {
        if (this.yOffset > 2.1474836E9f) {
            this.yOffset = 2.1474836E9f;
        } else if (this.yOffset < -2.1474836E9f) {
            this.yOffset = -2.1474836E9f;
        }
        if (this.yLength > 2.1474836E9f) {
            this.yLength = 2.1474836E9f;
        }
        if ((double)Math.abs(this.yLength) < 1.0E-12) {
            this.yLength = 1.0E-12f;
        }
    }

    public void zoomX(float f) {
        this.xOffset += this.xLength * (1.0f - 1.0f / f) / 2.0f;
        this.xLength /= f;
        this.limitXRange();
    }

    public void zoomX(float f, float f2) {
        float f3 = f2 - this.xOffset;
        float f4 = f3 / f;
        this.xOffset += f3 - f4;
        this.xLength /= f;
        this.limitXRange();
    }

    public void zoomY(float f) {
        this.yOffset += this.yLength * (1.0f - 1.0f / f) / 2.0f;
        this.yLength /= f;
        this.limitYRange();
    }

    public int sampleToGraphX(float f) {
        return (int)((f - this.xOffset) * (float)this.rectangle.width / this.xLength) + this.rectangle.x;
    }

    public int sampleToGraphY(float f) {
        return (int)((this.yLength - f + this.yOffset) * (float)this.rectangle.height / this.yLength) + this.rectangle.y;
    }

    public int percentToGraphY(float f) {
        return (int)((1.0f - f) * (float)this.rectangle.height) + this.rectangle.y;
    }

    public float graphToSampleX(int n) {
        return this.xOffset + (float)(n - this.rectangle.x) * this.xLength / (float)this.rectangle.width;
    }

    public float graphToSampleY(int n) {
        return this.yOffset + (float)(this.rectangle.height - n + this.rectangle.y) * this.yLength / (float)this.rectangle.height;
    }

    public float graphToPercentY(float f) {
        return ((float)this.rectangle.height - f + (float)this.rectangle.y) / (float)this.rectangle.height;
    }

    public void setRectangle(Rectangle rectangle) {
        this.rectangle = rectangle;
    }

    public Rectangle getRectangle() {
        return this.rectangle;
    }

    public boolean isInsideChannel(Point point) {
        return point.y >= this.rectangle.y && point.y <= this.rectangle.y + this.rectangle.height && point.x >= this.rectangle.x && point.y <= this.rectangle.x + this.rectangle.width;
    }

    public void paintFrame(Graphics2D graphics2D) {
        int n = this.rectangle.width;
        int n2 = this.rectangle.height;
        int n3 = this.rectangle.x;
        int n4 = this.rectangle.y;
        int n5 = this.sampleToGraphY(0.0f);
        int n6 = this.sampleToGraphY(this.getValidYOffset());
        int n7 = this.sampleToGraphY(this.getValidYOffset() + this.getValidYLength());
        graphics2D.setClip(this.rectangle.x, this.rectangle.y, this.rectangle.width, this.rectangle.height);
        graphics2D.setColor(new Color(0x7F3F3F3F, true));
        graphics2D.drawLine(n3, n5, n3 + n - 1, n5);
        graphics2D.setColor(new Color(0x7F999999, true));
        graphics2D.drawLine(n3, n7, n3 + n - 1, n7);
        graphics2D.drawLine(n3, n6, n3 + n - 1, n6);
        graphics2D.setColor(Color.gray);
        graphics2D.drawRect(n3, n4, n - 2, n2 - 2);
        graphics2D.setColor(Color.white);
        graphics2D.drawRect(n3 + 1, n4 + 1, n - 2, n2 - 2);
    }

    public abstract void paintSamples(Graphics2D var1, Color var2, float var3);

    public void paintMask(Graphics2D graphics2D, Color color) {
        this.getChannelModel().getMask().paintOntoClip(graphics2D, this.rectangle);
    }

    public void paintMarker(Graphics2D graphics2D, Rectangle rectangle) {
        this.getChannelModel().getMarker().paintOntoClip(graphics2D, rectangle);
    }

    public void paintSelection(Graphics2D graphics2D, Color color) {
        AChannelSelection aChannelSelection = this.getChannelModel().getChannelSelection();
        AClipPlotter aClipPlotter = ((AClip)this.model.getParent().getParent()).getClipPlotter();
        if (aChannelSelection.isSelected()) {
            int n;
            int n2;
            Object object;
            int n3;
            int n4 = this.sampleToGraphX(aChannelSelection.getOffset());
            int n5 = this.rectangle.y + 2;
            int n6 = this.sampleToGraphX(aChannelSelection.getOffset() + aChannelSelection.getLength());
            int n7 = this.rectangle.height - 5;
            if (n4 < 0) {
                n4 = -50;
            } else if (n4 > this.rectangle.width) {
                return;
            }
            if (n6 > this.rectangle.width) {
                n6 = this.rectangle.width + 50;
            } else if (n6 < 0) {
                return;
            }
            graphics2D.setColor(color);
            graphics2D.setClip(this.rectangle.x, this.rectangle.y, this.rectangle.width, this.rectangle.height);
            graphics2D.setComposite(AlphaComposite.getInstance(3, 0.18f));
            graphics2D.fillRect(n4, n5, n6 - n4, n7);
            float[] fArray = new float[]{4.0f, 4.0f};
            graphics2D.setStroke(new BasicStroke(1.0f, 2, 0, 1.0f, fArray, 0.0f));
            graphics2D.setColor(color.darker());
            graphics2D.setComposite(AlphaComposite.getInstance(3, 1.0f));
            graphics2D.drawRect(n4, n5, n6 - n4, n7);
            graphics2D.setStroke(new BasicStroke());
            graphics2D.setComposite(AlphaComposite.getInstance(3, 1.0f));
            int n8 = 0;
            int n9 = 0;
            for (n3 = 0; n3 < aChannelSelection.getIntensityPoints().size(); ++n3) {
                object = (AChannelSelection.Point)aChannelSelection.getIntensityPoints().get(n3);
                n2 = this.sampleToGraphX((float)aChannelSelection.getOffset() + (float)aChannelSelection.getLength() * ((AChannelSelection.Point)object).x);
                n = (int)((1.0f - ((AChannelSelection.Point)object).y) * (float)n7) + n5;
                if (n3 > 0) {
                    graphics2D.setColor(color);
                    graphics2D.drawLine(n8, n9, n2, n);
                }
                n8 = n2;
                n9 = n;
            }
            for (n3 = 0; n3 < aChannelSelection.getIntensityPoints().size(); ++n3) {
                object = (AChannelSelection.Point)aChannelSelection.getIntensityPoints().get(n3);
                n2 = this.sampleToGraphX((float)aChannelSelection.getOffset() + (float)aChannelSelection.getLength() * ((AChannelSelection.Point)object).x);
                n = (int)((1.0f - ((AChannelSelection.Point)object).y) * (float)n7) + n5;
                if (aChannelSelection.getActiveIntensityPointIndex() == n3) {
                    graphics2D.setColor(Color.red);
                } else {
                    graphics2D.setColor(color);
                }
                graphics2D.fillRect(n2 - 2, n - 2, 4, 4);
            }
            NumberFormat numberFormat = NumberFormat.getInstance();
            numberFormat.setMaximumFractionDigits(4);
            numberFormat.setGroupingUsed(false);
            graphics2D.setColor(Color.white);
            graphics2D.setFont(new Font("Courrier", 0, 12));
            object = graphics2D.getFontMetrics();
            String string = "" + numberFormat.format(aClipPlotter.toPlotterXUnit(aChannelSelection.getOffset())) + aClipPlotter.getPlotterXUnitName();
            String string2 = "" + numberFormat.format(aClipPlotter.toPlotterXUnit(aChannelSelection.getLength())) + aClipPlotter.getPlotterXUnitName();
            int n10 = (n6 + n4) / 2;
            int n11 = n5 + n7 / 2;
            graphics2D.drawString(string, n10 - ((FontMetrics)object).stringWidth(string) / 2, n11 - ((FontMetrics)object).getHeight() / 2);
            graphics2D.drawString(string2, n10 - ((FontMetrics)object).stringWidth(string2) / 2, n11 + ((FontMetrics)object).getHeight() / 2);
        }
    }

    private float getNearestDecade(float f) {
        return (float)Math.pow(10.0, Math.round(Math.log10((double)f * 0.6)));
    }

    private void paintText(Graphics2D graphics2D, String string, int n, int n2, int n3, boolean bl) {
        if (bl) {
            graphics2D.setFont(new Font("Courrier", 0, n));
            FontMetrics fontMetrics = graphics2D.getFontMetrics();
            int n4 = fontMetrics.stringWidth(string) * 2;
            BufferedImage bufferedImage = new BufferedImage(n4, n4, 6);
            Graphics2D graphics2D2 = (Graphics2D)bufferedImage.getGraphics();
            graphics2D2.setColor(Color.BLACK);
            graphics2D2.setFont(new Font("Courrier", 0, n));
            graphics2D2.drawString(string, n4 / 2, n4 / 2 + fontMetrics.getAscent() - fontMetrics.getHeight() / 2);
            AffineTransform affineTransform = new AffineTransform();
            affineTransform.rotate(-1.5707963267948966, n4 / 2, n4 / 2);
            AffineTransformOp affineTransformOp = new AffineTransformOp(affineTransform, 2);
            bufferedImage = affineTransformOp.filter(bufferedImage, null);
            graphics2D.drawImage((Image)bufferedImage, n2 - n4 / 2, n3 - n4 / 2, null);
        } else {
            graphics2D.setFont(new Font("Courrier", 0, n));
            FontMetrics fontMetrics = graphics2D.getFontMetrics();
            graphics2D.drawString(string, n2 - fontMetrics.stringWidth(string) / 2, n3 + fontMetrics.getAscent() - fontMetrics.getHeight() / 2);
        }
    }

    private static String floatToString(float f) {
        String string = "";
        if ((double)Math.abs(f) >= 1.0E9) {
            f = (float)((double)f / 1.0E9);
            string = "G";
        } else if ((double)Math.abs(f) >= 1000000.0) {
            f = (float)((double)f / 1000000.0);
            string = "M";
        } else if ((double)Math.abs(f) >= 1000.0) {
            f = (float)((double)f / 1000.0);
            string = "k";
        } else if ((double)Math.abs(f) >= 1.0) {
            string = "";
        } else if ((double)Math.abs(f) >= 0.001) {
            f = (float)((double)f / 0.001);
            string = "m";
        } else if ((double)Math.abs(f) >= 1.0E-6) {
            f = (float)((double)f / 1.0E-6);
            string = "u";
        }
        NumberFormat numberFormat = NumberFormat.getInstance();
        numberFormat.setMaximumFractionDigits(5);
        numberFormat.setGroupingUsed(false);
        return numberFormat.format(f) + string;
    }

    public void paintXSkala(Graphics2D graphics2D, Rectangle rectangle) {
        if ((double)this.getXLength() < 0.1) {
            return;
        }
        graphics2D.setClip(rectangle.x, rectangle.y - 200, rectangle.width, rectangle.height + 200);
        graphics2D.setComposite(AlphaComposite.getInstance(3, 1.0f));
        AChannel aChannel = this.getChannelModel();
        int n = Math.max(0, this.sampleToGraphX(0.0f));
        int n2 = Math.min(rectangle.x + rectangle.width, this.sampleToGraphX(aChannel.getSampleLength()));
        graphics2D.setColor(Color.white);
        graphics2D.fillRect(n, rectangle.y, n2 - n, rectangle.height);
        AClipPlotter aClipPlotter = ((AClip)this.model.getParent().getParent()).getClipPlotter();
        float f = aClipPlotter.toPlotterXUnit(this.graphToSampleX(rectangle.x));
        int n3 = 5;
        int n4 = (int)((double)rectangle.height * 0.3);
        int n5 = (int)((double)rectangle.height * 0.5);
        int n6 = (int)((double)rectangle.height * 0.8);
        for (int i = 0; i < rectangle.width; ++i) {
            float f2;
            double d;
            float f3 = aClipPlotter.toPlotterXUnit(this.graphToSampleX(rectangle.x + i));
            if ((int)((double)f3 / (d = Math.pow(10.0, Math.round(Math.log10(Math.abs(f2 = f3 - aClipPlotter.toPlotterXUnit(this.graphToSampleX(rectangle.x + i + n3))))))) / 10.0) != (int)((double)f / d / 10.0) || Math.signum(f3) != Math.signum(f)) {
                graphics2D.setColor(Color.gray);
                graphics2D.drawLine(rectangle.x + i, rectangle.y, rectangle.x + i, rectangle.y + n6);
                if (AClipPlotter.isSkalaValuesVisible()) {
                    float f4 = (float)((double)Math.round((double)f3 / d) * d);
                    graphics2D.setColor(Color.BLACK);
                    this.paintText(graphics2D, AChannelPlotter.floatToString(f4) + aClipPlotter.getPlotterXUnitName(), 10, rectangle.x + i, rectangle.y - 6, true);
                }
            } else if ((int)((double)f3 / d / 5.0) != (int)((double)f / d / 5.0) || Math.signum(f3) != Math.signum(f)) {
                graphics2D.setColor(Color.gray);
                graphics2D.drawLine(rectangle.x + i, rectangle.y, rectangle.x + i, rectangle.y + n5);
            } else if ((int)((double)f3 / d) != (int)((double)f / d) || Math.signum(f3) != Math.signum(f)) {
                graphics2D.setColor(Color.gray);
                graphics2D.drawLine(rectangle.x + i, rectangle.y, rectangle.x + i, rectangle.y + n4);
            }
            f = f3;
        }
    }

    public void paintYSkala(Graphics2D graphics2D, Rectangle rectangle) {
        if ((double)this.getYLength() < 0.1) {
            return;
        }
        graphics2D.setClip(rectangle.x, rectangle.y, rectangle.width + 100, rectangle.height);
        graphics2D.setComposite(AlphaComposite.getInstance(3, 1.0f));
        int n = Math.max(0, this.sampleToGraphY(this.getValidYOffset() + this.getValidYLength()));
        int n2 = Math.min(rectangle.y + rectangle.height, this.sampleToGraphY(this.getValidYOffset()));
        graphics2D.setColor(Color.white);
        graphics2D.fillRect(rectangle.x, n, rectangle.width, n2 - n);
        AClipPlotter aClipPlotter = ((AClip)this.model.getParent().getParent()).getClipPlotter();
        float f = aClipPlotter.toPlotterYUnit(this.graphToSampleY(rectangle.y));
        int n3 = 5;
        int n4 = (int)((double)rectangle.width * 0.3);
        int n5 = (int)((double)rectangle.width * 0.5);
        int n6 = (int)((double)rectangle.width * 0.8);
        for (int i = 0; i < rectangle.height; ++i) {
            float f2;
            double d;
            float f3 = aClipPlotter.toPlotterYUnit(this.graphToSampleY(rectangle.y + i));
            if ((int)((double)f3 / (d = Math.pow(10.0, Math.round(Math.log10(Math.abs(f2 = f3 - aClipPlotter.toPlotterYUnit(this.graphToSampleY(rectangle.y + i + n3))))))) / 10.0) != (int)((double)f / d / 10.0) || Math.signum(f3) != Math.signum(f)) {
                graphics2D.setColor(Color.gray);
                graphics2D.drawLine(rectangle.x + rectangle.width - n6, rectangle.y + i, rectangle.x + rectangle.width, rectangle.y + i);
                if (AClipPlotter.isSkalaValuesVisible()) {
                    float f4 = (float)((double)Math.round((double)f3 / d) * d);
                    graphics2D.setColor(Color.BLACK);
                    this.paintText(graphics2D, AChannelPlotter.floatToString(f4) + aClipPlotter.getPlotterYUnitName(), 10, rectangle.x + 30, rectangle.y + i, false);
                }
            } else if ((int)((double)f3 / d / 5.0) != (int)((double)f / d / 5.0) || Math.signum(f3) != Math.signum(f)) {
                graphics2D.setColor(Color.gray);
                graphics2D.drawLine(rectangle.x + rectangle.width - n5, rectangle.y + i, rectangle.x + rectangle.width, rectangle.y + i);
            } else if ((int)((double)f3 / d) != (int)((double)f / d) || Math.signum(f3) != Math.signum(f)) {
                graphics2D.setColor(Color.gray);
                graphics2D.drawLine(rectangle.x + rectangle.width - n4, rectangle.y + i, rectangle.x + rectangle.width, rectangle.y + i);
            }
            f = f3;
        }
    }
}

