/*
 * Decompiled with CFR 0.152.
 */
package ch.laoe.clip;

import ch.laoe.clip.AChannel;
import ch.laoe.clip.AObject;
import ch.laoe.ui.GEditableSegments;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;

public class AChannelMask
extends AObject {
    private GEditableSegments segments;
    private AChannel channel;
    private static int nameCounter;

    public AChannelMask(AChannel aChannel) {
        this.channel = aChannel;
        this.segments = new GEditableSegments();
        this.segments.setYDomain(2);
        this.segments.setYRange(0.0f, 1.0f);
        this.segments.setChannel(aChannel);
        this.segments.setColor(Color.black);
    }

    public GEditableSegments getSegments() {
        return this.segments;
    }

    public void setSegments(GEditableSegments gEditableSegments) {
        this.segments = gEditableSegments;
        this.segments.setChannel(this.channel);
    }

    public boolean isEnabled() {
        return this.segments.getNumberOfPoints() > 0;
    }

    @Override
    public void setDefaultName() {
        this.setDefaultName("mask", nameCounter++);
    }

    public void paintOntoClip(Graphics2D graphics2D, Rectangle rectangle) {
        this.segments.paintOntoClip(graphics2D, rectangle);
    }

    public void clear() {
        this.segments.clear();
    }

    public void setComplementary() {
        this.segments.setComplementary();
    }

    public void prepareResults() {
        this.segments.prepareResults();
    }

    public float getSample(int n) {
        return this.segments.getSample(n);
    }

    public void applyDefinitely() {
        this.prepareResults();
        for (int i = 0; i < this.channel.getSampleLength(); ++i) {
            this.channel.setSample(i, this.channel.getMaskedSample(i));
        }
        this.clear();
        this.channel.markChange();
    }
}

