/*
 * Decompiled with CFR 0.152.
 */
package ch.laoe.clip;

import ch.laoe.clip.AChannel;
import ch.laoe.clip.AChannelPlotter;
import ch.laoe.clip.AChannelSelection;
import ch.laoe.clip.AObject;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.util.ArrayList;

public class AChannelMarker
extends AObject {
    private ArrayList markers;
    private AChannel channel;
    private static int nameCounter;

    public AChannelMarker(AChannel aChannel) {
        this.channel = aChannel;
        this.markers = new ArrayList();
    }

    public AChannelMarker(AChannelMarker aChannelMarker) {
        this.channel = aChannelMarker.channel;
        this.markers = new ArrayList();
        for (int i = 0; i < aChannelMarker.markers.size(); ++i) {
            this.markers.add(new Integer(aChannelMarker.getMarkerX(i)));
        }
    }

    public void setChannel(AChannel aChannel) {
        this.channel = aChannel;
    }

    private int searchIndex(int n) {
        for (int i = 0; i < this.markers.size(); ++i) {
            if ((Integer)this.markers.get(i) != n) continue;
            return i;
        }
        return -1;
    }

    private int searchLeftMarkerIndex(int n) {
        for (int i = this.markers.size() - 1; i >= 0; --i) {
            if (this.getMarkerX(i) > n) continue;
            return i;
        }
        return -1;
    }

    private int searchRightMarkerIndex(int n) {
        for (int i = 0; i < this.markers.size(); ++i) {
            if (this.getMarkerX(i) <= n) continue;
            return i;
        }
        return -1;
    }

    public int searchLeftMarker(int n) {
        int n2 = this.searchLeftMarkerIndex(n);
        if (n2 >= 0) {
            return this.getMarkerX(n2);
        }
        return 0;
    }

    public int searchRightMarker(int n) {
        int n2 = this.searchRightMarkerIndex(n);
        if (n2 >= 0) {
            return this.getMarkerX(n2);
        }
        return this.channel.getSampleLength() - 1;
    }

    public void addMarker(int n) {
        int n2 = this.searchRightMarkerIndex(n);
        if (n2 >= 0) {
            this.markers.add(n2, new Integer(n));
        } else {
            this.markers.add(new Integer(n));
        }
    }

    public void addMarkerFromSelection(AChannelSelection aChannelSelection) {
        this.addMarker(aChannelSelection.getOffset());
        this.addMarker(aChannelSelection.getOffset() + aChannelSelection.getLength());
    }

    public int getMarkerX(int n) {
        return (Integer)this.markers.get(n);
    }

    public int getNumberOfMarkers() {
        return this.markers.size();
    }

    public void removeMarker(int n) {
        if (n >= 0) {
            this.markers.remove(n);
        }
    }

    public void moveMarker(int n, int n2) {
        int n3 = 0;
        int n4 = this.channel.getSampleLength();
        if (n > 0) {
            n3 = Math.max(n3, this.getMarkerX(n - 1));
        }
        if (n < this.getNumberOfMarkers() - 1) {
            n4 = Math.min(n4, this.getMarkerX(n + 1));
        }
        n2 = Math.max(n2, n3);
        n2 = Math.min(n2, n4);
        this.markers.set(n, new Integer(n2));
    }

    public void clear() {
        this.markers.clear();
    }

    public int searchNearestIndex(int n, int n2) {
        int n3 = Integer.MAX_VALUE;
        int n4 = -1;
        for (int i = 0; i < this.markers.size(); ++i) {
            int n5 = Math.abs(n - this.getMarkerX(i));
            if (n5 >= n2 || n5 >= n3) continue;
            n3 = n5;
            n4 = i;
        }
        return n4;
    }

    @Override
    public void setDefaultName() {
        this.setDefaultName("marker", nameCounter++);
    }

    public void paintOntoClip(Graphics2D graphics2D, Rectangle rectangle) {
        AChannelPlotter aChannelPlotter = this.channel.getChannelPlotter();
        graphics2D.setClip(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        graphics2D.setComposite(AlphaComposite.getInstance(3, 1.0f));
        for (int i = 0; i < this.markers.size(); ++i) {
            Polygon polygon = new Polygon();
            int n = aChannelPlotter.sampleToGraphX(this.getMarkerX(i));
            int n2 = rectangle.y - 1;
            polygon.addPoint(n, n2);
            polygon.addPoint(n - rectangle.height / 2, n2 + rectangle.height);
            polygon.addPoint(n + rectangle.height / 2, n2 + rectangle.height);
            graphics2D.setColor(Color.gray);
            graphics2D.fill(polygon);
            graphics2D.setColor(Color.black);
            graphics2D.draw(polygon);
        }
    }
}

