/*
 * Decompiled with CFR 0.152.
 */
package ch.laoe.clip;

import ch.laoe.clip.AChannelMarker;
import ch.laoe.clip.AChannelMask;
import ch.laoe.clip.AChannelPlotter;
import ch.laoe.clip.AChannelPlotterSampleCurve;
import ch.laoe.clip.AChannelPlotterSpectrogram;
import ch.laoe.clip.AChannelSelection;
import ch.laoe.clip.AClip;
import ch.laoe.clip.ALayer;
import ch.laoe.clip.AModel;
import ch.laoe.clip.MMArray;
import ch.laoe.ui.GGraphicObjects;
import ch.laoe.ui.GLanguage;

public class AChannel
extends AModel {
    private static int uniqueIdIndex = 0;
    private String uniqueId;
    private MMArray samples;
    private static int nameCounter;
    private boolean audible;
    private AChannelMask mask;
    private AChannelMarker marker;
    private GGraphicObjects graphicObjects;

    public AChannel() {
        this.markChange();
        this.audible = true;
        this.selection = new AChannelSelection(this);
        this.setPlotType(1);
        this.mask = new AChannelMask(this);
        this.marker = new AChannelMarker(this);
        this.createSamples(0.0f, 10);
        this.graphicObjects = new GGraphicObjects();
        this.graphicObjects.setChannel(this);
    }

    public AChannel(int n) {
        this();
        this.createSamples(0.0f, n);
    }

    public AChannel(AChannelSelection aChannelSelection) {
        this();
        this.createSamples(0.0f, aChannelSelection.getLength());
        this.samples.copy(aChannelSelection.getChannel().samples, aChannelSelection.getOffset(), 0, this.samples.getLength());
    }

    public AChannel(AChannel aChannel) {
        this(aChannel.getSampleLength());
        this.name = GLanguage.translate("copyOf") + " " + aChannel.name;
        this.samples.copy(aChannel.samples, 0, 0, aChannel.samples.getLength());
        this.selection = new AChannelSelection(aChannel.getChannelSelection());
        ((AChannelSelection)this.selection).setChannel(this);
        this.marker = new AChannelMarker(aChannel.marker);
    }

    @Override
    public void destroy() {
        this.samples.destroy();
    }

    public ALayer getParentLayer() {
        return (ALayer)this.getParent();
    }

    public AClip getParentClip() {
        return (AClip)this.getParent().getParent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markChange() {
        AChannel aChannel = this;
        synchronized (aChannel) {
        }
        this.uniqueId = "channel" + ++uniqueIdIndex;
    }

    String getChangeId() {
        return this.uniqueId;
    }

    void setChangeId(String string) {
        this.uniqueId = string;
    }

    public MMArray getSamples() {
        return this.samples;
    }

    public void setSamples(MMArray mMArray) {
        this.samples = mMArray;
    }

    public void createSamples(int n) {
        this.samples = new MMArray(n, 0.0f);
    }

    public void createSamples(float f, int n) {
        this.samples = new MMArray(n, f);
    }

    public float getSample(int n) {
        return this.samples.get(n);
    }

    public float getMaskedSample(int n) {
        if (this.isAudible()) {
            if (this.mask.isEnabled()) {
                return this.samples.get(n) * this.mask.getSample(n);
            }
            return this.samples.get(n);
        }
        return 0.0f;
    }

    public void setSample(int n, float f) {
        this.samples.set(n, f);
    }

    public int limitIndex(int n) {
        if (n < 0) {
            return 0;
        }
        if (n >= this.samples.getLength()) {
            return this.samples.getLength() - 1;
        }
        return n;
    }

    public void setPlotType(int n) {
        switch (n) {
            case 1: {
                this.plotter = new AChannelPlotterSampleCurve(this, this.getChannelPlotter());
                break;
            }
            case 2: {
                this.plotter = new AChannelPlotterSpectrogram(this, this.getChannelPlotter());
            }
        }
    }

    public AChannelPlotter getChannelPlotter() {
        return (AChannelPlotter)this.getPlotter();
    }

    @Override
    public void setDefaultName() {
        this.setDefaultName("channel", nameCounter++);
    }

    public void setAudible(boolean bl) {
        this.audible = bl;
    }

    public boolean isAudible() {
        return this.audible;
    }

    public int getSampleLength() {
        return this.samples.getLength();
    }

    public float getMaxSampleValue() {
        return this.getMaxSampleValue(0, this.getSampleLength());
    }

    public float getMaxSampleValue(int n, int n2) {
        float f = 0.0f;
        int n3 = this.limitIndex(n);
        int n4 = this.limitIndex(n + n2);
        for (int i = n3; i < n4; ++i) {
            float f2 = Math.abs(this.samples.get(i));
            if (!(f2 > f)) continue;
            f = f2;
        }
        return f;
    }

    public AChannelMask getMask() {
        return this.mask;
    }

    public boolean isMaskEnabled() {
        return this.mask.isEnabled();
    }

    public AChannelMarker getMarker() {
        return this.marker;
    }

    public void setMarker(AChannelMarker aChannelMarker) {
        this.marker = aChannelMarker;
        this.marker.setChannel(this);
    }

    public void setChannelSelection(AChannelSelection aChannelSelection) {
        this.selection = aChannelSelection;
    }

    public void modifyChannelSelection(int n, int n2) {
        if (this.selection != null) {
            ((AChannelSelection)this.selection).setOffset(n);
            ((AChannelSelection)this.selection).setLength(n2);
        } else {
            this.selection = new AChannelSelection(this, n, n2);
        }
    }

    public AChannelSelection getChannelSelection() {
        return (AChannelSelection)this.selection;
    }

    public AChannelSelection getNonEmptyChannelSelection() {
        if (!this.selection.isSelected()) {
            return this.createChannelSelection();
        }
        return this.getChannelSelection();
    }

    public AChannelSelection createChannelSelection() {
        AChannelSelection aChannelSelection = new AChannelSelection(this, 0, this.getSampleLength());
        return aChannelSelection;
    }

    public void setFullChannelSelection() {
        this.setChannelSelection(this.createChannelSelection());
    }

    public void setMarkedChannelSelection(int n) {
        AChannelMarker aChannelMarker = this.getMarker();
        int n2 = aChannelMarker.searchLeftMarker(n);
        int n3 = aChannelMarker.searchRightMarker(n) - n2;
        this.modifyChannelSelection(n2, n3);
    }

    public void setEmptyChannelSelection() {
        this.setChannelSelection(new AChannelSelection(this, 0, 0));
    }

    public GGraphicObjects getGraphicObjects() {
        return this.graphicObjects;
    }
}

