/*
 * Decompiled with CFR 0.152.
 */
package ch.laoe.audio.save;

import ch.laoe.audio.save.ASave;
import javax.sound.sampled.AudioFormat;

public class ASavePcmUnsigned8Bit
extends ASave {
    private int samplePtr = 0;
    private int channelPtr = 0;
    private int bytePtr = 0;

    @Override
    public ASave duplicate() {
        return new ASavePcmUnsigned8Bit();
    }

    @Override
    public boolean supports(AudioFormat audioFormat) {
        return audioFormat.getEncoding() == AudioFormat.Encoding.PCM_UNSIGNED && audioFormat.getSampleSizeInBits() == 8;
    }

    @Override
    public int read() {
        int n = 0;
        if (this.samplePtr < layer.getChannel(this.channelPtr).getSampleLength()) {
            switch (this.bytePtr) {
                case 0: {
                    n = (int)layer.getChannel(this.channelPtr).getSample(this.samplePtr) & 0xFF ^ 0x7F;
                    break;
                }
                case 1: {
                    n = (int)layer.getChannel(this.channelPtr).getSample(this.samplePtr) >> 8 & 0xFF ^ 0x7F;
                }
            }
        }
        ++this.bytePtr;
        this.bytePtr %= 1;
        if (this.bytePtr == 0) {
            ++this.channelPtr;
            this.channelPtr %= this.channels;
            if (this.channelPtr == 0) {
                ++this.samplePtr;
            }
        }
        boolean bl = true;
        for (int i = 0; i < this.channels; ++i) {
            if (this.samplePtr >= layer.getChannel(i).getSampleLength()) continue;
            bl = false;
        }
        if (bl) {
            return -1;
        }
        return n;
    }
}

