/*
 * Decompiled with CFR 0.152.
 */
package ch.laoe.audio.play;

import ch.laoe.audio.play.APlay;
import ch.laoe.clip.AChannel;
import javax.sound.sampled.AudioFormat;

public class APlayPcmSigned16BitLittleEndian
extends APlay {
    private int samplePtr;
    private int channelPtr;
    private int bytePtr;
    private int markPtr;

    public APlayPcmSigned16BitLittleEndian() {
        this.dataBufferLength = 20000;
        this.data = new byte[this.dataBufferLength];
        this.samplePtr = 0;
        this.channelPtr = 0;
        this.bytePtr = 0;
    }

    @Override
    public APlay duplicate() {
        return new APlayPcmSigned16BitLittleEndian();
    }

    @Override
    public boolean supports(AudioFormat audioFormat) {
        return audioFormat.getEncoding() == AudioFormat.Encoding.PCM_SIGNED && audioFormat.getSampleSizeInBits() == 16 && !audioFormat.isBigEndian();
    }

    @Override
    public void mark(int n) {
        this.markPtr = this.samplePtr;
    }

    @Override
    public void reset() {
        this.samplePtr = this.markPtr;
    }

    @Override
    public void goTo(int n) {
        this.samplePtr = n;
        this.bytePtr = 0;
    }

    @Override
    public int read() {
        int n = 0;
        AChannel aChannel = this.layer.getChannel(this.channelPtr);
        if (this.samplePtr < aChannel.getSampleLength()) {
            switch (this.bytePtr) {
                case 0: {
                    n = (int)aChannel.getSample(this.samplePtr) & 0xFF;
                    break;
                }
                case 1: {
                    n = (int)aChannel.getSample(this.samplePtr) >> 8 & 0xFF;
                }
            }
        }
        ++this.bytePtr;
        this.bytePtr %= 2;
        if (this.bytePtr == 0) {
            ++this.channelPtr;
            this.channelPtr %= this.channels;
            if (this.channelPtr == 0) {
                ++this.samplePtr;
            }
        }
        boolean bl = true;
        for (int i = 0; i < this.channels; ++i) {
            if (this.samplePtr >= this.layer.getChannel(i).getSampleLength()) continue;
            bl = false;
        }
        if (bl) {
            return -1;
        }
        return n;
    }
}

