/*
 * Decompiled with CFR 0.152.
 */
package ch.laoe.audio.play;

import ch.laoe.audio.AudioException;
import ch.laoe.clip.ALayer;
import java.io.IOException;
import java.io.InputStream;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Control;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.FloatControl;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;

public abstract class APlay
extends InputStream {
    protected ALayer layer;
    protected int channels;
    protected byte[] data;
    protected int dataBufferLength;
    private AudioFormat audioFormat;
    private AudioInputStream audioInputStream;
    private SourceDataLine line;
    private FloatControl sampleRateControl;
    private int actualSample;

    public abstract APlay duplicate();

    public abstract boolean supports(AudioFormat var1);

    public void setLayer(ALayer aLayer) {
        this.layer = aLayer;
        this.channels = this.layer.getNumberOfChannels();
    }

    public void setAudioFormat(AudioFormat audioFormat) {
        this.audioFormat = audioFormat;
    }

    public void start() throws AudioException {
        try {
            this.audioInputStream = new AudioInputStream(this, this.audioFormat, Long.MAX_VALUE);
            this.line = (SourceDataLine)AudioSystem.getLine(new DataLine.Info(SourceDataLine.class, this.audioFormat, this.dataBufferLength));
            this.line.open();
            this.line.start();
            this.createControls();
        }
        catch (LineUnavailableException lineUnavailableException) {
            throw new AudioException("missingAudioResource");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new AudioException("unsupportedAudioFormat");
        }
    }

    public void flush() {
        this.line.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        try {
            this.audioInputStream.close();
        }
        catch (IOException iOException) {
        }
        finally {
            this.line.stop();
        }
    }

    private void printControls() {
        Control[] controlArray = this.line.getControls();
        System.out.println("controls: ");
        for (int i = 0; i < controlArray.length; ++i) {
            System.out.println(controlArray[i]);
        }
    }

    private void createControls() {
        this.sampleRateControl = this.line.isControlSupported(FloatControl.Type.SAMPLE_RATE) ? (FloatControl)this.line.getControl(FloatControl.Type.SAMPLE_RATE) : null;
    }

    public void changeSampleRate(float f) {
        if (this.sampleRateControl != null) {
            this.sampleRateControl.setValue(f);
        }
    }

    public int write(int n) throws IOException {
        int n2 = this.audioFormat.getSampleSizeInBits() / 8 * this.audioFormat.getChannels();
        int n3 = this.audioInputStream.read(this.data, 0, Math.min(n * n2, this.data.length));
        if (n3 < 0) {
            return -1;
        }
        this.line.write(this.data, 0, n3);
        return n3 / n2;
    }

    public void goTo(int n) {
    }

    public int getActualPosition() {
        return (int)((double)((float)this.line.getMicrosecondPosition() * this.audioFormat.getSampleRate()) / 1000000.0);
    }
}

