/*
 * Decompiled with CFR 0.152.
 */
package ch.laoe.audio.load;

import ch.laoe.audio.AudioException;
import ch.laoe.audio.load.ALoad;
import ch.laoe.audio.load.ALoadPcmSigned16BitBigEndian;
import ch.laoe.audio.load.ALoadPcmSigned16BitLittleEndian;
import ch.laoe.audio.load.ALoadPcmSigned8Bit;
import ch.laoe.audio.load.ALoadPcmUnsigned16BitBigEndian;
import ch.laoe.audio.load.ALoadPcmUnsigned16BitLittleEndian;
import ch.laoe.audio.load.ALoadPcmUnsigned8Bit;
import ch.laoe.audio.load.ALoadUlaw8Bit;
import ch.laoe.ui.Debug;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.UnsupportedAudioFileException;

public class ALoadFactory {
    private static ArrayList classList;

    private static void preloadClasses() {
        classList = new ArrayList();
        classList.add(new ALoadPcmUnsigned8Bit());
        classList.add(new ALoadPcmSigned8Bit());
        classList.add(new ALoadPcmUnsigned16BitLittleEndian());
        classList.add(new ALoadPcmUnsigned16BitBigEndian());
        classList.add(new ALoadPcmSigned16BitLittleEndian());
        classList.add(new ALoadPcmSigned16BitBigEndian());
        classList.add(new ALoadUlaw8Bit());
    }

    public static final ALoad create(File file) throws AudioException {
        try {
            Object object;
            int n;
            AudioInputStream audioInputStream = AudioSystem.getAudioInputStream(file);
            boolean bl = !audioInputStream.getFormat().getEncoding().equals(AudioFormat.Encoding.PCM_UNSIGNED) && !audioInputStream.getFormat().getEncoding().equals(AudioFormat.Encoding.PCM_SIGNED) && !audioInputStream.getFormat().getEncoding().equals(AudioFormat.Encoding.ALAW) && !audioInputStream.getFormat().getEncoding().equals(AudioFormat.Encoding.ULAW);
            AudioFormat.Encoding encoding = AudioFormat.Encoding.PCM_SIGNED;
            if (bl) {
                audioInputStream = AudioSystem.getAudioInputStream(encoding, audioInputStream);
            }
            AudioFormat audioFormat = audioInputStream.getFormat();
            int n2 = 0;
            if (bl) {
                n = 0;
                object = new byte[4096];
                try {
                    while ((n = audioInputStream.read((byte[])object, 0, ((byte[])object).length - 1)) >= 0) {
                        n2 += n;
                    }
                    n2 /= audioInputStream.getFormat().getChannels() * audioInputStream.getFormat().getSampleSizeInBits() / 8;
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            } else {
                n2 = (int)(audioInputStream.getFrameLength() * (long)audioFormat.getFrameSize() / (long)audioFormat.getChannels() / (long)(audioFormat.getSampleSizeInBits() >> 3));
            }
            audioInputStream = AudioSystem.getAudioInputStream(file);
            encoding = AudioFormat.Encoding.PCM_SIGNED;
            if (bl) {
                audioInputStream = AudioSystem.getAudioInputStream(encoding, audioInputStream);
            }
            audioFormat = audioInputStream.getFormat();
            Debug.println(3, "audioformat = " + audioFormat.toString());
            for (n = 0; n < classList.size(); ++n) {
                object = (ALoad)classList.get(n);
                if (!((ALoad)object).supports(audioFormat)) continue;
                object = ((ALoad)object).duplicate();
                ((ALoad)object).setAudioInputStream(audioInputStream, n2);
                ((ALoad)object).setFile(file);
                return object;
            }
            Debug.println(3, "unsupported audioformat = " + audioFormat.toString());
            throw new AudioException("unsupportedAudioFormat");
        }
        catch (UnsupportedAudioFileException unsupportedAudioFileException) {
            Debug.printStackTrace(5, unsupportedAudioFileException);
            throw new AudioException("unsupportedAudioFormat");
        }
        catch (IOException iOException) {
            Debug.printStackTrace(5, iOException);
            throw new AudioException("unsupportedAudioFormat");
        }
    }

    static {
        ALoadFactory.preloadClasses();
    }
}

