/*
 * Decompiled with CFR 0.152.
 */
package ch.laoe.audio.capture;

import ch.laoe.audio.capture.ACapture;
import ch.laoe.clip.ALayer;
import ch.laoe.ui.Debug;
import java.io.IOException;
import javax.sound.sampled.AudioFormat;

public class ACapturePcmUnsigned8Bit
extends ACapture {
    @Override
    public ACapture duplicate() {
        Debug.println(3, "capture PCM unsigned 8bit duplicated");
        return new ACapturePcmUnsigned8Bit();
    }

    @Override
    public boolean supports(AudioFormat audioFormat) {
        return audioFormat.getEncoding() == AudioFormat.Encoding.PCM_UNSIGNED && audioFormat.getSampleSizeInBits() == 8;
    }

    @Override
    public int read(ALayer aLayer, int n, int n2) throws IOException {
        int n3 = aLayer.getNumberOfChannels();
        int n4 = line.read(this.buffer, 0, n2 * n3);
        for (int i = 0; i < n3; ++i) {
            for (int j = 0; j < n4 / n3; ++j) {
                int n5 = j * n3 + i;
                byte by = this.buffer[n5];
                aLayer.getChannel(i).setSample(n + j, by);
            }
        }
        if (n4 >= 0) {
            return n4 / n3;
        }
        return n4;
    }
}

