/*
 * Decompiled with CFR 0.152.
 */
package ch.laoe.audio.capture;

import ch.laoe.audio.capture.ACapture;
import ch.laoe.clip.ALayer;
import ch.laoe.ui.Debug;
import java.io.IOException;
import javax.sound.sampled.AudioFormat;

public class ACapturePcmSigned8Bit
extends ACapture {
    @Override
    public ACapture duplicate() {
        Debug.println(3, "capture PCM signed 8bit duplicated");
        return new ACapturePcmSigned8Bit();
    }

    @Override
    public boolean supports(AudioFormat audioFormat) {
        return audioFormat.getEncoding() == AudioFormat.Encoding.PCM_SIGNED && audioFormat.getSampleSizeInBits() == 8;
    }

    @Override
    public int read(ALayer aLayer, int n, int n2) throws IOException {
        int n3 = aLayer.getNumberOfChannels();
        int n4 = line.read(this.buffer, 0, Math.min(n2 * n3, this.buffer.length));
        for (int i = 0; i < n4 / n3; ++i) {
            for (int j = 0; j < n3; ++j) {
                int n5 = i * n3 + j;
                int n6 = this.buffer[n5];
                if (n6 > 0) {
                    n6 = 128 - n6;
                }
                aLayer.getChannel(j).setSample(n + i, n6);
            }
        }
        if (n4 >= 0) {
            return n4 / n3;
        }
        return n4 / n3;
    }
}

