/*
 * Decompiled with CFR 0.152.
 */
package org.tritonus.share.sampled.mixer;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.sound.sampled.Mixer;
import javax.sound.sampled.spi.MixerProvider;
import org.tritonus.share.TDebug;

public abstract class TMixerProvider
extends MixerProvider {
    private static final Mixer.Info[] EMPTY_MIXER_INFO_ARRAY = new Mixer.Info[0];
    private static Map sm_mixerProviderStructs = new HashMap();
    private boolean m_bDisabled = false;
    private static /* synthetic */ Class class$Lorg$tritonus$share$sampled$mixer$TMixerProvider;

    protected void staticInit() {
    }

    private final MixerProviderStruct getMixerProviderStruct() {
        if (TDebug.TraceMixerProvider) {
            TDebug.out("TMixerProvider.getMixerProviderStruct(): begin");
        }
        Class<?> cls = this.getClass();
        if (TDebug.TraceMixerProvider) {
            TDebug.out("TMixerProvider.getMixerProviderStruct(): called from " + cls);
        }
        Class clazz = class$Lorg$tritonus$share$sampled$mixer$TMixerProvider != null ? class$Lorg$tritonus$share$sampled$mixer$TMixerProvider : (class$Lorg$tritonus$share$sampled$mixer$TMixerProvider = TMixerProvider.class$("org.tritonus.share.sampled.mixer.TMixerProvider"));
        synchronized (clazz) {
            MixerProviderStruct struct = (MixerProviderStruct)sm_mixerProviderStructs.get(cls);
            if (struct == null) {
                if (TDebug.TraceMixerProvider) {
                    TDebug.out("TMixerProvider.getMixerProviderStruct(): creating new MixerProviderStruct for " + cls);
                }
                struct = new MixerProviderStruct();
                sm_mixerProviderStructs.put(cls, struct);
            }
            if (TDebug.TraceMixerProvider) {
                TDebug.out("TMixerProvider.getMixerProviderStruct(): end");
            }
            return struct;
        }
    }

    protected void disable() {
        if (TDebug.TraceMixerProvider) {
            TDebug.out("disabling " + this.getClass().getName());
        }
        this.m_bDisabled = true;
    }

    protected boolean isDisabled() {
        return this.m_bDisabled;
    }

    protected void addMixer(Mixer mixer) {
        MixerProviderStruct struct;
        if (TDebug.TraceMixerProvider) {
            TDebug.out("TMixerProvider.addMixer(): begin");
        }
        MixerProviderStruct mixerProviderStruct = struct = this.getMixerProviderStruct();
        synchronized (mixerProviderStruct) {
            struct.m_mixers.add(mixer);
            if (struct.m_defaultMixer == null) {
                struct.m_defaultMixer = mixer;
            }
        }
        if (TDebug.TraceMixerProvider) {
            TDebug.out("TMixerProvider.addMixer(): end");
        }
    }

    protected void removeMixer(Mixer mixer) {
        MixerProviderStruct struct;
        if (TDebug.TraceMixerProvider) {
            TDebug.out("TMixerProvider.removeMixer(): begin");
        }
        MixerProviderStruct mixerProviderStruct = struct = this.getMixerProviderStruct();
        synchronized (mixerProviderStruct) {
            struct.m_mixers.remove(mixer);
            if (struct.m_defaultMixer == mixer) {
                struct.m_defaultMixer = null;
            }
        }
        if (TDebug.TraceMixerProvider) {
            TDebug.out("TMixerProvider.removeMixer(): end");
        }
    }

    public boolean isMixerSupported(Mixer.Info info) {
        if (TDebug.TraceMixerProvider) {
            TDebug.out("TMixerProvider.isMixerSupported(): begin");
        }
        boolean bIsSupported = false;
        Mixer.Info[] infos = this.getMixerInfo();
        int i = 0;
        while (i < infos.length) {
            if (infos[i].equals(info)) {
                bIsSupported = true;
                break;
            }
            ++i;
        }
        if (TDebug.TraceMixerProvider) {
            TDebug.out("TMixerProvider.isMixerSupported(): end");
        }
        return bIsSupported;
    }

    public Mixer getMixer(Mixer.Info info) {
        if (TDebug.TraceMixerProvider) {
            TDebug.out("TMixerProvider.getMixer(): begin");
        }
        MixerProviderStruct struct = this.getMixerProviderStruct();
        Mixer mixerResult = null;
        MixerProviderStruct mixerProviderStruct = struct;
        synchronized (mixerProviderStruct) {
            if (info == null) {
                mixerResult = struct.m_defaultMixer;
            } else {
                Iterator mixers = struct.m_mixers.iterator();
                while (mixers.hasNext()) {
                    Mixer mixer = (Mixer)mixers.next();
                    if (!mixer.getMixerInfo().equals(info)) continue;
                    mixerResult = mixer;
                    break;
                }
            }
        }
        if (mixerResult == null) {
            throw new IllegalArgumentException("no mixer available for " + info);
        }
        if (TDebug.TraceMixerProvider) {
            TDebug.out("TMixerProvider.getMixer(): end");
        }
        return mixerResult;
    }

    public Mixer.Info[] getMixerInfo() {
        MixerProviderStruct struct;
        if (TDebug.TraceMixerProvider) {
            TDebug.out("TMixerProvider.getMixerInfo(): begin");
        }
        HashSet<Mixer.Info> mixerInfos = new HashSet<Mixer.Info>();
        MixerProviderStruct mixerProviderStruct = struct = this.getMixerProviderStruct();
        synchronized (mixerProviderStruct) {
            Iterator mixers = struct.m_mixers.iterator();
            while (mixers.hasNext()) {
                Mixer mixer = (Mixer)mixers.next();
                mixerInfos.add(mixer.getMixerInfo());
            }
        }
        if (TDebug.TraceMixerProvider) {
            TDebug.out("TMixerProvider.getMixerInfo(): end");
        }
        return mixerInfos.toArray(EMPTY_MIXER_INFO_ARRAY);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public TMixerProvider() {
        if (TDebug.TraceMixerProvider) {
            TDebug.out("TMixerProvider.<init>(): begin");
        }
        if (TDebug.TraceMixerProvider) {
            TDebug.out("TMixerProvider.<init>(): end");
        }
    }

    private class MixerProviderStruct {
        public List m_mixers = new ArrayList();
        public Mixer m_defaultMixer = null;
    }
}

