/*
 * Decompiled with CFR 0.152.
 */
package org.tritonus.share.sampled.convert;

import java.util.Collection;
import java.util.Iterator;
import javax.sound.sampled.AudioFormat;
import org.tritonus.share.ArraySet;
import org.tritonus.share.TDebug;
import org.tritonus.share.sampled.AudioFormats;
import org.tritonus.share.sampled.convert.TFormatConversionProvider;

public abstract class TSimpleFormatConversionProvider
extends TFormatConversionProvider {
    private Collection m_sourceEncodings = new ArraySet();
    private Collection m_targetEncodings = new ArraySet();
    private Collection m_sourceFormats;
    private Collection m_targetFormats;

    protected void disable() {
        if (TDebug.TraceAudioConverter) {
            TDebug.out("TSimpleFormatConversionProvider.disable(): disabling " + this.getClass().getName());
        }
        this.m_sourceEncodings = new ArraySet();
        this.m_targetEncodings = new ArraySet();
        this.m_sourceFormats = new ArraySet();
        this.m_targetFormats = new ArraySet();
    }

    private static final void collectEncodings(Collection formats, Collection encodings) {
        Iterator iterator = formats.iterator();
        while (iterator.hasNext()) {
            AudioFormat format = (AudioFormat)iterator.next();
            encodings.add(format.getEncoding());
        }
    }

    public AudioFormat.Encoding[] getSourceEncodings() {
        return this.m_sourceEncodings.toArray(TFormatConversionProvider.EMPTY_ENCODING_ARRAY);
    }

    public AudioFormat.Encoding[] getTargetEncodings() {
        return this.m_targetEncodings.toArray(TFormatConversionProvider.EMPTY_ENCODING_ARRAY);
    }

    public boolean isSourceEncodingSupported(AudioFormat.Encoding sourceEncoding) {
        return this.m_sourceEncodings.contains(sourceEncoding);
    }

    public boolean isTargetEncodingSupported(AudioFormat.Encoding targetEncoding) {
        return this.m_targetEncodings.contains(targetEncoding);
    }

    public AudioFormat.Encoding[] getTargetEncodings(AudioFormat sourceFormat) {
        if (this.isAllowedSourceFormat(sourceFormat)) {
            return this.getTargetEncodings();
        }
        return TFormatConversionProvider.EMPTY_ENCODING_ARRAY;
    }

    public AudioFormat[] getTargetFormats(AudioFormat.Encoding targetEncoding, AudioFormat sourceFormat) {
        if (this.isConversionSupported(targetEncoding, sourceFormat)) {
            return this.m_targetFormats.toArray(TFormatConversionProvider.EMPTY_FORMAT_ARRAY);
        }
        return TFormatConversionProvider.EMPTY_FORMAT_ARRAY;
    }

    protected boolean isAllowedSourceEncoding(AudioFormat.Encoding sourceEncoding) {
        return this.m_sourceEncodings.contains(sourceEncoding);
    }

    protected boolean isAllowedTargetEncoding(AudioFormat.Encoding targetEncoding) {
        return this.m_targetEncodings.contains(targetEncoding);
    }

    protected boolean isAllowedSourceFormat(AudioFormat sourceFormat) {
        Iterator iterator = this.m_sourceFormats.iterator();
        while (iterator.hasNext()) {
            AudioFormat format = (AudioFormat)iterator.next();
            if (!AudioFormats.matches(format, sourceFormat)) continue;
            return true;
        }
        return false;
    }

    protected boolean isAllowedTargetFormat(AudioFormat targetFormat) {
        Iterator iterator = this.m_targetFormats.iterator();
        while (iterator.hasNext()) {
            AudioFormat format = (AudioFormat)iterator.next();
            if (!AudioFormats.matches(format, targetFormat)) continue;
            return true;
        }
        return false;
    }

    protected Collection getCollectionSourceEncodings() {
        return this.m_sourceEncodings;
    }

    protected Collection getCollectionTargetEncodings() {
        return this.m_targetEncodings;
    }

    protected Collection getCollectionSourceFormats() {
        return this.m_sourceFormats;
    }

    protected Collection getCollectionTargetFormats() {
        return this.m_targetFormats;
    }

    protected static boolean doMatch(int i1, int i2) {
        return i1 == -1 || i2 == -1 || i1 == i2;
    }

    protected static boolean doMatch(float f1, float f2) {
        return f1 == -1.0f || f2 == -1.0f || (double)Math.abs(f1 - f2) < 1.0E-9;
    }

    protected AudioFormat replaceNotSpecified(AudioFormat sourceFormat, AudioFormat targetFormat) {
        boolean bSetSampleSize = false;
        boolean bSetChannels = false;
        boolean bSetSampleRate = false;
        boolean bSetFrameRate = false;
        if (targetFormat.getSampleSizeInBits() == -1 && sourceFormat.getSampleSizeInBits() != -1) {
            bSetSampleSize = true;
        }
        if (targetFormat.getChannels() == -1 && sourceFormat.getChannels() != -1) {
            bSetChannels = true;
        }
        if (targetFormat.getSampleRate() == -1.0f && sourceFormat.getSampleRate() != -1.0f) {
            bSetSampleRate = true;
        }
        if (targetFormat.getFrameRate() == -1.0f && sourceFormat.getFrameRate() != -1.0f) {
            bSetFrameRate = true;
        }
        if (bSetSampleSize || bSetChannels || bSetSampleRate || bSetFrameRate || targetFormat.getFrameSize() == -1 && sourceFormat.getFrameSize() != -1) {
            float sampleRate = bSetSampleRate ? sourceFormat.getSampleRate() : targetFormat.getSampleRate();
            float frameRate = bSetFrameRate ? sourceFormat.getFrameRate() : targetFormat.getFrameRate();
            int sampleSize = bSetSampleSize ? sourceFormat.getSampleSizeInBits() : targetFormat.getSampleSizeInBits();
            int channels = bSetChannels ? sourceFormat.getChannels() : targetFormat.getChannels();
            int frameSize = this.getFrameSize(targetFormat.getEncoding(), sampleRate, sampleSize, channels, frameRate, targetFormat.isBigEndian(), targetFormat.getFrameSize());
            targetFormat = new AudioFormat(targetFormat.getEncoding(), sampleRate, sampleSize, channels, frameSize, frameRate, targetFormat.isBigEndian());
        }
        return targetFormat;
    }

    protected int getFrameSize(AudioFormat.Encoding encoding, float sampleRate, int sampleSize, int channels, float frameRate, boolean bigEndian, int oldFrameSize) {
        if (sampleSize == -1 || channels == -1) {
            return -1;
        }
        return sampleSize * channels / 8;
    }

    protected TSimpleFormatConversionProvider(Collection sourceFormats, Collection targetFormats) {
        this.m_sourceFormats = sourceFormats;
        this.m_targetFormats = targetFormats;
        TSimpleFormatConversionProvider.collectEncodings(this.m_sourceFormats, this.m_sourceEncodings);
        TSimpleFormatConversionProvider.collectEncodings(this.m_targetFormats, this.m_targetEncodings);
    }
}

