/*
 * Decompiled with CFR 0.152.
 */
package org.tritonus.share.sampled.convert;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.sound.sampled.AudioFormat;
import org.tritonus.share.ArraySet;
import org.tritonus.share.sampled.AudioFormats;
import org.tritonus.share.sampled.convert.TFormatConversionProvider;
import org.tritonus.share.sampled.convert.TSimpleFormatConversionProvider;

public abstract class TMatrixFormatConversionProvider
extends TSimpleFormatConversionProvider {
    private Map m_targetEncodingsFromSourceFormat = new HashMap();
    private Map m_targetFormatsFromSourceFormat = new HashMap();

    public AudioFormat.Encoding[] getTargetEncodings(AudioFormat sourceFormat) {
        Iterator iterator = this.m_targetEncodingsFromSourceFormat.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            AudioFormat format = (AudioFormat)entry.getKey();
            if (!AudioFormats.matches(format, sourceFormat)) continue;
            Collection targetEncodings = (Collection)entry.getValue();
            return targetEncodings.toArray(TFormatConversionProvider.EMPTY_ENCODING_ARRAY);
        }
        return TFormatConversionProvider.EMPTY_ENCODING_ARRAY;
    }

    public AudioFormat[] getTargetFormats(AudioFormat.Encoding targetEncoding, AudioFormat sourceFormat) {
        Iterator iterator = this.m_targetFormatsFromSourceFormat.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            AudioFormat format = (AudioFormat)entry.getKey();
            if (!AudioFormats.matches(format, sourceFormat)) continue;
            Map targetEncodings = (Map)entry.getValue();
            Collection targetFormats = (Collection)targetEncodings.get(targetEncoding);
            if (targetFormats != null) {
                return targetFormats.toArray(TFormatConversionProvider.EMPTY_FORMAT_ARRAY);
            }
            return TFormatConversionProvider.EMPTY_FORMAT_ARRAY;
        }
        return TFormatConversionProvider.EMPTY_FORMAT_ARRAY;
    }

    protected TMatrixFormatConversionProvider(List sourceFormats, List targetFormats, boolean[][] abConversionPossible) {
        super(sourceFormats, targetFormats);
        int nSourceFormat = 0;
        while (nSourceFormat < sourceFormats.size()) {
            AudioFormat sourceFormat = (AudioFormat)sourceFormats.get(nSourceFormat);
            ArraySet supportedTargetEncodings = new ArraySet();
            this.m_targetEncodingsFromSourceFormat.put(sourceFormat, supportedTargetEncodings);
            HashMap<AudioFormat.Encoding, Collection> targetFormatsFromTargetEncodings = new HashMap<AudioFormat.Encoding, Collection>();
            this.m_targetFormatsFromSourceFormat.put(sourceFormat, targetFormatsFromTargetEncodings);
            int nTargetFormat = 0;
            while (nTargetFormat < targetFormats.size()) {
                AudioFormat targetFormat = (AudioFormat)targetFormats.get(nTargetFormat);
                if (abConversionPossible[nSourceFormat][nTargetFormat]) {
                    AudioFormat.Encoding targetEncoding = targetFormat.getEncoding();
                    supportedTargetEncodings.add(targetEncoding);
                    Collection supportedTargetFormats = (Collection)targetFormatsFromTargetEncodings.get(targetEncoding);
                    if (supportedTargetFormats == null) {
                        supportedTargetFormats = new ArraySet();
                        targetFormatsFromTargetEncodings.put(targetEncoding, supportedTargetFormats);
                    }
                    supportedTargetFormats.add(targetFormat);
                }
                ++nTargetFormat;
            }
            ++nSourceFormat;
        }
    }
}

