/*
 * Decompiled with CFR 0.152.
 */
package org.tritonus.share.sampled.convert;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import org.tritonus.share.TCircularBuffer;
import org.tritonus.share.TDebug;

public abstract class TAsynchronousFilteredAudioInputStream
extends AudioInputStream
implements TCircularBuffer.Trigger {
    private static int DEFAULT_BUFFER_SIZE = 327670;
    private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    protected TCircularBuffer m_circularBuffer;
    private byte[] m_abSingleByte;

    public int read() throws IOException {
        int nReturn;
        int nByte = -1;
        if (this.m_abSingleByte == null) {
            this.m_abSingleByte = new byte[1];
        }
        nByte = (nReturn = this.read(this.m_abSingleByte)) == -1 ? -1 : this.m_abSingleByte[0] & 0xFF;
        return nByte;
    }

    public int read(byte[] abData) throws IOException {
        int nRead = this.read(abData, 0, abData.length);
        return nRead;
    }

    public int read(byte[] abData, int nOffset, int nLength) throws IOException {
        int nRead = this.m_circularBuffer.read(abData, nOffset, nLength);
        return nRead;
    }

    public long skip(long lSkip) throws IOException {
        long lSkipped = 0L;
        while (lSkipped < lSkip) {
            int nReturn = this.read();
            if (nReturn == -1) {
                return lSkipped;
            }
            ++lSkipped;
        }
        return lSkip;
    }

    public int available() throws IOException {
        return this.m_circularBuffer.availableRead();
    }

    public void close() throws IOException {
        this.m_circularBuffer.close();
    }

    public boolean markSupported() {
        return false;
    }

    public void mark(int nReadLimit) {
    }

    public void reset() throws IOException {
        throw new IOException("mark not supported");
    }

    public abstract void execute();

    public TAsynchronousFilteredAudioInputStream(AudioFormat outputFormat, long lLength) {
        this(outputFormat, lLength, DEFAULT_BUFFER_SIZE);
    }

    public TAsynchronousFilteredAudioInputStream(AudioFormat outputFormat, long lLength, int nBufferSize) {
        super(new ByteArrayInputStream(EMPTY_BYTE_ARRAY), outputFormat, lLength);
        if (TDebug.TraceAudioConverter) {
            TDebug.out("TAsynchronousFilteredAudioInputStream.<init>(): begin");
        }
        this.m_circularBuffer = new TCircularBuffer(nBufferSize, false, true, this);
        if (TDebug.TraceAudioConverter) {
            TDebug.out("TAsynchronousFilteredAudioInputStream.<init>(): end");
        }
    }
}

