/*
 * Decompiled with CFR 0.152.
 */
package org.tritonus.share.sampled;

import java.util.AbstractList;
import java.util.Iterator;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import org.tritonus.share.StringHashedSet;

public class Encodings
extends AudioFormat.Encoding {
    private static StringHashedSet encodings = new StringHashedSet();

    public static AudioFormat.Encoding getEncoding(String name) {
        AudioFormat.Encoding res = (AudioFormat.Encoding)encodings.get(name);
        if (res == null) {
            res = new Encodings(name);
            encodings.add(res);
        }
        return res;
    }

    public static boolean equals(AudioFormat.Encoding e1, AudioFormat.Encoding e2) {
        return e2.toString().equals(e1.toString());
    }

    public static AudioFormat.Encoding[] getEncodings() {
        StringHashedSet iteratedSources = new StringHashedSet();
        StringHashedSet retrievedTargets = new StringHashedSet();
        Iterator sourceFormats = ((AbstractList)encodings).iterator();
        while (sourceFormats.hasNext()) {
            AudioFormat.Encoding source = (AudioFormat.Encoding)sourceFormats.next();
            Encodings.iterateEncodings(source, iteratedSources, retrievedTargets);
        }
        return retrievedTargets.toArray(new AudioFormat.Encoding[retrievedTargets.size()]);
    }

    private static final void iterateEncodings(AudioFormat.Encoding source, StringHashedSet iteratedSources, StringHashedSet retrievedTargets) {
        if (!iteratedSources.contains(source)) {
            iteratedSources.add(source);
            AudioFormat.Encoding[] targets = AudioSystem.getTargetEncodings(source);
            int i = 0;
            while (i < targets.length) {
                AudioFormat.Encoding target = targets[i];
                if (retrievedTargets.add(target.toString())) {
                    Encodings.iterateEncodings(target, iteratedSources, retrievedTargets);
                }
                ++i;
            }
        }
    }

    Encodings(String name) {
        super(name);
    }

    static {
        encodings.add(AudioFormat.Encoding.PCM_SIGNED);
        encodings.add(AudioFormat.Encoding.PCM_UNSIGNED);
        encodings.add(AudioFormat.Encoding.ULAW);
        encodings.add(AudioFormat.Encoding.ALAW);
    }
}

