/*
 * Decompiled with CFR 0.152.
 */
package org.tritonus.share.midi;

import java.io.IOException;
import java.io.InputStream;
import java.util.BitSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import javax.sound.midi.ControllerEventListener;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MetaEventListener;
import javax.sound.midi.MetaMessage;
import javax.sound.midi.MidiDevice;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.Sequence;
import javax.sound.midi.Sequencer;
import javax.sound.midi.ShortMessage;
import javax.sound.midi.Track;
import org.tritonus.share.ArraySet;
import org.tritonus.share.TDebug;
import org.tritonus.share.midi.TMidiDevice;

public abstract class TSequencer
extends TMidiDevice
implements Sequencer {
    private static final float MPQ_BPM_FACTOR = 6.0E7f;
    private static final Sequencer.SyncMode[] EMPTY_SYNCMODE_ARRAY = new Sequencer.SyncMode[0];
    private boolean m_bRunning;
    private Sequence m_sequence;
    private Set m_metaListeners;
    private Set[] m_aControllerListeners;
    private float m_fNominalTempoInMPQ;
    private float m_fTempoFactor;
    private Collection m_masterSyncModes;
    private Collection m_slaveSyncModes;
    private Sequencer.SyncMode m_masterSyncMode;
    private Sequencer.SyncMode m_slaveSyncMode;
    private BitSet m_muteBitSet;
    private BitSet m_soloBitSet;
    private BitSet m_enabledBitSet;

    public void setSequence(Sequence sequence) throws InvalidMidiDataException {
        if (TDebug.TraceSequencer) {
            TDebug.out("TSequencer.setSequence(Sequence): begin");
        }
        this.m_sequence = sequence;
        this.setTempoFactor(1.0f);
        if (TDebug.TraceSequencer) {
            TDebug.out("TSequencer.setSequence(Sequence): end");
        }
    }

    public void setSequence(InputStream inputStream) throws InvalidMidiDataException, IOException {
        if (TDebug.TraceSequencer) {
            TDebug.out("TSequencer.setSequence(InputStream): begin");
        }
        Sequence sequence = MidiSystem.getSequence(inputStream);
        this.setSequence(sequence);
        if (TDebug.TraceSequencer) {
            TDebug.out("TSequencer.setSequence(InputStream): end");
        }
    }

    public Sequence getSequence() {
        if (TDebug.TraceSequencer) {
            TDebug.out("TSequencer.getSequence(): begin");
        }
        if (TDebug.TraceSequencer) {
            TDebug.out("TSequencer.getSequence(): end");
        }
        return this.m_sequence;
    }

    public void start() {
        if (TDebug.TraceSequencer) {
            TDebug.out("TSequencer.start(): begin");
        }
        if (!this.isRunning()) {
            this.m_bRunning = true;
            this.startImpl();
        }
        if (TDebug.TraceSequencer) {
            TDebug.out("TSequencer.start(): end");
        }
    }

    protected void startImpl() {
        if (TDebug.TraceMidiDevice) {
            TDebug.out("TSequencer.startImpl(): begin");
        }
        if (TDebug.TraceMidiDevice) {
            TDebug.out("TSequencer.startImpl(): end");
        }
    }

    public void stop() {
        if (TDebug.TraceSequencer) {
            TDebug.out("TSequencer.stop(): begin");
        }
        if (this.isRunning()) {
            this.stopImpl();
            this.m_bRunning = false;
        }
        if (TDebug.TraceSequencer) {
            TDebug.out("TSequencer.stop(): end");
        }
    }

    protected void stopImpl() {
        if (TDebug.TraceMidiDevice) {
            TDebug.out("TSequencer.stopImpl(): begin");
        }
        if (TDebug.TraceMidiDevice) {
            TDebug.out("TSequencer.stopImpl(): end");
        }
    }

    public boolean isRunning() {
        return this.m_bRunning;
    }

    protected int getResolution() {
        int nResolution;
        Sequence sequence;
        if (TDebug.TraceSequencer) {
            TDebug.out("TSequencer.getResolution(): begin");
        }
        if ((sequence = this.getSequence()) != null) {
            int n = sequence.getResolution();
        } else {
            nResolution = 1;
        }
        if (TDebug.TraceSequencer) {
            TDebug.out("TSequencer.getResolution(): end");
        }
        return nResolution;
    }

    protected float getNominalTempoInMPQ() {
        if (TDebug.TraceSequencer) {
            TDebug.out("TSequencer.getNominalTempoInMPQ(): begin");
        }
        if (TDebug.TraceSequencer) {
            TDebug.out("TSequencer.getNominalTempoInMPQ(): end");
        }
        return this.m_fNominalTempoInMPQ;
    }

    protected void setNominalTempoInMPQ(float fMPQ) {
        if (TDebug.TraceSequencer) {
            TDebug.out("TSequencer.setNominalTempoInMPQ(): begin");
        }
        this.m_fNominalTempoInMPQ = fMPQ;
        this.setRealTempo();
        if (TDebug.TraceSequencer) {
            TDebug.out("TSequencer.setNominalTempoInMPQ(): end");
        }
    }

    protected void setRealTempo() {
        if (TDebug.TraceSequencer) {
            TDebug.out("TSequencer.setRealTempo(): begin");
        }
        float fRealTempo = this.getNominalTempoInMPQ() / this.getTempoFactor();
        if (TDebug.TraceSequencer) {
            TDebug.out("TSequencer.setRealTempo(): real tempo: " + fRealTempo);
        }
        this.setTempoImpl(fRealTempo);
        if (TDebug.TraceSequencer) {
            TDebug.out("TSequencer.setRealTempo(): end");
        }
    }

    public float getTempoInBPM() {
        if (TDebug.TraceSequencer) {
            TDebug.out("TSequencer.getTempoInBPM(): begin");
        }
        float fBPM = 6.0E7f / this.getTempoInMPQ();
        if (TDebug.TraceSequencer) {
            TDebug.out("TSequencer.getTempoInBPM(): end");
        }
        return fBPM;
    }

    public void setTempoInBPM(float fBPM) {
        if (TDebug.TraceSequencer) {
            TDebug.out("TSequencer.setTempoInBPM(): begin");
        }
        float fMPQ = 6.0E7f / fBPM;
        this.setTempoInMPQ(fMPQ);
        if (TDebug.TraceSequencer) {
            TDebug.out("TSequencer.setTempoInBPM(): end");
        }
    }

    public float getTempoInMPQ() {
        if (TDebug.TraceSequencer) {
            TDebug.out("TSequencer.getTempoInMPQ(): begin");
        }
        float fMPQ = this.getNominalTempoInMPQ();
        if (TDebug.TraceSequencer) {
            TDebug.out("TSequencer.getTempoInMPQ(): end");
        }
        return fMPQ;
    }

    public void setTempoInMPQ(float fMPQ) {
        if (TDebug.TraceSequencer) {
            TDebug.out("TSequencer.setTempoInMPQ(): begin");
        }
        this.setNominalTempoInMPQ(fMPQ);
        if (TDebug.TraceSequencer) {
            TDebug.out("TSequencer.setTempoInMPQ(): end");
        }
    }

    public void setTempoFactor(float fFactor) {
        if (TDebug.TraceSequencer) {
            TDebug.out("TSequencer.setTempoFactor(): begin");
        }
        this.m_fTempoFactor = fFactor;
        this.setRealTempo();
        if (TDebug.TraceSequencer) {
            TDebug.out("TSequencer.setTempoFactor(): end");
        }
    }

    public float getTempoFactor() {
        if (TDebug.TraceSequencer) {
            TDebug.out("TSequencer.getTempoFactor(): begin");
        }
        if (TDebug.TraceSequencer) {
            TDebug.out("TSequencer.getTempoFactor(): end");
        }
        return this.m_fTempoFactor;
    }

    protected abstract void setTempoImpl(float var1);

    public long getTickLength() {
        if (TDebug.TraceSequencer) {
            TDebug.out("TSequencer.getTickLength(): begin");
        }
        long lLength = 0L;
        if (this.getSequence() != null) {
            lLength = this.getSequence().getTickLength();
        }
        if (TDebug.TraceSequencer) {
            TDebug.out("TSequencer.getTickLength(): end");
        }
        return lLength;
    }

    public long getMicrosecondLength() {
        if (TDebug.TraceSequencer) {
            TDebug.out("TSequencer.getMicrosecondLength(): begin");
        }
        long lLength = 0L;
        if (this.getSequence() != null) {
            lLength = this.getSequence().getMicrosecondLength();
        }
        if (TDebug.TraceSequencer) {
            TDebug.out("TSequencer.getMicrosecondLength(): end");
        }
        return lLength;
    }

    public boolean addMetaEventListener(MetaEventListener listener) {
        Set set = this.m_metaListeners;
        synchronized (set) {
            return this.m_metaListeners.add(listener);
        }
    }

    public void removeMetaEventListener(MetaEventListener listener) {
        Set set = this.m_metaListeners;
        synchronized (set) {
            this.m_metaListeners.remove(listener);
        }
    }

    protected Iterator getMetaEventListeners() {
        Set set = this.m_metaListeners;
        synchronized (set) {
            return this.m_metaListeners.iterator();
        }
    }

    protected void sendMetaMessage(MetaMessage message) {
        Iterator iterator = this.getMetaEventListeners();
        while (iterator.hasNext()) {
            MetaEventListener metaEventListener = (MetaEventListener)iterator.next();
            MetaMessage copiedMessage = (MetaMessage)message.clone();
            metaEventListener.meta(copiedMessage);
        }
    }

    public int[] addControllerEventListener(ControllerEventListener listener, int[] anControllers) {
        Set[] setArray = this.m_aControllerListeners;
        synchronized (this.m_aControllerListeners) {
            if (anControllers == null) {
                int i = 0;
                while (i < 128) {
                    this.addControllerListener(i, listener);
                    ++i;
                }
            } else {
                int i = 0;
                while (i < anControllers.length) {
                    this.addControllerListener(anControllers[i], listener);
                    ++i;
                }
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return this.getListenedControllers(listener);
        }
    }

    private final void addControllerListener(int i, ControllerEventListener listener) {
        if (this.m_aControllerListeners[i] == null) {
            this.m_aControllerListeners[i] = new ArraySet();
        }
        this.m_aControllerListeners[i].add(listener);
    }

    public int[] removeControllerEventListener(ControllerEventListener listener, int[] anControllers) {
        Set[] setArray = this.m_aControllerListeners;
        synchronized (this.m_aControllerListeners) {
            if (anControllers == null) {
                int i = 0;
                while (i < 128) {
                    this.removeControllerListener(i, listener);
                    ++i;
                }
            } else {
                int i = 0;
                while (i < anControllers.length) {
                    this.removeControllerListener(anControllers[i], listener);
                    ++i;
                }
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return this.getListenedControllers(listener);
        }
    }

    private final void removeControllerListener(int i, ControllerEventListener listener) {
        if (this.m_aControllerListeners[i] != null) {
            this.m_aControllerListeners[i].add(listener);
        }
    }

    private final int[] getListenedControllers(ControllerEventListener listener) {
        int[] anControllers = new int[128];
        int nIndex = 0;
        int nController = 0;
        while (nController < 128) {
            if (this.m_aControllerListeners[nController] != null && this.m_aControllerListeners[nController].contains(listener)) {
                anControllers[nIndex] = nController;
                ++nIndex;
            }
            ++nController;
        }
        int[] anResultControllers = new int[nIndex];
        System.arraycopy(anControllers, 0, anResultControllers, 0, nIndex);
        return anResultControllers;
    }

    protected void sendControllerEvent(ShortMessage message) {
        int nController = message.getData1();
        if (this.m_aControllerListeners[nController] != null) {
            Iterator iterator = this.m_aControllerListeners[nController].iterator();
            while (iterator.hasNext()) {
                ControllerEventListener controllerEventListener = (ControllerEventListener)iterator.next();
                ShortMessage copiedMessage = (ShortMessage)message.clone();
                controllerEventListener.controlChange(copiedMessage);
            }
        }
    }

    protected void notifyListeners(MidiMessage message) {
        if (TDebug.TraceSequencer) {
            TDebug.out("TSequencer.sendToListeners(): begin");
        }
        if (message instanceof MetaMessage) {
            this.sendMetaMessage((MetaMessage)message);
        } else if (message instanceof ShortMessage && ((ShortMessage)message).getCommand() == 176) {
            this.sendControllerEvent((ShortMessage)message);
        }
        if (TDebug.TraceSequencer) {
            TDebug.out("TSequencer.sendToListeners(): end");
        }
    }

    public Sequencer.SyncMode getMasterSyncMode() {
        if (TDebug.TraceSequencer) {
            TDebug.out("TSequencer.getMasterSyncMode(): begin");
        }
        if (TDebug.TraceSequencer) {
            TDebug.out("TSequencer.getMasterSyncMode(): end");
        }
        return this.m_masterSyncMode;
    }

    public void setMasterSyncMode(Sequencer.SyncMode syncMode) {
        if (TDebug.TraceSequencer) {
            TDebug.out("TSequencer.setMasterSyncMode(): begin");
        }
        if (this.m_masterSyncModes.contains(syncMode)) {
            if (!this.getMasterSyncMode().equals(syncMode)) {
                this.m_masterSyncMode = syncMode;
                this.setMasterSyncModeImpl(syncMode);
            }
        } else {
            throw new IllegalArgumentException("sync mode not allowed: " + syncMode);
        }
        if (TDebug.TraceSequencer) {
            TDebug.out("TSequencer.setMasterSyncMode(): end");
        }
    }

    protected void setMasterSyncModeImpl(Sequencer.SyncMode syncMode) {
        if (TDebug.TraceSequencer) {
            TDebug.out("TSequencer.setMasterSyncModeImpl(): begin");
        }
        if (TDebug.TraceSequencer) {
            TDebug.out("TSequencer.setMasterSyncModeImpl(): end");
        }
    }

    public Sequencer.SyncMode[] getMasterSyncModes() {
        if (TDebug.TraceSequencer) {
            TDebug.out("TSequencer.getMasterSyncModes(): begin");
        }
        Sequencer.SyncMode[] syncModes = this.m_masterSyncModes.toArray(EMPTY_SYNCMODE_ARRAY);
        if (TDebug.TraceSequencer) {
            TDebug.out("TSequencer.getMasterSyncModes(): end");
        }
        return syncModes;
    }

    public Sequencer.SyncMode getSlaveSyncMode() {
        if (TDebug.TraceSequencer) {
            TDebug.out("TSequencer.getSlaveSyncMode(): begin");
        }
        if (TDebug.TraceSequencer) {
            TDebug.out("TSequencer.getSlaveSyncMode(): end");
        }
        return this.m_slaveSyncMode;
    }

    public void setSlaveSyncMode(Sequencer.SyncMode syncMode) {
        if (TDebug.TraceSequencer) {
            TDebug.out("TSequencer.setSlaveSyncMode(): begin");
        }
        if (this.m_slaveSyncModes.contains(syncMode)) {
            if (!this.getSlaveSyncMode().equals(syncMode)) {
                this.m_slaveSyncMode = syncMode;
                this.setSlaveSyncModeImpl(syncMode);
            }
        } else {
            throw new IllegalArgumentException("sync mode not allowed: " + syncMode);
        }
        if (TDebug.TraceSequencer) {
            TDebug.out("TSequencer.setSlaveSyncMode(): end");
        }
    }

    protected void setSlaveSyncModeImpl(Sequencer.SyncMode syncMode) {
        if (TDebug.TraceSequencer) {
            TDebug.out("TSequencer.setSlaveSyncModeImpl(): begin");
        }
        if (TDebug.TraceSequencer) {
            TDebug.out("TSequencer.setSlaveSyncModeImpl(): end");
        }
    }

    public Sequencer.SyncMode[] getSlaveSyncModes() {
        if (TDebug.TraceSequencer) {
            TDebug.out("TSequencer.getSlaveSyncModes(): begin");
        }
        Sequencer.SyncMode[] syncModes = this.m_slaveSyncModes.toArray(EMPTY_SYNCMODE_ARRAY);
        if (TDebug.TraceSequencer) {
            TDebug.out("TSequencer.getSlaveSyncModes(): end");
        }
        return syncModes;
    }

    public boolean getTrackSolo(int nTrack) {
        boolean bSoloed = false;
        if (this.getSequence() != null && nTrack < this.getSequence().getTracks().length) {
            bSoloed = this.m_soloBitSet.get(nTrack);
        }
        return bSoloed;
    }

    public void setTrackSolo(int nTrack, boolean bSolo) {
        boolean bOldState;
        if (this.getSequence() != null && nTrack < this.getSequence().getTracks().length && bSolo != (bOldState = this.m_soloBitSet.get(nTrack))) {
            if (bSolo) {
                this.m_soloBitSet.set(nTrack);
            } else {
                this.m_soloBitSet.clear(nTrack);
            }
            this.updateEnabled();
            this.setTrackSoloImpl(nTrack, bSolo);
        }
    }

    protected void setTrackSoloImpl(int nTrack, boolean bSolo) {
    }

    public boolean getTrackMute(int nTrack) {
        boolean bMuted = false;
        if (this.getSequence() != null && nTrack < this.getSequence().getTracks().length) {
            bMuted = this.m_muteBitSet.get(nTrack);
        }
        return bMuted;
    }

    public void setTrackMute(int nTrack, boolean bMute) {
        boolean bOldState;
        if (this.getSequence() != null && nTrack < this.getSequence().getTracks().length && bMute != (bOldState = this.m_muteBitSet.get(nTrack))) {
            if (bMute) {
                this.m_muteBitSet.set(nTrack);
            } else {
                this.m_muteBitSet.clear(nTrack);
            }
            this.updateEnabled();
            this.setTrackMuteImpl(nTrack, bMute);
        }
    }

    protected void setTrackMuteImpl(int nTrack, boolean bMute) {
    }

    private final void updateEnabled() {
        int i;
        boolean bSoloExists;
        BitSet oldEnabledBitSet = (BitSet)this.m_enabledBitSet.clone();
        boolean bl = bSoloExists = this.m_soloBitSet.length() > 0;
        if (bSoloExists) {
            this.m_enabledBitSet = (BitSet)this.m_soloBitSet.clone();
        } else {
            i = 0;
            while (i < this.m_muteBitSet.size()) {
                if (this.m_muteBitSet.get(i)) {
                    this.m_enabledBitSet.clear(i);
                } else {
                    this.m_enabledBitSet.set(i);
                }
                ++i;
            }
        }
        oldEnabledBitSet.xor(this.m_enabledBitSet);
        i = 0;
        while (i < oldEnabledBitSet.size()) {
            if (oldEnabledBitSet.get(i)) {
                this.setTrackEnabledImpl(i, this.m_enabledBitSet.get(i));
            }
            ++i;
        }
    }

    protected void setTrackEnabledImpl(int nTrack, boolean bEnabled) {
    }

    protected boolean isTrackEnabled(int nTrack) {
        return this.m_enabledBitSet.get(nTrack);
    }

    public abstract void startRecording();

    public abstract void stopRecording();

    public abstract boolean isRecording();

    public abstract void recordEnable(Track var1, int var2);

    public abstract void recordDisable(Track var1);

    public abstract long getTickPosition();

    public abstract void setTickPosition(long var1);

    public abstract void setMicrosecondPosition(long var1);

    protected TSequencer(MidiDevice.Info info, Collection masterSyncModes, Collection slaveSyncModes) {
        super(info);
        if (TDebug.TraceSequencer) {
            TDebug.out("TSequencer.<init>(): begin");
        }
        this.m_bRunning = false;
        this.m_sequence = null;
        this.m_metaListeners = new ArraySet();
        this.m_aControllerListeners = new Set[128];
        this.setTempoInMPQ(500000.0f);
        this.setTempoFactor(1.0f);
        this.m_masterSyncModes = masterSyncModes;
        this.m_slaveSyncModes = slaveSyncModes;
        if (this.getMasterSyncModes().length > 0) {
            this.m_masterSyncMode = this.getMasterSyncModes()[0];
        }
        if (this.getSlaveSyncModes().length > 0) {
            this.m_slaveSyncMode = this.getSlaveSyncModes()[0];
        }
        this.m_muteBitSet = new BitSet();
        this.m_soloBitSet = new BitSet();
        this.m_enabledBitSet = new BitSet();
        this.updateEnabled();
        if (TDebug.TraceSequencer) {
            TDebug.out("TSequencer.<init>(): end");
        }
    }
}

