/*
 * Decompiled with CFR 0.152.
 */
package org.tritonus.share;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import javax.sound.sampled.LineEvent;
import javax.sound.sampled.LineListener;
import org.tritonus.share.TDebug;

public class TNotifier
extends Thread {
    public static TNotifier notifier = null;
    private List m_entries = new ArrayList();

    public void addEntry(EventObject event, Collection listeners) {
        List list = this.m_entries;
        synchronized (list) {
            this.m_entries.add(new NotifyEntry(event, listeners));
            this.m_entries.notifyAll();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        while (true) {
            NotifyEntry entry = null;
            List list = this.m_entries;
            synchronized (list) {
                while (true) {
                    if (this.m_entries.size() != 0) {
                        entry = (NotifyEntry)this.m_entries.remove(0);
                        break;
                    }
                    try {
                        this.m_entries.wait();
                    }
                    catch (InterruptedException e) {
                        if (!TDebug.TraceAllExceptions) continue;
                        TDebug.out(e);
                    }
                }
            }
            entry.deliver();
        }
    }

    public TNotifier() {
        super("Tritonus Notifier");
    }

    static {
        notifier = new TNotifier();
        notifier.setDaemon(true);
        notifier.start();
    }

    public static class NotifyEntry {
        private EventObject m_event;
        private List m_listeners;

        public void deliver() {
            Iterator iterator = this.m_listeners.iterator();
            while (iterator.hasNext()) {
                Object listener = iterator.next();
                if (!(listener instanceof LineListener)) continue;
                ((LineListener)listener).update((LineEvent)this.m_event);
            }
        }

        public NotifyEntry(EventObject event, Collection listeners) {
            this.m_event = event;
            this.m_listeners = new ArrayList(listeners);
        }
    }
}

