/*
 * Decompiled with CFR 0.152.
 */
package org.tritonus.share;

import org.tritonus.share.TDebug;

public class TCircularBuffer {
    private boolean m_bBlockingRead;
    private boolean m_bBlockingWrite;
    private byte[] m_abData;
    private int m_nSize;
    private int m_nReadPos;
    private int m_nWritePos;
    private Trigger m_trigger;
    private boolean m_bOpen;

    public void close() {
        this.m_bOpen = false;
    }

    public int availableRead() {
        return this.m_nWritePos - this.m_nReadPos;
    }

    public int availableWrite() {
        return this.m_nSize - this.availableRead();
    }

    private final int getReadPos() {
        return this.m_nReadPos % this.m_nSize;
    }

    private final int getWritePos() {
        return this.m_nWritePos % this.m_nSize;
    }

    public int read(byte[] abData) {
        return this.read(abData, 0, abData.length);
    }

    /*
     * Unable to fully structure code
     */
    public int read(byte[] abData, int nOffset, int nLength) {
        if (TDebug.TraceCircularBuffer) {
            TDebug.out(">TCircularBuffer.read(): called.");
            TDebug.out("m_nReadPos  = " + this.m_nReadPos + " ^= " + this.getReadPos());
            TDebug.out("m_nWritePos = " + this.m_nWritePos + " ^= " + this.getWritePos());
            TDebug.out("availableRead()  = " + this.availableRead());
            TDebug.out("availableWrite() = " + this.availableWrite());
        }
        if (!this.m_bOpen) {
            if (TDebug.TraceCircularBuffer) {
                TDebug.out("< not open. returning -1.");
            }
            return -1;
        }
        var4_4 = this;
        synchronized (var4_4) {
            if (!this.m_bBlockingRead) {
                if (this.m_trigger != null && this.availableRead() < nLength) {
                    if (TDebug.TraceCircularBuffer) {
                        TDebug.out("executing trigger.");
                    }
                    this.m_trigger.execute();
                }
                nLength = Math.min(this.availableRead(), nLength);
            }
            nRemainingBytes = nLength;
            ** GOTO lbl41
            {
                block15: {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e) {
                        if (!TDebug.TraceAllExceptions) break block15;
                        TDebug.out(e);
                    }
                }
                do {
                    if (this.availableRead() == 0) continue block5;
                    nAvailable = Math.min(this.availableRead(), nRemainingBytes);
                    while (nAvailable > 0) {
                        nToRead = Math.min(nAvailable, this.m_nSize - this.getReadPos());
                        System.arraycopy(this.m_abData, this.getReadPos(), abData, nOffset, nToRead);
                        this.m_nReadPos += nToRead;
                        nOffset += nToRead;
                        nAvailable -= nToRead;
                        nRemainingBytes -= nToRead;
                    }
                    this.notifyAll();
lbl41:
                    // 2 sources

                } while (nRemainingBytes > 0);
            }
            if (TDebug.TraceCircularBuffer) {
                TDebug.out("After read:");
                TDebug.out("m_nReadPos  = " + this.m_nReadPos + " ^= " + this.getReadPos());
                TDebug.out("m_nWritePos = " + this.m_nWritePos + " ^= " + this.getWritePos());
                TDebug.out("availableRead()  = " + this.availableRead());
                TDebug.out("availableWrite() = " + this.availableWrite());
                TDebug.out("< completed. Read " + nLength + " bytes");
            }
            return nLength;
        }
    }

    public int write(byte[] abData) {
        return this.write(abData, 0, abData.length);
    }

    /*
     * Unable to fully structure code
     */
    public int write(byte[] abData, int nOffset, int nLength) {
        if (TDebug.TraceCircularBuffer) {
            TDebug.out(">TCircularBuffer.write(): called; nLength: " + nLength);
            TDebug.out("m_nReadPos  = " + this.m_nReadPos + " ^= " + this.getReadPos());
            TDebug.out("m_nWritePos = " + this.m_nWritePos + " ^= " + this.getWritePos());
            TDebug.out("availableRead()  = " + this.availableRead());
            TDebug.out("availableWrite() = " + this.availableWrite());
        }
        var4_4 = this;
        synchronized (var4_4) {
            if (TDebug.TraceCircularBuffer) {
                TDebug.out("entered synchronized block.");
            }
            if (!this.m_bBlockingWrite) {
                nLength = Math.min(this.availableWrite(), nLength);
            }
            nRemainingBytes = nLength;
            ** GOTO lbl35
            {
                block12: {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e) {
                        if (!TDebug.TraceAllExceptions) break block12;
                        TDebug.out(e);
                    }
                }
                do {
                    if (this.availableWrite() == 0) continue block5;
                    nAvailable = Math.min(this.availableWrite(), nRemainingBytes);
                    while (nAvailable > 0) {
                        nToWrite = Math.min(nAvailable, this.m_nSize - this.getWritePos());
                        System.arraycopy(abData, nOffset, this.m_abData, this.getWritePos(), nToWrite);
                        this.m_nWritePos += nToWrite;
                        nOffset += nToWrite;
                        nAvailable -= nToWrite;
                        nRemainingBytes -= nToWrite;
                    }
                    this.notifyAll();
lbl35:
                    // 2 sources

                } while (nRemainingBytes > 0);
            }
            if (TDebug.TraceCircularBuffer) {
                TDebug.out("After write:");
                TDebug.out("m_nReadPos  = " + this.m_nReadPos + " ^= " + this.getReadPos());
                TDebug.out("m_nWritePos = " + this.m_nWritePos + " ^= " + this.getWritePos());
                TDebug.out("availableRead()  = " + this.availableRead());
                TDebug.out("availableWrite() = " + this.availableWrite());
                TDebug.out("< completed. Wrote " + nLength + " bytes");
            }
            return nLength;
        }
    }

    public TCircularBuffer(int nSize, boolean bBlockingRead, boolean bBlockingWrite, Trigger trigger) {
        this.m_bBlockingRead = bBlockingRead;
        this.m_bBlockingWrite = bBlockingWrite;
        this.m_nSize = nSize;
        this.m_abData = new byte[this.m_nSize];
        this.m_nReadPos = 0;
        this.m_nWritePos = 0;
        this.m_trigger = trigger;
        this.m_bOpen = true;
    }

    public static interface Trigger {
        public void execute();
    }
}

