/*
 * Decompiled with CFR 0.152.
 */
package ch.oli4.ui.graph;

import ch.oli4.ui.graph.UiPlot1D;
import ch.oli4.ui.graph.UiPlotModel;
import java.awt.Color;

public abstract class UiPlot2D
extends UiPlot1D {
    protected Color yLabelColor = this.getBackground().darker();
    protected Color yAxisColor = this.getBackground().darker();
    protected boolean yLabelVisible = true;
    protected boolean yAxisVisible = true;
    public double yScaleMin = 0.0;
    public double yScaleMax = 50.0;
    public boolean yAutoScale = true;

    public void setYLabelColor(Color c) {
        this.yLabelColor = c;
        this.repaintPlot();
    }

    public Color getYLabelColor() {
        return this.yLabelColor;
    }

    public void setYAxisColor(Color c) {
        this.yAxisColor = c;
        this.repaintPlot();
    }

    public Color getYAxisColor() {
        return this.yAxisColor;
    }

    public void setYLabelVisible(boolean b) {
        this.yLabelVisible = b;
        this.repaintPlot();
    }

    public boolean getYLabelVisible() {
        return this.yLabelVisible;
    }

    public void setYAxisVisible(boolean b) {
        this.yAxisVisible = b;
        this.repaintPlot();
    }

    public boolean getYAxisVisible() {
        return this.yAxisVisible;
    }

    public void setYScale(double min, double max) {
        this.yAutoScale = false;
        this.yScaleMin = min;
        this.yScaleMax = max;
        if (this.yScaleMax <= this.yScaleMin) {
            this.yScaleMax = this.yScaleMin + 1.0;
        }
        this.repaintPlot();
    }

    public void setYAutoScale(boolean b) {
        this.yAutoScale = b;
        this.repaintPlot();
    }

    protected void doYAutoScale() {
        if (this.yAutoScale) {
            double d = Double.MAX_VALUE;
            int i = 0;
            while (i < this.getNumberOfModels()) {
                d = Math.min(d, (double)((int)((UiPlotModel)this.models.get(i)).getDataMin(1, this.pScaleMin, this.pScaleMax)));
                ++i;
            }
            this.yScaleMin = d;
            d = Double.MIN_VALUE;
            i = 0;
            while (i < this.getNumberOfModels()) {
                d = Math.max(d, (double)((int)((UiPlotModel)this.models.get(i)).getDataMax(1, this.pScaleMin, this.pScaleMax)));
                ++i;
            }
            this.yScaleMax = d;
        }
    }

    public void repaintPlot() {
        this.doPAutoScale();
        this.doXAutoScale();
        this.doYAutoScale();
        this.repaint();
    }
}

