/*
 * Decompiled with CFR 0.152.
 */
package ch.oli4.ui.graph;

import ch.oli4.ui.UiPoint;
import ch.oli4.ui.graph.UiPlot1D;
import ch.oli4.ui.graph.UiPlotDefaultModel;
import ch.oli4.ui.graph.UiPlotModel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class UiPlot1DLine
extends UiPlot1D {
    protected boolean pointVisible = true;
    private UiPoint lineAreaOrigin = new UiPoint();
    private UiPoint lineAreaSize = new UiPoint();
    private UiPoint lineOrigin = new UiPoint();
    private UiPoint lineEnd = new UiPoint();
    private int pLine;
    private int xLine;

    public void setPointVisible(boolean b) {
        this.pointVisible = b;
    }

    public boolean getPointVisible() {
        return this.pointVisible;
    }

    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.lineAreaOrigin.x = this.getWidth() / 10;
        this.lineAreaOrigin.y = this.getHeight() / 10;
        this.lineAreaSize.x = this.getWidth() * 8 / 10;
        this.lineAreaSize.y = this.getHeight() * 8 / 10;
        this.pLine = this.lineAreaOrigin.y + this.lineAreaSize.y + (int)(this.xScaleMin * (double)this.lineAreaSize.y / (this.xScaleMax - this.xScaleMin));
        this.xLine = this.lineAreaOrigin.x;
        if (this.pAxisVisible) {
            g.setColor(this.pLabelColor);
            g.drawLine(0, this.pLine, this.getWidth(), this.pLine);
        }
        if (this.xAxisVisible) {
            g.setColor(this.xLabelColor);
            g.drawLine(this.xLine, 0, this.xLine, this.getHeight());
        }
        int i = 0;
        while (i < this.getNumberOfModels()) {
            UiPlotModel m = (UiPlotModel)this.models.get(i);
            int j = 0;
            while (j < this.pScaleMax - this.pScaleMin + 1) {
                this.lineOrigin.x = this.lineEnd.x;
                this.lineOrigin.y = this.lineEnd.y;
                this.lineEnd.x = this.xLine + this.lineAreaSize.x * j / (this.pScaleMax - this.pScaleMin);
                this.lineEnd.y = this.pLine - (int)(m.getData(j + this.pScaleMin)[0] * (double)this.lineAreaSize.y / (this.xScaleMax - this.xScaleMin));
                if (j == 0) {
                    this.lineOrigin.x = this.lineEnd.x;
                    this.lineOrigin.y = this.lineEnd.y;
                }
                g.setColor(m.getDefaultDataColor());
                g.drawLine(this.lineOrigin.x, this.lineOrigin.y, this.lineEnd.x, this.lineEnd.y);
                if (this.pointVisible) {
                    g.fillRect(this.lineEnd.x - 1, this.lineEnd.y - 1, 3, 3);
                }
                g.setColor(m.getDefaultDataColor());
                if (this.dataVisible) {
                    g.drawString(new Double(m.getData(j + this.pScaleMin)[0]).toString(), this.lineEnd.x, this.lineEnd.y - 4);
                }
                if (this.dataLabelVisible && m.getDataLabel(j + this.pScaleMin) != null) {
                    g.drawString(m.getDataLabel(j + this.pScaleMin), this.lineEnd.x, this.lineEnd.y + 14);
                }
                ++j;
            }
            g.setColor(this.pLabelColor);
            if (this.pLabelVisible && i == 0) {
                g.drawString(m.getLabel(3), this.lineAreaOrigin.x + this.lineAreaSize.x - 15, this.pLine + 13);
            }
            g.setColor(this.xLabelColor);
            if (this.xLabelVisible) {
                g.drawString(m.getLabel(0), this.lineAreaOrigin.x + 3, this.lineAreaOrigin.y - 3 + i * 13);
            }
            ++i;
        }
    }

    public static void main(String[] arg) {
        JFrame f = new JFrame();
        JPanel p = new JPanel();
        p.setLayout(new BorderLayout());
        UiPlot1DLine l = new UiPlot1DLine();
        UiPlotDefaultModel m1 = new UiPlotDefaultModel(l);
        UiPlotDefaultModel m2 = new UiPlotDefaultModel(l);
        UiPlotDefaultModel m3 = new UiPlotDefaultModel(l);
        l.addModel(m1);
        l.addModel(m2);
        l.addModel(m3);
        m1.appendData(-3.0);
        m1.appendData(-1.0);
        m1.appendData(1.0);
        m1.setDataLabel("hi!", 2);
        m1.setDataColor(Color.orange, 2);
        m1.appendData(2.0);
        m1.appendData(2.0);
        m1.appendData(2.0);
        m1.appendData(3.0);
        m1.appendData(3.0);
        m1.appendData(4.0);
        m1.appendData(6.0);
        m1.appendData(9.0);
        m2.appendData(10.0);
        m2.appendData(10.0);
        m2.appendData(9.0);
        m2.appendData(7.0);
        m2.appendData(8.0);
        m2.appendData(9.0);
        m2.appendData(10.0);
        m2.appendData(10.0);
        m2.appendData(3.0);
        m2.appendData(0.0);
        m3.appendData(0.0);
        m3.appendData(0.0);
        m3.appendData(0.0);
        m3.appendData(2.0);
        m3.appendData(1.0);
        l.setPScale(0, 49);
        l.setXScale(-10.0, 20.0);
        l.setDataLabelVisible(true);
        l.setDataVisible(false);
        l.setPointVisible(true);
        m1.setLabel("time", 3);
        m1.setLabel("load", 0);
        m1.setDefaultDataColor(Color.blue);
        m2.setDefaultDataColor(Color.red);
        m3.setDefaultDataColor(Color.yellow);
        p.add((Component)l, "Center");
        f.getContentPane().add(p);
        f.setSize(new Dimension(300, 200));
        f.setVisible(true);
    }
}

