/*
 * Decompiled with CFR 0.152.
 */
package ch.oli4.ui.graph;

import ch.oli4.ui.UiPoint;
import ch.oli4.ui.graph.UiPlot1D;
import ch.oli4.ui.graph.UiPlotDefaultModel;
import ch.oli4.ui.graph.UiPlotModel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class UiPlot1DBar
extends UiPlot1D {
    public static final int HORIZONTAL = 1;
    public static final int VERTICAL = 2;
    private int orientation = 2;
    private UiPoint barAreaOrigin = new UiPoint();
    private UiPoint barAreaSize = new UiPoint();
    private UiPoint barOrigin = new UiPoint();
    private UiPoint barSize = new UiPoint();
    private int pLine;
    private UiPlotModel m;

    public void setOrientation(int o) {
        this.orientation = o;
    }

    public int getOrientation() {
        return this.orientation;
    }

    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        switch (this.orientation) {
            case 1: {
                this.barAreaOrigin.x = this.getWidth() / 10;
                this.barAreaOrigin.y = this.getHeight() / 10;
                this.barAreaSize.x = this.getWidth() * 8 / 10;
                this.barAreaSize.y = this.getHeight() * 8 / 10;
                this.barSize.y = this.barAreaSize.y / (this.pScaleMax - this.pScaleMin + 1);
                this.pLine = this.barAreaOrigin.x - (int)(this.xScaleMin * (double)this.barAreaSize.x / (this.xScaleMax - this.xScaleMin));
                int i = 0;
                while (i < this.pScaleMax - this.pScaleMin + 1) {
                    int j = 0;
                    while (j < this.getNumberOfModels()) {
                        this.m = this.getModel(j);
                        this.barSize.x = (int)(Math.abs(this.m.getData(i + this.pScaleMin)[0]) * (double)this.barAreaSize.x / (this.xScaleMax - this.xScaleMin));
                        this.barOrigin.y = this.barAreaOrigin.y + i * this.barSize.y;
                        this.barOrigin.x = this.m.getData(i + this.pScaleMin)[0] >= 0.0 ? this.pLine : this.pLine - this.barSize.x;
                        g.setColor(this.m.getDataColor(i + this.pScaleMin));
                        g.fillRect(this.barOrigin.x, this.barOrigin.y, this.barSize.x, this.barSize.y);
                        g.setColor(this.pAxisColor);
                        g.drawRect(this.barOrigin.x, this.barOrigin.y, this.barSize.x, this.barSize.y);
                        if (this.dataVisible) {
                            if (this.m.getData(i + this.pScaleMin)[0] >= 0.0) {
                                g.drawString(new Double(this.m.getData(i + this.pScaleMin)[0]).toString(), this.barOrigin.x + this.barSize.x + 2, this.barOrigin.y + this.barSize.y - 2);
                            } else {
                                g.drawString(new Double(this.m.getData(i + this.pScaleMin)[0]).toString(), this.barOrigin.x - 35, this.barOrigin.y + this.barSize.y - 2);
                            }
                        }
                        if (this.dataLabelVisible && this.m.getDataLabel(i + this.pScaleMin) != null) {
                            if (this.m.getData(i + this.pScaleMin)[0] >= 0.0) {
                                g.drawString(this.m.getDataLabel(i + this.pScaleMin), this.barOrigin.x - 25, this.barOrigin.y + this.barSize.y - 2);
                            } else {
                                g.drawString(this.m.getDataLabel(i + this.pScaleMin), this.barOrigin.x + this.barSize.x + 2, this.barOrigin.y + this.barSize.y - 2);
                            }
                        }
                        ++j;
                    }
                    ++i;
                }
                this.m = this.getModel(0);
                if (this.pAxisVisible) {
                    g.setColor(this.getPAxisColor());
                    g.drawLine(this.pLine, 0, this.pLine, this.getHeight());
                }
                if (this.pLabelVisible) {
                    g.setColor(this.getPLabelColor());
                    g.drawString(this.m.getLabel(3), this.pLine + 3, this.barAreaOrigin.y + this.barAreaSize.y + 13);
                }
                if (!this.xLabelVisible) break;
                g.setColor(this.getXLabelColor());
                g.drawString(this.m.getLabel(0), this.barAreaOrigin.x + this.barAreaSize.x - 13, this.barAreaOrigin.y - 3);
                break;
            }
            case 2: {
                this.barAreaOrigin.x = this.getWidth() / 10;
                this.barAreaOrigin.y = this.getHeight() / 10;
                this.barAreaSize.x = this.getWidth() * 8 / 10;
                this.barAreaSize.y = this.getHeight() * 8 / 10;
                this.barSize.x = this.barAreaSize.x / (this.pScaleMax - this.pScaleMin + 1);
                this.pLine = this.barAreaOrigin.y + this.barAreaSize.y + (int)(this.xScaleMin * (double)this.barAreaSize.y / (this.xScaleMax - this.xScaleMin));
                int i = 0;
                while (i < this.pScaleMax - this.pScaleMin + 1) {
                    int j = 0;
                    while (j < this.getNumberOfModels()) {
                        this.m = this.getModel(j);
                        this.barSize.y = (int)(Math.abs(this.m.getData(i + this.pScaleMin)[0]) * (double)this.barAreaSize.y / (this.xScaleMax - this.xScaleMin));
                        this.barOrigin.x = this.barAreaOrigin.x + i * this.barSize.x;
                        this.barOrigin.y = this.m.getData(i + this.pScaleMin)[0] >= 0.0 ? this.pLine - this.barSize.y : this.pLine;
                        g.setColor(this.m.getDataColor(i + this.pScaleMin));
                        g.fillRect(this.barOrigin.x, this.barOrigin.y, this.barSize.x, this.barSize.y);
                        g.setColor(this.pAxisColor);
                        g.drawRect(this.barOrigin.x, this.barOrigin.y, this.barSize.x, this.barSize.y);
                        if (this.dataVisible) {
                            if (this.m.getData(i + this.pScaleMin)[0] >= 0.0) {
                                g.drawString(new Double(this.m.getData(i + this.pScaleMin)[0]).toString(), this.barOrigin.x + 2, this.barOrigin.y - 3);
                            } else {
                                g.drawString(new Double(this.m.getData(i + this.pScaleMin)[0]).toString(), this.barOrigin.x + 2, this.barOrigin.y + this.barSize.y + 13);
                            }
                        }
                        if (this.dataLabelVisible && this.m.getDataLabel(i + this.pScaleMin) != null) {
                            if (this.m.getData(i + this.pScaleMin)[0] >= 0.0) {
                                g.drawString(this.m.getDataLabel(i + this.pScaleMin), this.barOrigin.x + 2, this.barOrigin.y + this.barSize.y + 13);
                            } else {
                                g.drawString(this.m.getDataLabel(i + this.pScaleMin), this.barOrigin.x + 2, this.barOrigin.y - 3);
                            }
                        }
                        ++j;
                    }
                    ++i;
                }
                this.m = this.getModel(0);
                if (this.pAxisVisible) {
                    g.setColor(this.getPAxisColor());
                    g.drawLine(0, this.pLine, this.getWidth(), this.pLine);
                }
                if (this.pLabelVisible) {
                    g.setColor(this.getPLabelColor());
                    g.drawString(this.m.getLabel(3), this.barAreaOrigin.x + this.barAreaSize.x - 15, this.pLine + 13);
                }
                if (!this.xLabelVisible) break;
                g.setColor(this.getXLabelColor());
                g.drawString(this.m.getLabel(0), this.barAreaOrigin.x - 3, this.barAreaOrigin.y - 3);
            }
        }
    }

    public static void main(String[] arg) {
        JFrame f = new JFrame();
        JPanel p = new JPanel();
        p.setLayout(new BorderLayout());
        UiPlot1DBar b = new UiPlot1DBar();
        UiPlotDefaultModel m1 = new UiPlotDefaultModel(b);
        UiPlotDefaultModel m2 = new UiPlotDefaultModel(b);
        UiPlotDefaultModel m3 = new UiPlotDefaultModel(b);
        b.addModel(m1);
        b.addModel(m2);
        b.addModel(m3);
        m1.appendData(-3.0);
        m1.appendData(-1.0);
        m1.appendData(1.0);
        m1.setDataLabel("hi!", 2);
        m1.setDataColor(Color.orange, 2);
        m1.appendData(2.0);
        m1.appendData(2.0);
        m1.appendData(2.0);
        m1.appendData(3.0);
        m1.appendData(3.0);
        m1.appendData(4.0);
        m1.appendData(6.0);
        m1.appendData(9.0);
        m2.appendData(10.0);
        m2.appendData(10.0);
        m2.appendData(9.0);
        m2.appendData(7.0);
        m2.appendData(8.0);
        m2.appendData(9.0);
        m2.appendData(10.0);
        m2.appendData(10.0);
        m2.appendData(3.0);
        m2.appendData(0.0);
        m3.appendData(0.0);
        m3.appendData(0.0);
        m3.appendData(0.0);
        m3.appendData(2.0);
        m3.appendData(1.0);
        b.setXScale(-3.0, 10.0);
        b.setPAutoScale(true);
        b.setDataLabelVisible(true);
        b.setDataVisible(true);
        b.setPLabelVisible(true);
        b.setXLabelVisible(true);
        m1.setLabel("time", 3);
        m1.setLabel("load", 0);
        b.setOrientation(2);
        m1.setDefaultDataColor(Color.blue);
        m2.setDefaultDataColor(Color.red);
        m3.setDefaultDataColor(Color.yellow);
        p.add((Component)b, "Center");
        f.getContentPane().add(p);
        f.setSize(new Dimension(300, 200));
        f.setVisible(true);
    }
}

