/*
 * Decompiled with CFR 0.152.
 */
package ch.oli4.ui.clock;

import ch.oli4.ui.UiPoint;
import ch.oli4.ui.clock.UiClockAnalog;
import ch.oli4.ui.clock.UiClockCountdownModel;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Line2D;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class UiClockAnalogStandard
extends UiClockAnalog
implements MouseListener,
MouseMotionListener {
    protected static final int NO_ZEIGER = 0;
    protected static final int SECOND_ZEIGER = 1;
    protected static final int MINUTE_ZEIGER = 2;
    protected static final int HOUR_ZEIGER = 3;
    protected int selectedZeiger;
    protected static final int selectedAngleMax = 10;
    private UiPoint clockCenter = new UiPoint();
    private int stundenZeigerRadius;
    private int minutenZeigerRadius;
    private int sekundenZeigerRadius;
    private int skalaRadius;
    private int skalaGroesse;
    private int gehaeuseRadius;
    private int gehaeuseRand;

    public UiClockAnalogStandard() {
        this.setPreferredSize(new Dimension(70, 70));
        this.setSecondZeigerColor(Color.red);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    public void mousePressed(MouseEvent e) {
        if (SwingUtilities.isLeftMouseButton(e) && this.enabled) {
            int mouseAngle = this.XYtoAngle(e.getX() - this.clockCenter.x, e.getY() - this.clockCenter.y);
            this.selectedZeiger = this.minuteVisible && Math.abs(this.deltaAngle(this.toMinuteAngle(this.minute), mouseAngle)) < 10 ? 2 : (this.hourVisible && Math.abs(this.deltaAngle(this.toHourAngle(this.hour), mouseAngle)) < 10 ? 3 : (this.secondVisible && Math.abs(this.deltaAngle(this.toSecondAngle(this.second), mouseAngle)) < 10 ? 1 : 0));
        }
    }

    public void mouseReleased(MouseEvent e) {
        if (SwingUtilities.isLeftMouseButton(e)) {
            this.selectedZeiger = 0;
        }
    }

    public void mouseClicked(MouseEvent e) {
        if (SwingUtilities.isLeftMouseButton(e)) {
            this.selectedZeiger = 0;
        }
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mouseMoved(MouseEvent e) {
    }

    public void mouseDragged(MouseEvent e) {
        if (SwingUtilities.isLeftMouseButton(e) && this.enabled) {
            if (this.selectedZeiger == 1) {
                this.adjustSecondZeiger(e.getX() - this.clockCenter.x, e.getY() - this.clockCenter.y);
            } else if (this.selectedZeiger == 2) {
                this.adjustMinuteZeiger(e.getX() - this.clockCenter.x, e.getY() - this.clockCenter.y);
            } else if (this.selectedZeiger == 3) {
                this.adjustHourZeiger(e.getX() - this.clockCenter.x, e.getY() - this.clockCenter.y);
            }
        }
    }

    protected void paintComponent(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        super.paintComponent(g);
        this.clockCenter.x = this.getWidth() / 2;
        this.clockCenter.y = this.getHeight() / 2;
        this.gehaeuseRadius = this.getWidth() < this.getHeight() ? this.getWidth() * 5 / 11 : this.getHeight() * 5 / 11;
        this.gehaeuseRand = this.gehaeuseRadius / 12;
        if (this.gehaeuseRand < 2) {
            this.gehaeuseRand = 2;
        } else if (this.gehaeuseRand > 5) {
            this.gehaeuseRand = 5;
        }
        if (this.gehaeuseVisible) {
            g2d.setStroke(new BasicStroke(1.0f));
            g2d.setColor(this.gehaeuseColor.brighter());
            g2d.fillOval(this.clockCenter.x - this.gehaeuseRadius - this.gehaeuseRand, this.clockCenter.y - this.gehaeuseRadius - this.gehaeuseRand, (this.gehaeuseRadius + this.gehaeuseRand) * 2, (this.gehaeuseRadius + this.gehaeuseRand) * 2);
            g2d.setColor(this.gehaeuseColor.darker());
            g2d.fillArc(this.clockCenter.x - this.gehaeuseRadius - this.gehaeuseRand, this.clockCenter.y - this.gehaeuseRadius - this.gehaeuseRand, (this.gehaeuseRadius + this.gehaeuseRand) * 2, (this.gehaeuseRadius + this.gehaeuseRand) * 2, 225, 180);
            g2d.setColor(this.gehaeuseColor);
            g2d.fillOval(this.clockCenter.x - this.gehaeuseRadius, this.clockCenter.y - this.gehaeuseRadius, this.gehaeuseRadius * 2, this.gehaeuseRadius * 2);
            g2d.setColor(Color.black);
            g2d.drawOval(this.clockCenter.x - this.gehaeuseRadius - this.gehaeuseRand, this.clockCenter.y - this.gehaeuseRadius - this.gehaeuseRand, (this.gehaeuseRadius + this.gehaeuseRand) * 2, (this.gehaeuseRadius + this.gehaeuseRand) * 2);
            g2d.drawOval(this.clockCenter.x - this.gehaeuseRadius, this.clockCenter.y - this.gehaeuseRadius, this.gehaeuseRadius * 2, this.gehaeuseRadius * 2);
        }
        if (this.skalaVisible) {
            this.skalaRadius = this.gehaeuseRadius * 18 / 20;
            this.skalaGroesse = this.gehaeuseRadius / 14;
            if (this.skalaGroesse < 2) {
                this.skalaGroesse = 2;
            } else if (this.skalaGroesse > 6) {
                this.skalaGroesse = 6;
            }
            int i = 0;
            while (i < 12) {
                g2d.setColor(this.skalaColor);
                g2d.fillOval(this.clockCenter.x - (int)(Math.sin((double)i / 6.0 * Math.PI) * (double)this.skalaRadius) - this.skalaGroesse / 2, this.clockCenter.y - (int)(Math.cos((double)i / 6.0 * Math.PI) * (double)this.skalaRadius) - this.skalaGroesse / 2, this.skalaGroesse, this.skalaGroesse);
                ++i;
            }
        }
        if (this.hourVisible) {
            this.stundenZeigerRadius = this.gehaeuseRadius * 12 / 20;
            g2d.setColor(this.hourZeigerColor);
            g2d.setStroke(new BasicStroke((float)this.gehaeuseRadius / 30.0f));
            g2d.draw(new Line2D.Double(this.clockCenter.x, this.clockCenter.y, this.clockCenter.x + this.toHourX(this.stundenZeigerRadius), this.clockCenter.y + this.toHourY(this.stundenZeigerRadius)));
        }
        if (this.minuteVisible) {
            this.minutenZeigerRadius = this.gehaeuseRadius * 18 / 20;
            g2d.setColor(this.minuteZeigerColor);
            g2d.setStroke(new BasicStroke((float)this.gehaeuseRadius / 30.0f));
            g2d.draw(new Line2D.Double(this.clockCenter.x, this.clockCenter.y, this.clockCenter.x + this.toMinuteX(this.minutenZeigerRadius), this.clockCenter.y + this.toMinuteY(this.minutenZeigerRadius)));
        }
        if (this.secondVisible) {
            this.sekundenZeigerRadius = this.gehaeuseRadius * 19 / 20;
            g2d.setColor(this.secondZeigerColor);
            g2d.setStroke(new BasicStroke((float)this.gehaeuseRadius / 50.0f));
            g2d.draw(new Line2D.Double(this.clockCenter.x, this.clockCenter.y, this.clockCenter.x + this.toSecondX(this.sekundenZeigerRadius), this.clockCenter.y + this.toSecondY(this.sekundenZeigerRadius)));
        }
    }

    public static void main(String[] arg) {
        JFrame f = new JFrame();
        JPanel p = new JPanel();
        UiClockAnalogStandard c1 = new UiClockAnalogStandard();
        UiClockAnalogStandard c2 = new UiClockAnalogStandard();
        UiClockCountdownModel m = new UiClockCountdownModel(c1);
        c1.setModel(m);
        c2.setModel(m);
        c1.setEnabled(true);
        c2.setEnabled(false);
        c1.start();
        c2.start();
        p.add(c1);
        p.add(c2);
        f.getContentPane().add(p);
        f.setSize(new Dimension(200, 200));
        f.setVisible(true);
    }
}

