/*
 * Decompiled with CFR 0.152.
 */
package ch.oli4.ui.clock;

import ch.oli4.ui.clock.UiClockEvent;
import ch.oli4.ui.clock.UiClockListener;
import ch.oli4.ui.clock.UiClockModel;
import ch.oli4.ui.clock.UiClockRealtimeModel;
import java.util.Calendar;
import java.util.GregorianCalendar;
import javax.swing.JPanel;

public class UiClock
extends JPanel
implements UiClockListener {
    protected UiClockModel model;
    protected boolean secondVisible;
    protected boolean minuteVisible;
    protected boolean hourVisible;
    protected boolean editable;
    protected boolean enabled;

    public UiClock() {
        this.setModel(new UiClockRealtimeModel(this));
        this.secondVisible = true;
        this.minuteVisible = true;
        this.hourVisible = true;
        this.editable = false;
        this.enabled = false;
    }

    public void setModel(UiClockModel m) {
        if (this.model != null) {
            this.stop();
            this.model.removeClockListener(this);
        }
        this.model = m;
        this.addClockListener(this);
    }

    public UiClockModel getModel() {
        return this.model;
    }

    public void start() {
        this.model.start();
    }

    public void stop() {
        this.model.stop();
    }

    public void setTime(Calendar c) {
        this.model.setTime(c);
    }

    public Calendar getTime() {
        return this.model.getTime();
    }

    public void addClockListener(UiClockListener l) {
        this.model.addClockListener(l);
    }

    public void removeClockListener(UiClockListener l) {
        this.model.removeClockListener(l);
    }

    public void onSecond(UiClockEvent e) {
        System.out.println("on second: " + ((UiClock)e.getSource()).getTime().get(11) + ":" + ((UiClock)e.getSource()).getTime().get(12) + ":" + ((UiClock)e.getSource()).getTime().get(13));
    }

    public void onMinute(UiClockEvent e) {
        System.out.println("on minute...");
    }

    public void onHour(UiClockEvent e) {
        System.out.println("on hour...");
    }

    public void onTrigger(UiClockEvent e) {
        System.out.println("on trigger...");
    }

    public void setSecondVisible(boolean b) {
        this.secondVisible = b;
        this.repaint();
    }

    public boolean isSecondVisible() {
        return this.secondVisible;
    }

    public void setMinuteVisible(boolean b) {
        this.minuteVisible = b;
        this.repaint();
    }

    public boolean isMinuteVisible() {
        return this.minuteVisible;
    }

    public void setHourVisible(boolean b) {
        this.hourVisible = b;
        this.repaint();
    }

    public boolean isHourVisible() {
        return this.hourVisible;
    }

    public void setEditable(boolean b) {
        this.editable = b;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setEnabled(boolean b) {
        this.enabled = b;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public static void main(String[] arg) {
        UiClock c = new UiClock();
        UiClockRealtimeModel m = new UiClockRealtimeModel(c);
        m.setTimeAmplification(60000L);
        c.setModel(m);
        Calendar ca = GregorianCalendar.getInstance();
        ca.set(11, 23);
        ca.set(12, 23);
        ca.set(13, 23);
        c.setTime(ca);
        c.start();
        System.out.println("start at: " + c.getTime().get(11) + ":" + c.getTime().get(12) + ":" + c.getTime().get(13));
    }
}

