/*
 * Decompiled with CFR 0.152.
 */
package ch.oli4.ui;

import ch.oli4.trace.Trace;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Toolkit;
import java.net.URL;
import java.text.DateFormat;
import java.util.Date;
import java.util.Locale;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JFrame;

public class UiToolkit {
    private static ImageIcon defaultIcon = null;
    private static DateFormat dateTimeFormat = DateFormat.getDateTimeInstance(2, 2, Locale.GERMAN);
    private static DateFormat timeFormat = DateFormat.getTimeInstance(2, Locale.GERMAN);
    private static DateFormat dateFormat = DateFormat.getDateInstance(2, Locale.GERMAN);
    public static Color LIGHT_GRAY = new Color(221, 221, 221);
    public static Color LIGHT_GREEN = new Color(119, 255, 119);
    public static Color LIGHT_YELLOW = new Color(255, 255, 153);

    public static void setDefaultIcon(Object source, String iconName) {
        URL u = source.getClass().getResource(iconName);
        if (u != null) {
            defaultIcon = new ImageIcon(u);
        } else {
            Trace.getInstance().addEntry(9, "could not find default icon " + iconName);
            defaultIcon = null;
        }
    }

    public static Icon loadIcon(Object source, String iconName) {
        if (iconName != null) {
            URL u = source.getClass().getResource(iconName);
            if (u != null) {
                return new ImageIcon(u);
            }
            Trace.getInstance().addEntry(9, "could not find icon " + iconName);
        }
        return defaultIcon;
    }

    public static String formatDateTime(long time) {
        return dateTimeFormat.format(new Date(time));
    }

    public static String formatTime(long time) {
        return timeFormat.format(new Date(time));
    }

    public static String formatWhitespaceLessDateTime(long time) {
        String s = String.valueOf(timeFormat.format(new Date(time))) + "_" + dateFormat.format(new Date(time));
        s = s.replace('.', '-');
        s = s.replace(':', '-');
        return s;
    }

    public static void setFrameInMiddleOfScreen(JFrame frame) {
        Dimension size = frame.getSize();
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        int x = Math.max(0, (screen.width - size.width) / 2);
        int y = Math.max(0, (screen.height - size.height) / 2);
        frame.setLocation(x, y);
    }

    public static void setFrameFullScreen(JFrame frame) {
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        frame.setLocation(0, 0);
        frame.setSize(screen);
    }

    public static void setDialogInMiddleOfParentFrame(JDialog dialog, JFrame parent) {
        Point l = parent.getLocation();
        Dimension size = dialog.getSize();
        Dimension pSize = parent.getSize();
        int x = Math.max(0, l.x + (pSize.width - size.width) / 2);
        int y = Math.max(0, l.y + (pSize.height - size.height) / 2);
        dialog.setLocation(x, y);
    }

    public static void expandFrameToRatio(JFrame frame, double width, double height) {
        int w = (int)Math.max((double)frame.getWidth(), (double)frame.getHeight() * width / height);
        int h = (int)Math.max((double)frame.getHeight(), (double)frame.getWidth() * height / width);
        frame.setSize(w, h);
    }

    public static void compressFrameToRatio(JFrame frame, double width, double height) {
        int w = (int)Math.min((double)frame.getWidth(), (double)frame.getHeight() * width / height);
        int h = (int)Math.min((double)frame.getHeight(), (double)frame.getWidth() * height / width);
        frame.setSize(w, h);
    }

    public static Color mixColors(Color c1, Color c2, float c2Part) {
        float[] rgba1 = c1.getRGBComponents(null);
        float[] rgba2 = c2.getRGBComponents(null);
        int i = 0;
        while (i < 4) {
            rgba1[i] = rgba1[i] * (1.0f - c2Part) + rgba2[i] * c2Part;
            ++i;
        }
        return new Color(rgba1[0], rgba1[1], rgba1[2], rgba1[3]);
    }
}

