/*
 * Decompiled with CFR 0.152.
 */
package ch.oli4.ui;

import ch.oli4.ui.UiCartesianLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.Timer;

public class UiProgressViewer
extends JFrame {
    private JPanel panel;
    private JLabel note;
    private JProgressBar percent;
    private JButton cancel;
    private static UiProgressViewer progressViewer = new UiProgressViewer();
    private static final Timer t = new Timer(1000, new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            progressViewer.setVisible(false);
            t.stop();
        }
    });
    private long timeStamp;
    private static int updatePeriod = 20;
    private static final int maxSubProgressDepth = 10;
    private int[] progressStep;
    private int[] progressOffset;
    private String[] progressNotes;
    private int subProgressDepth;

    protected UiProgressViewer() {
        this.initProgress();
        this.setDefaultCloseOperation(1);
        this.panel = new JPanel();
        UiCartesianLayout cl = new UiCartesianLayout(this.panel, 10, 2);
        cl.setPreferredCellSize(new Dimension(35, 25));
        this.panel.setLayout(cl);
        this.note = new JLabel("...", 0);
        cl.add(this.note, 0, 0, 10, 1);
        this.percent = new JProgressBar(0, 0, 100);
        this.percent.setStringPainted(true);
        this.percent.setForeground(Color.red);
        cl.add(this.percent, 0, 1, 10, 1);
        this.cancel = new JButton("cancel");
        this.getContentPane().add(this.panel);
        this.pack();
        this.setLocation((int)(this.getToolkit().getScreenSize().getWidth() - (double)this.getWidth()) / 2, (int)(this.getToolkit().getScreenSize().getHeight() - (double)this.getHeight()) / 2);
        this.setResizable(false);
        this.setVisible(false);
    }

    private void paintImmediately() {
        this.panel.paintImmediately(0, 0, this.getWidth(), this.getHeight());
    }

    public static void start(String title) {
        progressViewer._start(title);
    }

    public static void finish() {
        progressViewer._finish();
    }

    public static void entrySubProgress(String note) {
        progressViewer._entrySubProgress(note);
    }

    public static void entrySubProgress() {
        progressViewer._entrySubProgress(null);
    }

    public static void exitSubProgress() {
        progressViewer._exitSubProgress();
    }

    public static boolean setProgress(int percent) {
        return progressViewer._setProgress(percent);
    }

    public static int getProgress() {
        return UiProgressViewer.progressViewer.percent.getValue();
    }

    public static void setNote(String note) {
        progressViewer.printNote(note);
    }

    private void _start(String title) {
        this.setTitle(String.valueOf(title) + "...");
        this.clearProgress();
        UiProgressViewer.setNote(title);
        this.setVisible(true);
        this.setState(0);
        this.paintImmediately();
    }

    private void _finish() {
        this.printProgress(100);
        this.printNote("ok");
        t.start();
    }

    private boolean isEnoughTimeElapsed() {
        long t = System.currentTimeMillis();
        if (t - this.timeStamp > (long)updatePeriod) {
            this.timeStamp = t;
            return true;
        }
        return false;
    }

    public static void setUpdatePeriod(int period) {
        updatePeriod = period < 20 ? 20 : (period > 1000 ? 1000 : period);
    }

    private void initProgress() {
        this.progressStep = new int[10];
        this.progressOffset = new int[10];
        this.progressNotes = new String[10];
        this.subProgressDepth = 0;
    }

    private void clearProgress() {
        this.printProgress(0);
        int i = 0;
        while (i < this.subProgressDepth) {
            this.progressOffset[i] = 0;
            this.progressStep[i] = 0;
            ++i;
        }
        this.subProgressDepth = 0;
    }

    private void _entrySubProgress(String note) {
        if (this.subProgressDepth < 9) {
            ++this.subProgressDepth;
            this.progressStep[this.subProgressDepth] = 0;
            this.progressOffset[this.subProgressDepth] = 0;
            this.progressNotes[this.subProgressDepth] = note;
            this.calculateGlobalNote();
        }
    }

    private void _exitSubProgress() {
        if (this.subProgressDepth > 0) {
            --this.subProgressDepth;
        }
    }

    private boolean _setProgress(int percent) {
        int n = this.subProgressDepth;
        this.progressOffset[n] = this.progressOffset[n] + this.progressStep[this.subProgressDepth];
        this.progressStep[this.subProgressDepth] = percent - this.progressOffset[this.subProgressDepth];
        this.calculateGlobalProgress();
        if (this.cancel.isSelected()) {
            System.out.println("caaaaaaaaaaancel");
            return true;
        }
        return false;
    }

    private void calculateGlobalProgress() {
        if (progressViewer.isEnoughTimeElapsed()) {
            int p = 0;
            int i = this.subProgressDepth;
            while (i >= 1) {
                if (this.progressStep[i] != 0 || this.progressOffset[i] != 0) {
                    p = p * this.progressStep[i] / 100 + this.progressOffset[i];
                }
                --i;
            }
            this.printProgress(p);
        }
    }

    private void printProgress(int percent) {
        this.percent.setValue(percent);
        this.percent.setString(percent + "%");
        this.paintImmediately();
    }

    private void calculateGlobalNote() {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i <= this.subProgressDepth) {
            if (this.progressNotes[i] != null) {
                if (sb.length() > 0) {
                    sb.append(" ");
                }
                sb.append(this.progressNotes[i]);
            }
            ++i;
        }
        this.printNote(new String(sb));
    }

    private void clearNote() {
        this.printNote("");
        int i = 0;
        while (i < this.subProgressDepth) {
            this.progressNotes[i] = null;
            ++i;
        }
    }

    private void printNote(String note) {
        this.note.setText(note);
        this.paintImmediately();
    }
}

