/*
 * Decompiled with CFR 0.152.
 */
package ch.oli4.ui;

import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class UiLanguage {
    private ResourceBundle textBundle;
    private String file;
    private String language;
    private String country;

    public UiLanguage(String file) {
        this.file = file;
        this.setLanguage("en", "");
    }

    public void setLanguage(String language, String country) {
        try {
            this.language = language;
            this.country = country;
            this.textBundle = ResourceBundle.getBundle(this.file, new Locale(language, country));
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
    }

    public void setLanguage(String language) {
        this.setLanguage(language, "");
    }

    public String getActualLanguage() {
        return this.language;
    }

    public String[] getAllLanguages() {
        return new String[]{"en", "de", "fr"};
    }

    public String getText(String t) {
        try {
            return this.textBundle.getString(t);
        }
        catch (MissingResourceException e) {
            return t;
        }
    }

    public String translate(String t) {
        return this.getText(t);
    }
}

