/*
 * Decompiled with CFR 0.152.
 */
package ch.oli4.persistence;

import ch.oli4.persistence.PersistenceException;
import java.util.WeakHashMap;

public abstract class Persistence {
    private WeakHashMap<PersistenceListener, Object> listeners = new WeakHashMap();

    public void addPersistanceListener(PersistenceListener l) {
        this.listeners.put(l, null);
    }

    protected void fireOnBackup() {
        for (PersistenceListener l : this.listeners.keySet()) {
            l.onBackup(this);
        }
    }

    public abstract void restore(String var1) throws PersistenceException;

    public abstract void backup() throws PersistenceException;

    public abstract boolean contains(String var1);

    public abstract void setString(String var1, String var2);

    public abstract void setInt(String var1, int var2);

    public abstract void setFloat(String var1, float var2);

    public abstract void setDouble(String var1, double var2);

    public abstract void setBoolean(String var1, boolean var2);

    public abstract String getString(String var1);

    public abstract int getInt(String var1);

    public abstract float getFloat(String var1);

    public abstract double getDouble(String var1);

    public abstract boolean getBoolean(String var1);

    public static interface PersistenceListener {
        public void onBackup(Persistence var1);
    }
}

